/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.exceptions;

import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;

public class DWMethodNotFoundException
extends DWException {
    private static final String ERROR_CODE = "11005";

    public String getErrorCode() {
        return ERROR_CODE;
    }

    public DWMethodNotFoundException() {
    }

    public DWMethodNotFoundException(String moduleName, String serviceName, String methodName, DWParameters parameters) {
        super(ERROR_CODE, DWMethodNotFoundException.createMessage(moduleName, serviceName, methodName, parameters), new String[]{moduleName, serviceName, methodName, String.join((CharSequence)",", parameters.getNames())});
    }

    private static String createMessage(String moduleName, String serviceName, String methodName, DWParameters parameters) {
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        return DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle(ERROR_CODE, ERROR_CODE, moduleName, serviceName, methodName, String.join((CharSequence)",", parameters.getNames()));
    }
}

