/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.common.DWResourceUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public abstract class BaseDWCSVReader {
    private List<CSVRecord> csvRecords;

    public BaseDWCSVReader(String csvFileName, int dataStartIndex, String[] fileHeaderMapping) {
        try {
            this.initial(csvFileName, dataStartIndex, fileHeaderMapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initial(String csvFileName, int dataStartIndex, String[] fileHeaderMapping) throws Exception {
        URL csvFileUrl = DWResourceUtils.getPlatformResource(csvFileName).toURI().toURL();
        InputStream input = csvFileUrl.openStream();
        InputStreamReader reader = new InputStreamReader(input);
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withHeader(fileHeaderMapping);
        CSVParser csvFileParser = new CSVParser((Reader)reader, csvFileFormat);
        this.csvRecords = csvFileParser.getRecords();
        csvFileParser.close();
        this.csvRecords = this.csvRecords.subList(dataStartIndex, this.csvRecords.size());
    }

    public List<CSVRecord> getCSVRecords() {
        return this.csvRecords;
    }
}

