/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.restful;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class DWRestfulRequest {
    private Map<String, Object> pathVariable = new HashMap<String, Object>();
    private Map<String, Object> requestParam = new HashMap<String, Object>();
    private byte[] body = null;
    private String path = null;
    private String[] paths = null;

    public DWRestfulRequest(byte[] body, String path, Map<String, Object> pathVariable, Map<String, Object> requestParam) {
        this.body = body;
        this.path = path;
        this.pathStandardization();
        this.pathVariable = pathVariable;
        this.requestParam = requestParam;
        this.paths = this.path.split("/");
    }

    private void pathStandardization() {
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public Map<String, Object> getPathVariable() {
        return this.pathVariable;
    }

    public Map<String, Object> getRequestParam() {
        return this.requestParam;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }
}

