/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.util.Stack;

public class DWGroupServiceInvocationProcessor
implements DWServiceInvocationProcessor {
    private static ThreadLocal<Stack<String>> _currentModuleNames = new ThreadLocal();

    @Override
    public void beforeInvoke(DWServiceLocationInfo locationInfo) {
        String moduleName = DWServiceContext.getContext().getGroupName();
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
        }
        currentModuleNames.push(moduleName == null ? locationInfo.getGroup() : moduleName);
        _currentModuleNames.set(currentModuleNames);
    }

    @Override
    public void onInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWServiceContext.getContext().setGroupName(locationInfo.getGroup());
    }

    @Override
    public void afterInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
            currentModuleNames.push(locationInfo.getGroup());
        }
        String currentModuleName = currentModuleNames.pop();
        DWServiceContext.getContext().setGroupName(currentModuleName);
        if (currentModuleNames.empty()) {
            currentModuleNames.push(currentModuleName);
        }
        _currentModuleNames.set(currentModuleNames);
    }

    @Override
    public void beforeInvoke(DWHeader header, DWMethod method) {
        String groupName = DWServiceContext.getContext().getGroupName();
        if (groupName == null) {
            groupName = header.getModuleName();
        }
        DWServiceContext.getContext().setGroupName(groupName);
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
        }
        currentModuleNames.push(groupName);
        _currentModuleNames.set(currentModuleNames);
    }

    @Override
    public void onInvoke(DWHeader header, DWMethod method, Object service) {
        DWServiceContext.getContext().setGroupName(header.getModuleName());
    }

    @Override
    public void afterInvoke(DWHeader header, DWMethod method, Object service) {
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
            currentModuleNames.push(header.getModuleName());
        }
        String currentModuleName = currentModuleNames.pop();
        DWServiceContext.getContext().setGroupName(currentModuleName);
        if (currentModuleNames.empty()) {
            currentModuleNames.push(currentModuleName);
        }
        _currentModuleNames.set(currentModuleNames);
    }
}

