/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWModuleClassScanHelper;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWModuleJarScanHelper<T>
extends DWModuleScanHelper<T> {
    protected static Log _log = LogFactory.getLog(DWModuleJarScanHelper.class);

    public DWModuleJarScanHelper() {
        super("jar");
    }

    public DWModuleJarScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths) {
        super(platformModulePaths, applicationModulePaths, "jar");
    }

    protected abstract void onClassScan(String var1, DWModuleClassLoader var2, String var3, Class<?> var4, T var5);

    @Override
    protected DWModuleClassLoader getClassLoader(String moduleName, DWModuleFileInfo fileInfo) {
        String directoryName = fileInfo.getDirectoryLayer();
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByExactName(directoryName);
        if (moduleClassLoader == null) {
            moduleClassLoader = fileInfo.isPlatformModule() ? this.getPlatformModuleClassLoader(moduleName) : this.getApplicationModuleClassLoader(moduleName);
            DWModuleClassLoader.addModuleClassLoader(moduleName, moduleClassLoader, fileInfo);
        }
        return moduleClassLoader;
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, T scanContext) {
        for (DWModuleFileInfo fileInfo : fileInfoList) {
            File[] files = fileInfo.getFiles();
            DWModuleClassLoader classLoader = this.getClassLoader(moduleName, fileInfo);
            for (File file : files) {
                try {
                    JarFile jarFile = new JarFile(file);
                    this.onJarScan(moduleName, jarFile, classLoader, scanContext);
                }
                catch (Exception e) {
                    this.onJarScanFiled(moduleName, file, e);
                }
            }
        }
    }

    protected void onJarScan(String moduleName, JarFile jarFile, DWModuleClassLoader classLoader, T scanContext) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
            String className = jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6);
            try {
                Class clazz = classLoader.loadClass(className);
                this.onClassScan(moduleName, classLoader, jarFile.getName(), clazz, scanContext);
            }
            catch (Throwable e) {
                this.onClassScanFailed(moduleName, jarFile, className, e);
            }
        }
        try {
            jarFile.close();
        }
        catch (Exception e) {
            DWModuleClassScanHelper._log.error((Object)("file=" + jarFile.getName() + " can't close properly!"), (Throwable)e);
        }
    }

    protected void onJarScanFiled(String moduleName, File file, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName()).append(" scan failed!");
        DWModuleClassScanHelper._log.error((Object)message.toString(), (Throwable)e);
    }

    protected void onClassScanFailed(String moduleName, JarFile file, String className, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName());
        message.append(" class=").append(className).append(" scan failed!");
        _log.error((Object)message, e);
    }
}

