/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.ServiceFuse;
import com.digiwin.app.container.exceptions.DWParameterCastException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.AllowCrossTenant;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class DWMethod {
    private static Log log = LogFactory.getLog(DWMethod.class);
    private Method method = null;
    protected Boolean allowAnonymous = null;
    protected Boolean allowCrossTenant = null;
    protected Annotation[] methodAnnotations = null;

    public DWMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean allowAnonymous() {
        if (this.allowAnonymous == null) {
            this.allowAnonymous = this.method.isAnnotationPresent(AllowAnonymous.class);
        }
        return this.allowAnonymous;
    }

    public boolean allowCrossTenant() {
        if (this.allowCrossTenant == null) {
            this.allowCrossTenant = this.method.isAnnotationPresent(AllowCrossTenant.class);
        }
        return this.allowCrossTenant;
    }

    public boolean isMatch(DWParameters parameters) {
        return DWMethod.isMatch(this.method, parameters);
    }

    public static boolean isMatch(Method method, DWParameters parameters) {
        String[] parameterNames;
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Parameter item : parameterList) {
            nameList.add(item.getName());
        }
        if (parameterList.length != parameters.getCount()) {
            return false;
        }
        for (String name : parameterNames = parameters.getNames()) {
            if (!nameList.contains(name)) {
                return false;
            }
            nameList.remove(name);
        }
        return true;
    }

    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = this.method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        Object[] invokeParameterList = new Object[parameterList.length];
        for (int i = 0; i < parameterList.length; ++i) {
            Object invokeParameter = null;
            try {
                invokeParameter = parameters.getValue(parameterList[i]);
            }
            catch (Exception ex) {
                throw new DWParameterCastException(parameterList[i].getName(), parameterList[i].getType(), ex);
            }
            invokeParameterList[i] = invokeParameter;
        }
        InboundConfig inboundConfig = null;
        OutboundConfig outboundConfig = null;
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = SpringContextUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWMethod] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWMethod] stackTrace: " + stackTrace));
        }
        if (this.method.isAnnotationPresent(FuseInbound.class)) {
            FuseInbound fuseInbound = this.method.getAnnotation(FuseInbound.class);
            inboundConfig = InboundConfig.create((FuseInbound)fuseInbound);
            inboundConfig.setCollectorRegistry(collectorRegistry);
        }
        if (this.method.isAnnotationPresent(FuseOutbound.class)) {
            FuseOutbound fuseOutbound = this.method.getAnnotation(FuseOutbound.class);
            outboundConfig = OutboundConfig.create((FuseOutbound)fuseOutbound);
            outboundConfig.setCollectorRegistry(collectorRegistry);
        }
        ServiceFuse serviceFuse = new ServiceFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("method", (Object)this.method);
        fuseParameter.set("service", service);
        fuseParameter.set("invokeParameterList", (Object)invokeParameterList);
        DWFuseReturnResponse fuseReturnResponse = new DWFuseReturnResponse();
        DWFuseOption option = DWFuseOption.getDefaultOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWMethod] option: " + option));
        fuseReturnResponse = DWFuseExecutor.execute((DWReturnFuse)serviceFuse, (DWFuseParameter)fuseParameter, (InboundConfig)inboundConfig, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        return fuseReturnResponse.getResponse();
    }

    public Map<String, Class<?>> getParameterInfo() {
        Parameter[] parameters;
        LinkedHashMap parameterInfo = new LinkedHashMap();
        for (Parameter parameter : parameters = this.method.getParameters()) {
            parameterInfo.put(parameter.getName(), parameter.getType());
        }
        return parameterInfo;
    }
}

