/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.common.DWXClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class DWModuleClassLoader
extends DWXClassLoader {
    private static final String KEY_DEFAULT = "default";
    private final ClassLoader applicationClassLoader;
    private static String otherModuleResourceNameSeparator = "#";
    private String moduleName;
    private List<String> services = new ArrayList<String>();
    private static Map<String, DWModuleClassLoader> moduleClassLoaders = new HashMap<String, DWModuleClassLoader>();
    private static ThreadLocal<String> _moduleInfo;
    Map<String, URL> configFileURLs = new HashMap<String, URL>();
    private static ClassLoader userDefinedClassLoader;

    public static void setOtherModuleResourceNameSeparator(String separator) {
        otherModuleResourceNameSeparator = separator;
    }

    public static void setCurrentModuleName(String moduleName) {
        if (_moduleInfo == null) {
            _moduleInfo = new ThreadLocal();
        }
        _moduleInfo.set(moduleName);
        ClassLoader moduleClassLoader = DWModuleClassLoader.getModuleOrUserDefinedClassLoaderByModuleName(moduleName);
        if (moduleClassLoader != null) {
            Thread.currentThread().setContextClassLoader(moduleClassLoader);
        }
    }

    public static String getCurrentModuleName() {
        if (_moduleInfo == null) {
            return null;
        }
        return _moduleInfo.get();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public DWModuleClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public DWModuleClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.applicationClassLoader = parent;
    }

    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            if (this.applicationClassLoader != null) {
                try {
                    c = this.applicationClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private static boolean containsSeparator(String resourceName) {
        return otherModuleResourceNameSeparator != null && !otherModuleResourceNameSeparator.isEmpty() && resourceName.contains(otherModuleResourceNameSeparator);
    }

    public URL getResource(String name) {
        if (name != null) {
            if (this.configFileURLs.containsKey(name.toLowerCase())) {
                return this.configFileURLs.get(name.toLowerCase());
            }
            if (DWModuleClassLoader.containsSeparator(name)) {
                String[] parts = name.split(Pattern.quote(otherModuleResourceNameSeparator));
                String moduleName = parts[0];
                String realResourceName = parts[1];
                ClassLoader classLoader = DWModuleClassLoader.getModuleOrUserDefinedClassLoaderByModuleName(moduleName);
                return classLoader.getResource(realResourceName);
            }
        }
        URL url = null;
        if (this.applicationClassLoader != null) {
            url = this.applicationClassLoader.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        String xJarIndexResourceName = "XJAR-INF/INDEXES.IDX";
        if (name.equals(xJarIndexResourceName)) {
            return super.getResources(name);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.applicationClassLoader != null) {
            urls.addAll(Collections.list(this.applicationClassLoader.getResources(name)));
        }
        urls.addAll(Collections.list(this.findResources(name)));
        ClassLoader parent = this.getParent();
        if (parent != null) {
            urls.addAll(Collections.list(parent.getResources(name)));
        }
        return Collections.enumeration(urls);
    }

    public InputStream getResourceAsStream(String name) {
        if (name != null) {
            if (this.configFileURLs.containsKey(name.toLowerCase())) {
                try {
                    URL url = this.configFileURLs.get(name);
                    File file = new File(url.toURI());
                    return new FileInputStream(file);
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
            if (DWModuleClassLoader.containsSeparator(name)) {
                String[] parts = name.split(Pattern.quote(otherModuleResourceNameSeparator));
                String targetModuleName = parts[0];
                String realResourceName = parts[1];
                ClassLoader classLoader = DWModuleClassLoader.getModuleOrUserDefinedClassLoaderByModuleName(targetModuleName);
                return classLoader.getResourceAsStream(realResourceName);
            }
        }
        return super.getResourceAsStream(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\n");
        return sb.toString();
    }

    public void addServiceJarURL(URL url) {
        this.addURL(url);
    }

    public void addServiceInfo(String className) {
        if (!this.services.contains(className)) {
            this.services.add(className);
        }
    }

    @Deprecated
    public void addConfigFileURL(String fileName, URL url) {
    }

    public boolean hasService(String className) {
        return this.services.contains(className);
    }

    public List<String> getServiceInfo() {
        return Collections.unmodifiableList(this.services);
    }

    @Deprecated
    public static void addModuleClassLoader(String moduleName, DWModuleClassLoader classLoader) {
        String realModuleName;
        classLoader.moduleName = realModuleName = moduleName == null ? KEY_DEFAULT : moduleName;
        moduleClassLoaders.put(realModuleName, classLoader);
    }

    public static void addModuleClassLoader(String moduleName, DWModuleClassLoader classLoader, DWModuleFileInfo fileInfo) {
        String realModuleName;
        classLoader.moduleName = realModuleName = moduleName == null ? KEY_DEFAULT : moduleName;
        String directoryLayer = fileInfo.getDirectoryLayer();
        moduleClassLoaders.put(directoryLayer, classLoader);
    }

    public static String getModuleName(ClassLoader classLoader) {
        String moduleName = null;
        for (Map.Entry<String, DWModuleClassLoader> entry : moduleClassLoaders.entrySet()) {
            if (entry.getValue() != classLoader) continue;
            moduleName = entry.getKey();
            break;
        }
        return moduleName;
    }

    public static void setUserDefinedClassLoader(ClassLoader userDefinedClassLoader) {
        DWModuleClassLoader.userDefinedClassLoader = userDefinedClassLoader;
    }

    public static ClassLoader getModuleOrUserDefinedClassLoaderByModuleName(String moduleName) {
        if (userDefinedClassLoader != null) {
            return userDefinedClassLoader;
        }
        return DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
    }

    public static DWModuleClassLoader getModuleClassLoaderByModuleName(String moduleName) {
        String moduleKey = moduleName;
        int keyLength = StringUtils.length((CharSequence)moduleName);
        if (moduleClassLoaders != null) {
            for (Map.Entry<String, DWModuleClassLoader> entry : moduleClassLoaders.entrySet()) {
                String key = entry.getKey();
                boolean isStartWithModuleName = StringUtils.equals((CharSequence)StringUtils.substringBefore((String)key, (String)"\\"), (CharSequence)moduleName);
                if (!isStartWithModuleName || StringUtils.length((CharSequence)key) <= keyLength) continue;
                keyLength = StringUtils.length((CharSequence)key);
                moduleKey = key;
            }
        }
        return moduleClassLoaders.get(moduleKey);
    }

    public static DWModuleClassLoader getModuleClassLoaderByExactName(String moduleName) {
        return moduleClassLoaders.get(moduleName);
    }

    public static DWModuleClassLoader getModuleClassLoader(String className) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleClassLoader.getModuleClassLoader(moduleName, className);
    }

    public static DWModuleClassLoader getModuleClassLoader(String moduleName, String className) {
        if (moduleName != null) {
            DWModuleClassLoader moduleClassLoader = moduleClassLoaders.get(moduleName);
            if (moduleClassLoader == null || !moduleClassLoader.hasService(className)) {
                return null;
            }
            return moduleClassLoader;
        }
        DWModuleClassLoader loader = null;
        for (DWModuleClassLoader child : moduleClassLoaders.values()) {
            if (!child.hasService(className)) continue;
            loader = child;
            break;
        }
        return loader;
    }

    public static void removeModuleClassLoader(String moduleName) {
        if (moduleName == null) {
            moduleName = KEY_DEFAULT;
        }
        if (moduleClassLoaders.containsKey(moduleName)) {
            moduleClassLoaders.remove(moduleName);
        }
    }

    public static String getModuleParentFolderName(boolean isLocalModule) {
        return isLocalModule ? "LocalService" : "Service";
    }

    static {
        userDefinedClassLoader = null;
    }
}

