/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DWHeader {
    private String moduleName = null;
    private String serviceName = null;
    private Class<?> serviceType = null;

    public DWHeader(String groupName, Class<?> serviceType) {
        this(groupName, serviceType.getSimpleName(), serviceType);
    }

    public DWHeader(String moduleName, String serviceName, Class<?> serviceType) {
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        this.moduleName = moduleName;
        this.serviceName = serviceName;
        this.serviceType = serviceType;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Class<?> getServiceType() {
        return this.serviceType;
    }

    public boolean equals(Object comparedObject) {
        if (!(comparedObject instanceof DWHeader)) {
            return false;
        }
        DWHeader comparedHeader = (DWHeader)comparedObject;
        return this.moduleName.equals(comparedHeader.moduleName) && this.serviceName.equals(comparedHeader.serviceName) && this.serviceType.equals(comparedHeader.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.serviceName, this.serviceType);
    }

    public Map<String, List<DWMethod>> getDWMethods() {
        HashMap<String, List<DWMethod>> dwMethods = new HashMap<String, List<DWMethod>>();
        Method[] methodList = this.getServiceType().getMethods();
        if (methodList == null) {
            throw new IllegalStateException();
        }
        for (Method method : methodList) {
            ArrayList<DWMethod> methods = (ArrayList<DWMethod>)dwMethods.get(method.getName());
            if (methods == null) {
                methods = new ArrayList<DWMethod>();
                dwMethods.put(method.getName(), methods);
            }
            methods.add(this.createDWMethod(method));
        }
        return dwMethods;
    }

    protected DWMethod createDWMethod(Method method) {
        return new DWMethod(method);
    }
}

