/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.regex.Pattern;

public class DWDeveloperServicePathManager {
    private static final String URI_PREFIX = "URI//";
    private static final String FILE_URI_PREFIX = "URI//file:";
    private static final boolean OS_IS_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private boolean isPathClass = false;
    private String jarPath;
    private String workspacePath;
    private String projectName;
    private String projectPath;

    public DWDeveloperServicePathManager(String implementPath) {
        try {
            this.initial(implementPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initial(String implementPath) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL implementPathUrl = classLoader.getResource(implementPath = implementPath.replace(".", File.separator));
        if (implementPathUrl == null) {
            implementPathUrl = classLoader.getResource(implementPath + ".class");
            this.isPathClass = true;
        } else {
            this.isPathClass = false;
        }
        if (implementPathUrl == null) {
            throw new NoSuchFileException(System.getProperty("line.separator") + "\u8acb\u6aa2\u67e5developer-service.csv\u3001Java Build Path\u548cDeployment Assembly" + System.getProperty("line.separator") + "\u958b\u767c\u8005\u670d\u52d9\u672a\u6210\u529f\u90e8\u5c6c - " + implementPath.replace(File.separator, "."));
        }
        this.jarPath = implementPathUrl.toString();
        this.jarPath = URLDecoder.decode(this.jarPath, StandardCharsets.UTF_8.name());
        this.jarPath = this.jarPath.substring(0, this.jarPath.toString().indexOf("!"));
        this.jarPath = this.jarPath.replace("jar:file:/", "");
        this.jarPath = DWDeveloperServicePathManager.pathNormalization(this.jarPath);
        this.workspacePath = this.findWorkspacePath(this.jarPath);
        this.projectName = this.findProjectName(this.jarPath);
        String locationFilePath = this.workspacePath + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.resources" + File.separator + ".projects" + File.separator + this.projectName + File.separator + ".location";
        File locationFile = new File(locationFilePath);
        if (!locationFile.exists()) {
            this.projectPath = this.workspacePath + this.projectName;
            return;
        }
        this.projectPath = URLDecoder.decode(DWDeveloperServicePathManager.readProjectLocation(locationFile), "UTF-8").substring(1);
    }

    public static String pathNormalization(String path) {
        return path.replace("/", File.separator).replace("\\", File.separator);
    }

    private String findWorkspacePath(String jarPath) {
        return jarPath.substring(0, jarPath.indexOf(".metadata"));
    }

    private String findProjectName(String jarPath) {
        return jarPath.substring(jarPath.lastIndexOf("WEB-INF")).split(Pattern.quote(File.separator))[2].replace(".jar", "");
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean isPathClass() {
        return this.isPathClass;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProjectLocation(File projectLocationFile) throws IOException {
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(projectLocationFile));
            ((DataInputStream)in).skipBytes(16);
            String projectLocation = ((DataInputStream)in).readUTF();
            if (projectLocation.startsWith(FILE_URI_PREFIX)) {
                projectLocation = projectLocation.substring(FILE_URI_PREFIX.length());
                if (OS_IS_WINDOWS && projectLocation.matches("^/[a-zA-Z]:")) {
                    projectLocation = projectLocation.substring(1);
                }
            }
            String string = projectLocation;
            return string;
        }
    }
}

