/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.utils.ModuleJarScanInfo;
import com.digiwin.app.service.DWService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWProfileScanHelperUtils {
    static void onClassScan(String moduleName, DWModuleClassLoader classLoader, Class<?> clazz, Map<String, List<Class<?>>> scanContext) {
        DWProfileScanHelperUtils.onClassScan(moduleName, classLoader, null, clazz, scanContext, null);
    }

    static void onClassScan(String moduleName, DWModuleClassLoader classLoader, String jarName, Class<?> clazz, Map<String, List<Class<?>>> scanContext, ModuleJarScanInfo moduleJarScanInfo) {
        if (moduleJarScanInfo != null && jarName != null) {
            moduleJarScanInfo.cacheClassInfo(moduleName, jarName, clazz.getName());
        }
        if (!clazz.isInterface()) {
            return;
        }
        List<Class<?>> moduleInfos = scanContext.get(moduleName);
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<?> oldVerInterface = null;
        for (Class<?> serviceInterface : interfaces) {
            if (serviceInterface != DWService.class) continue;
            if (moduleInfos == null) {
                moduleInfos = new ArrayList();
                scanContext.put(moduleName, moduleInfos);
            }
            for (Class<?> item : moduleInfos) {
                if (!clazz.getName().equals(item.getName())) continue;
                oldVerInterface = item;
                break;
            }
            if (oldVerInterface != null) {
                moduleInfos.remove(oldVerInterface);
            }
            moduleInfos.add(clazz);
            classLoader.addServiceInfo(clazz.getName());
            if (moduleJarScanInfo == null || jarName == null) break;
            moduleJarScanInfo.addToPrimaryList(moduleName, jarName);
            break;
        }
    }
}

