/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.observer;

import com.digiwin.app.common.DWPathUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;

public class FileModifiedListener
extends Observable {
    private static final String CLASS_INFO = "[FileModifiedListener]";
    static Log log = LogFactory.getLog(FileModifiedListener.class);
    private Timer timer;
    private Vector<Observer> obs = new Vector();
    private Map<String, Map> notifyParamMap;
    private static final long DELAY_TIME = 60L;
    private static FileModifiedListener instance = null;

    public static FileModifiedListener getInstance() {
        if (instance == null) {
            instance = new FileModifiedListener();
        }
        return instance;
    }

    public FileModifiedListener() {
        this.timer = new Timer();
        this.notifyParamMap = new HashMap<String, Map>();
        this.initial();
    }

    public void initial() {
        try {
            DefaultFileMonitor fileMonitor = new DefaultFileMonitor(new FileListener(){

                public void fileCreated(FileChangeEvent event) throws Exception {
                    this.resolveEvent("Created", event);
                }

                public void fileDeleted(FileChangeEvent event) throws Exception {
                    this.resolveEvent("Deleted", event);
                }

                public void fileChanged(FileChangeEvent event) throws Exception {
                    this.resolveEvent("Changed", event);
                }

                private void resolveEvent(String type, FileChangeEvent event) {
                    try {
                        FileObject fileObject = event.getFile();
                        FileName fileName = fileObject.getName();
                        log.info((Object)("[FileModifiedListener]File " + type + ": " + fileName.toString()));
                        File file = new File(fileObject.getURL().toURI());
                        String filePath = file.getAbsolutePath();
                        String splitString = StringUtils.substringAfter((String)filePath, (String)("module" + File.separator));
                        String moduleName = StringUtils.substringBefore((String)splitString, (String)File.separator);
                        if (!FileModifiedListener.this.notifyParamMap.containsKey(moduleName)) {
                            log.info((Object)("[FileModifiedListener]The module: " + moduleName + " will reload right after 60 seconds delay..."));
                            FileModifiedListener.this.setSchedule(60L);
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("moduleName", moduleName);
                            FileModifiedListener.this.notifyParamMap.put(moduleName, params);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)(FileModifiedListener.CLASS_INFO + String.valueOf(e)));
                    }
                }
            });
            FileSystemManager fsm = VFS.getManager();
            String platformServicePath = DWPathUtils.getPlatformModulePath();
            FileObject platformServiceFile = fsm.resolveFile(new File(platformServicePath).getAbsolutePath());
            String appServicePath = DWPathUtils.getApplicationModulePath();
            FileObject appServiceFile = fsm.resolveFile(new File(appServicePath).getAbsolutePath());
            String indsutryServicePath = DWPathUtils.getIndustryModulePath();
            FileObject indsutryServiceFile = fsm.resolveFile(new File(indsutryServicePath).getAbsolutePath());
            String customizationServicePath = DWPathUtils.getCustomizationModulePath();
            FileObject customizationServiceFile = fsm.resolveFile(new File(customizationServicePath).getAbsolutePath());
            fileMonitor.setRecursive(true);
            fileMonitor.addFile(platformServiceFile);
            fileMonitor.addFile(appServiceFile);
            fileMonitor.addFile(indsutryServiceFile);
            fileMonitor.addFile(customizationServiceFile);
            fileMonitor.start();
        }
        catch (Exception e) {
            log.error((Object)(CLASS_INFO + String.valueOf(e)));
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(o)) {
            this.obs.addElement(o);
        }
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        this.obs.removeElement(o);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    @Override
    public synchronized int countObservers() {
        return this.obs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object arg) {
        Object[] arrLocal;
        FileModifiedListener fileModifiedListener = this;
        synchronized (fileModifiedListener) {
            if (!this.hasChanged()) {
                return;
            }
            arrLocal = this.obs.toArray();
            this.clearChanged();
        }
        for (int i = 0; i < arrLocal.length; ++i) {
            ((Observer)arrLocal[i]).update(this, arg);
        }
    }

    public void setSchedule(long seconds) {
        this.timer.schedule((TimerTask)new NotifyTask(), seconds * 1000L);
    }

    class NotifyTask
    extends TimerTask {
        NotifyTask() {
        }

        @Override
        public void run() {
            for (Map.Entry<String, Map> entry : FileModifiedListener.this.notifyParamMap.entrySet()) {
                FileModifiedListener.this.setChanged();
                Map map = entry.getValue();
                FileModifiedListener.this.notifyObservers(map);
            }
            FileModifiedListener.this.notifyParamMap.clear();
        }
    }
}

