/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai.fasynctask;

import com.digiwin.app.eai.fasynctask.FasyncTaskVo;
import com.digiwin.app.eai.util.InstanceUtil;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class FasyncTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FasyncTaskService.class);
    private static final String MONGO_DB_COLLECTION_NAME = "dw_async_task";
    private static final String ASYNC_TASK_STATUS_WAITING = "waiting";
    private static final String ASYNC_TASK_STATUS_RUNNING = "running";
    private MongoClient mongoClient;
    private Environment environment;

    public FasyncTaskService(MongoClient mongoClient, Environment environment) {
        this.mongoClient = mongoClient;
        this.environment = environment;
    }

    public void insertFasyncTask(String taskId, String tenantId, Map<String, Object> requestHeader, String requestBody) {
        LOGGER.debug("task id=" + taskId);
        String instanceName = InstanceUtil.getInstanceName();
        LOGGER.debug("instance name=" + instanceName);
        LOGGER.debug("task status=waiting");
        LOGGER.debug("tenant id=" + tenantId);
        LOGGER.debug("request headers=" + requestHeader);
        LOGGER.debug("request body=" + requestBody);
        this.addAsyncTask(taskId, instanceName, ASYNC_TASK_STATUS_WAITING, tenantId, requestHeader, requestBody);
    }

    public void updateFasyncTask(String taskId) {
        LOGGER.debug("task id=" + taskId);
        this.updateAsyncTask(taskId);
    }

    public void deleteFasyncTask(String taskId) {
        LOGGER.debug("task id=" + taskId);
        this.deleteAsyncTask(taskId);
    }

    public List<FasyncTaskVo> getWaitingFasyncTasks() {
        return this.getWaitingFasyncTasks(InstanceUtil.getInstanceName());
    }

    public List<FasyncTaskVo> getWaitingFasyncTasks(String instanceName) {
        MongoCollection collection = this.getAsyncTaskCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"instanceName", (Object)instanceName), Filters.eq((String)"taskStatus", (Object)ASYNC_TASK_STATUS_WAITING)});
        FindIterable findIterable = collection.find(condition);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<FasyncTaskVo> fasyncTaskVos = new ArrayList<FasyncTaskVo>();
        while (mongoCursor.hasNext()) {
            FasyncTaskVo fasyncTaskVo = new FasyncTaskVo();
            Document document = (Document)mongoCursor.next();
            Map taskContext = (Map)document.get((Object)"taskContext", Map.class);
            Map requestHeader = (Map)taskContext.get("requestHeader");
            String requestBody = (String)taskContext.get("requestBody");
            fasyncTaskVo.setRequestHeader(requestHeader);
            fasyncTaskVo.setRequestBody(requestBody);
            fasyncTaskVos.add(fasyncTaskVo);
        }
        return fasyncTaskVos;
    }

    private void addAsyncTask(String taskId, String instanceName, String taskStatus, String tenantId, Map<String, Object> requestHeader, String requestBody) {
        MongoCollection collection = this.getAsyncTaskCollection();
        long expireAfter = this.getExpireAfter();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"taskId", (Object)taskId)});
        long count = collection.countDocuments(condition);
        if (count > 0L) {
            Bson update = Updates.set((String)"instanceName", (Object)instanceName);
            collection.updateOne(condition, update);
        } else {
            HashMap<String, Object> taskContext = new HashMap<String, Object>();
            taskContext.put("requestHeader", requestHeader);
            taskContext.put("requestBody", requestBody);
            Document document = new Document("taskId", (Object)taskId).append("instanceName", (Object)instanceName).append("taskStatus", (Object)taskStatus).append("tenantId", (Object)tenantId).append("taskContext", taskContext).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
            collection.insertOne((Object)document);
        }
    }

    private void updateAsyncTask(String taskId) {
        MongoCollection collection = this.getAsyncTaskCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"taskId", (Object)taskId)});
        Bson update = Updates.set((String)"taskStatus", (Object)ASYNC_TASK_STATUS_RUNNING);
        collection.updateOne(condition, update);
    }

    private void deleteAsyncTask(String taskId) {
        MongoCollection collection = this.getAsyncTaskCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"taskId", (Object)taskId)});
        collection.deleteOne(condition);
    }

    private MongoCollection getAsyncTaskCollection() {
        MongoDatabase database = this.getMongoDatabase();
        List collectionNameList = (List)database.listCollectionNames().into(new ArrayList());
        long expireAfter = this.getExpireAfter();
        if (!collectionNameList.contains(MONGO_DB_COLLECTION_NAME)) {
            database.createCollection(MONGO_DB_COLLECTION_NAME);
            MongoCollection collection = database.getCollection(MONGO_DB_COLLECTION_NAME);
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(expireAfter), TimeUnit.MILLISECONDS);
            collection.createIndex((Bson)new Document("expireAt", (Object)1), indexOptions);
            collection.createIndex(Indexes.ascending((String[])new String[]{"taskId"}));
        }
        return database.getCollection(MONGO_DB_COLLECTION_NAME);
    }

    private MongoDatabase getMongoDatabase() {
        String databaseName = this.environment.getProperty("fasyncMongoDatabaseName");
        MongoDatabase database = this.mongoClient.getDatabase(databaseName);
        return database;
    }

    private long getExpireAfter() {
        String expireAfterString = this.environment.getProperty("fasyncMongoExpireAfter", "14");
        long expireAfter = Long.valueOf(expireAfterString) * 24L * 60L * 60L * 1000L;
        return expireAfter;
    }
}

