/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import com.digiwin.app.log.operation.model.DWLogOperationServiceInfoData;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class ServicePublicMethodLogInterceptor
implements MethodInterceptor {
    private boolean logErrorEnabled = true;
    private static Log log = LogFactory.getLog(ServicePublicMethodLogInterceptor.class);
    private static final Gson GSON = new Gson();
    @Autowired(required=false)
    @Qualifier(value="dw-log-operation-configuration-properties")
    private DWLogOperationProperties operateLogProperties;

    @Value(value="${dap.service.log-error-enabled:true}")
    public void setLogErrorEnabled(boolean enabled) {
        this.logErrorEnabled = enabled;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        boolean fileLogFlag = this.getFileLogFlag(invocation);
        long invokeTimestamp = System.currentTimeMillis();
        if (fileLogFlag) {
            invokeTimestamp = this.log(invocation);
        }
        boolean isLogOperationEnabled = this.beforeMethodInvoke_UpdateServiceContext();
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            result = invocation.proceed();
            if (fileLogFlag) {
                this.logResult(invokeTimestamp, result);
            }
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
            if (isLogOperationEnabled) {
                this.afterMethodInvoke_UpdateLogOperationServiceProfile();
            }
        }
        catch (Throwable e) {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
            if (fileLogFlag && this.logErrorEnabled) {
                this.logException(stopWatch.getTime(), e);
            }
            throw e;
        }
        return result;
    }

    private long log(MethodInvocation invocation) {
        String stringInfo = invocation == null ? "unknown" : invocation.toString();
        String[] partsInfo = stringInfo.split(" ");
        String serviceMethodSignature = partsInfo.length > 4 ? partsInfo[3] : invocation.getMethod().getName();
        int leftBraces = serviceMethodSignature.indexOf("(");
        if (leftBraces != -1) {
            serviceMethodSignature = serviceMethodSignature.substring(0, leftBraces);
        }
        Parameter[] parameters = invocation.getMethod().getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            parameterNames.add(parameters[i].getName());
        }
        serviceMethodSignature = serviceMethodSignature + "(" + StringUtils.join((Object[])parameterNames.toArray(), (String)",") + ")";
        StringBuilder message = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        message.append("io>").append("invoke[").append(timestamp).append("]").append("{").append(threadId).append("}").append(">").append(serviceMethodSignature);
        message.append(" input: (");
        Object[] arguments = invocation.getArguments();
        if (arguments == null) {
            message.append(arguments);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    message.append(", ");
                }
                if (arguments[i] == null) {
                    message.append("null");
                    continue;
                }
                message.append(arguments[i]);
            }
        }
        message.append(")");
        log.info((Object)message.toString());
        return timestamp;
    }

    private void logResult(long invokeTimestamp, Object result) throws Exception {
        StringBuffer resultMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        resultMessage.append("io>result[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">").append(result);
        log.info((Object)resultMessage.toString());
    }

    private void logException(long invokeTimestamp, Throwable e) throws Exception {
        StringBuffer exceptionMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        exceptionMessage.append("io>exception[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">");
        log.error((Object)exceptionMessage.toString(), e);
    }

    private boolean beforeMethodInvoke_UpdateServiceContext() {
        boolean isLogOperationEnabled = false;
        if (this.operateLogProperties != null && this.operateLogProperties.isEnabled()) {
            Map requestHeader;
            DWLogOperationContext logOperationContext = DWLogOperationContext.getContext();
            DWLogOperationServiceInfoData serviceInfoData = logOperationContext.getServiceInfoData();
            DWServiceContext serviceContext = DWServiceContext.getContext();
            Map profile = serviceContext.getProfile();
            if (profile == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[ServicePublicMethodLogInterceptor] profile of context is null");
                }
            } else {
                serviceInfoData.setTenantSid((Long)profile.get(DWTenantUtils.getIAMTenantSidKey()));
                serviceInfoData.setCreateUserName((String)profile.get("userName"));
                if (profile.get("userId") != null) {
                    serviceInfoData.getServiceProfile().put("userId", profile.get("userId"));
                }
                if (profile.get("tenantId") != null) {
                    serviceInfoData.getServiceProfile().put("tenantId", profile.get("tenantId"));
                }
            }
            if ((requestHeader = serviceContext.getRequestHeader()) != null) {
                serviceInfoData.getServiceProfile().put("header", GSON.toJson((Object)requestHeader));
            }
            serviceInfoData.getServiceProfile().put("appId", SpringContextUtils.getEnvironment().getProperty("appId", ""));
            serviceInfoData.setTraceId(serviceContext.getTraceId());
            String currentModuleName = serviceInfoData.getModuleName();
            if (StringUtils.isEmpty((CharSequence)currentModuleName)) {
                serviceInfoData.setModuleName(serviceContext.getGroupName());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("[ServicePublicMethodLogInterceptor] serviceInfoData doesn't setModuleName(current:%s)", currentModuleName));
            }
            if (serviceInfoData.getOpMainLogId() == null) {
                serviceInfoData.setOpMainLogId(DWLogOperationDataHelper.generateLogId());
            }
            Map<String, Object> logRecord = ServicePublicMethodLogInterceptor.generateLogEnabledData();
            DWServiceContext.getContext().getOperateLog().putAll(logRecord);
            isLogOperationEnabled = true;
        }
        return isLogOperationEnabled;
    }

    private void afterMethodInvoke_UpdateLogOperationServiceProfile() {
        DWLogOperationContext logOperationContext = DWLogOperationContext.getContext();
        if (logOperationContext != null) {
            Map operateLogMap = DWServiceContext.getContext().getOperateLog();
            CollectionUtils.filter(operateLogMap.values(), (Predicate)PredicateUtils.notNullPredicate());
            logOperationContext.getServiceInfoData().getServiceProfile().putAll(operateLogMap);
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("sqlMap")) {
                logOperationContext.getServiceInfoData().setSqlMap((Map)operateLogMap.get("sqlMap"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"[ServicePublicMethodLogInterceptor] updated LogOperationContext ServiceProfile");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[ServicePublicMethodLogInterceptor] logOperationContext is null");
        }
    }

    public static Map<String, Object> generateLogEnabledData() {
        HashMap<String, Object> logEnabledMap = new HashMap<String, Object>();
        DWLogOperationAnnotationField annoField = DWLogOperationContext.getContext().getOperateLog();
        logEnabledMap.put("isLogRecord", annoField.isMergedLogBasicEnable());
        logEnabledMap.put("isLogSqlRecord", annoField.isMergedLogSqlEnabled());
        logEnabledMap.put("isLogErrorRecord", annoField.isMergedLogErrorEnabled());
        return logEnabledMap;
    }

    private boolean getFileLogFlag(MethodInvocation invocation) {
        DWIgnoreFileLog classAnnotation = invocation.getThis().getClass().getAnnotation(DWIgnoreFileLog.class);
        DWIgnoreFileLog methodAnnotation = invocation.getMethod().getAnnotation(DWIgnoreFileLog.class);
        return null == classAnnotation && null == methodAnnotation;
    }
}

