/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.appender;

import com.digiwin.app.log.utils.DWLogUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.json.JSONObject;

@Plugin(name="DwLogAppender", category="Core", elementType="appender", printObject=true)
public class DwLogAppender
extends AbstractAppender {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String endpoint;
    private String app;
    private CloseableHttpClient client;

    protected DwLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, String endpoint, String app) {
        super(name, filter, layout);
        this.setEndpoint(endpoint);
        this.setApp(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        Object h_response = null;
        if (this.client == null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5L, TimeUnit.SECONDS).setConnectionRequestTimeout(5L, TimeUnit.SECONDS).build();
            this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        }
        try {
            HttpPost postMethod = new HttpPost(this.getEndpoint());
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.putIfAbsent("time", this._sdf.format(new Date()));
            logMap.putIfAbsent("level", event.getLevel().toString());
            logMap.putIfAbsent("loggerName", event.getLoggerName());
            logMap.putIfAbsent("appId", this.getApp());
            logMap.putIfAbsent("appender", "DwLogAppender");
            String addr = DWLogUtils.getLocalHostIpName();
            logMap.putIfAbsent("source", addr);
            Message message = event.getMessage();
            if (message instanceof ObjectMessage) {
                Object parameter = ((ObjectMessage)message).getParameter();
                logMap.putIfAbsent("message", parameter);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putIfAbsent("defaultMessage", message.getFormattedMessage());
                logMap.putIfAbsent("message", map);
            }
            JSONObject tmepObject = new JSONObject(logMap);
            String formatValue = tmepObject.toString(5);
            postMethod.setEntity((HttpEntity)new StringEntity(formatValue));
            int statusCode = (Integer)this.client.execute((ClassicHttpRequest)postMethod, (HttpClientResponseHandler)new HttpClientResponseHandler<Integer>(this){

                public Integer handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                    int statusCode = response.getCode();
                    return statusCode;
                }
            });
            if (statusCode != 200) {
                postMethod.abort();
            }
        }
        catch (ConnectTimeoutException e) {
            LOGGER.error(e.getMessage());
        }
        catch (SocketTimeoutException e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            if (h_response != null) {
                try {
                    h_response.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    public void stop() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
        super.stop();
    }

    @PluginFactory
    public static DwLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="app") String app) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (endpoint == null) {
            LOGGER.error("no endpoint defined in conf.");
            return null;
        }
        return new DwLogAppender(name, filter, (Layout<? extends Serializable>)layout, endpoint + "/restful/service/DWSys/ILogService/post", app);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.client = client;
    }
}

