/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.result;

import com.digiwin.app.json.gson.DWJsonViewGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.result.DWResultHandler;
import com.digiwin.gateway.result.DWServiceStandardResult;
import java.util.ArrayList;
import java.util.Map;

public class DWDefaultResultHandler
extends DWResultHandler {
    private static final String KEY_CONTENT_TYPE = "Content-Type";

    @Override
    public Object process(Object result) throws Exception {
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        if (!headerMap.containsKey(KEY_CONTENT_TYPE)) {
            headerMap.put(KEY_CONTENT_TYPE, "application/json;charset=UTF-8");
        }
        String contentType = String.valueOf(headerMap.getOrDefault(KEY_CONTENT_TYPE, "")).toLowerCase();
        DWServiceContext.getContext().setResponseHeader(headerMap);
        if (this.containsFileType(contentType) || !DWServiceContext.getContext().getResultHandlerEnabled()) {
            return result;
        }
        boolean standardResult = DWServiceContext.getContext().getStandardResult();
        if (standardResult) {
            result = DWServiceStandardResult.create(result);
        }
        return DWJsonViewGsonProvider.toJson((Object)result);
    }

    private boolean containsFileType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lowerCaseContentType = contentType.toLowerCase();
        ArrayList<String> mediaTypes = new ArrayList<String>();
        mediaTypes.add("text/html".toLowerCase());
        mediaTypes.add("application/octet-stream".toLowerCase());
        mediaTypes.add("text/xml".toLowerCase());
        for (String mediaType : mediaTypes) {
            if (!lowerCaseContentType.contains(mediaType)) continue;
            return true;
        }
        return false;
    }
}

