/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.output;

import com.digiwin.app.container.exceptions.DWExceptionUtils;
import com.digiwin.app.container.exceptions.IDWException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.schedule.exception.DistributedScheduleException;
import com.digiwin.gateway.output.StandardOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;

public class StandardExceptionOutput
extends StandardOutput {
    private static Log log = LogFactory.getLog(StandardExceptionOutput.class);
    public static final int STACK_TRACE_SIZE_BRIEF = 5;
    private static boolean outputDebugInfo;
    private static boolean enableExceptionMessageI18N;
    private static Set<String> excludeErrorCodes;

    public static void setOutputDebugInfo(boolean outputDebugInfo) {
        StandardExceptionOutput.outputDebugInfo = outputDebugInfo;
    }

    public static void setEnableExceptionMessageI18N(boolean enableExceptionMessageI18N) {
        StandardExceptionOutput.enableExceptionMessageI18N = enableExceptionMessageI18N;
    }

    public static void setExcludeErrorCodes(Set<String> excludeErrorCodes) {
        StandardExceptionOutput.excludeErrorCodes = excludeErrorCodes;
    }

    public static Map<String, Object> getStandardErrorResult(HttpStatus httpStatus, Throwable exception) {
        return StandardExceptionOutput.getStandardErrorResult(httpStatus, exception, -1);
    }

    public static Map<String, Object> getStandardErrorResult(HttpStatus httpStatus, Throwable exception, int stackTraceSize) {
        long threadId = Thread.currentThread().getId();
        StringBuilder message = new StringBuilder();
        message.append("StandardExceptionOutput>exception!").append("{").append(threadId).append("}");
        log.error((Object)message.toString(), exception);
        String sourceId = "Unknown";
        String errorCode = null;
        String errorType = "Unexpected";
        Map instructors = null;
        Object[] errorMessageArgs = null;
        Throwable targetException = StandardExceptionOutput.getTargetException(exception);
        if (targetException instanceof IDWException) {
            IDWException dwException = (IDWException)targetException;
            sourceId = dwException.getSourceId();
            errorType = dwException.getErrorType();
            errorCode = dwException.getErrorCode();
            instructors = dwException.getInstructors();
            errorMessageArgs = dwException.getMessageArgs();
        }
        if (errorCode == null) {
            errorCode = "0x001";
        }
        HashMap<String, Object> errorInfo = new HashMap<String, Object>();
        if (outputDebugInfo) {
            String stackTrace = StandardExceptionOutput.getStackTrace(targetException, stackTraceSize);
            HashMap<String, String> debugInfo = new HashMap<String, String>();
            debugInfo.put("stackTrace", stackTrace);
            if (targetException instanceof DistributedScheduleException) {
                String remoteStackTrace = ((DistributedScheduleException)targetException).getRemoteStackTrace();
                debugInfo.put("masterStackTrace", remoteStackTrace);
            }
            errorInfo.put("debugInfo", debugInfo);
        }
        String errorMessage = targetException.getMessage();
        if (enableExceptionMessageI18N && !excludeErrorCodes.contains(errorCode)) {
            errorMessage = DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle((String)errorCode, (String)errorMessage, (Object[])errorMessageArgs);
        }
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = "Unknown!";
        }
        errorInfo.put("sourceId", sourceId);
        errorInfo.put("errorMessage", errorMessage);
        errorInfo.put("errorType", errorType);
        errorInfo.put("errorCode", errorCode);
        errorInfo.put("errorInstructors", instructors);
        return StandardExceptionOutput.getStandardResult(httpStatus, errorInfo);
    }

    private static String getStackTrace(@NotNull Throwable exception, int stackTraceSize) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String stackTrace = null;
        if (stackTraceSize == -1) {
            stackTrace = ExceptionUtils.getStackTrace((Throwable)exception);
        } else {
            int size = exception.getStackTrace().length;
            int printSize = stackTraceSize >= size ? size : stackTraceSize;
            StringBuilder sb = new StringBuilder();
            sb.append(exception.getClass().getName()).append(": ").append(exception.getMessage());
            for (int i = 0; i < printSize; ++i) {
                sb.append(System.lineSeparator());
                sb.append(exception.getStackTrace()[i].toString());
            }
            stackTrace = sb.toString();
        }
        return stackTrace;
    }

    public static Throwable getTargetException(Throwable catchedException) {
        Throwable targetException = null;
        if (catchedException != null && (targetException = (Throwable)DWExceptionUtils.getIDWException(catchedException)) == null) {
            targetException = ExceptionUtils.getRootCause((Throwable)catchedException);
        }
        return targetException == null ? catchedException : targetException;
    }
}

