/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.eai.DWEAIProperties;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class EaiInfoUtils {
    private static Log log = LogFactory.getLog(EaiInfoUtils.class);

    public static Map<String, Object> getSrvRegInfo(Supplier<List<String>> serviceIdSupplier, DWEAIProperties properties) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, List<String>> service = new HashMap<String, List<String>>();
        service.put("srvname", serviceIdSupplier.get());
        result.put("service", service);
        EaiInfoUtils.attachHostInfo(result, properties);
        return result;
    }

    public static Map<String, Object> getProdRegInfo(Environment environment, DWEAIProperties properties) throws Exception {
        String concurrence;
        String retryInterval;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, String> hostInfoMap = EaiInfoUtils.attachHostInfo(result, properties);
        String offset = EaiInfoUtils.getTimezoneOffset();
        hostInfoMap.put("timezone", offset);
        String ip = properties.getHostIp();
        String port = environment.getProperty("local.server.port");
        hostInfoMap.put("restful", "http://" + ip + ":" + port + properties.getRestfulServicePath());
        String retryTimes = properties.getHostRetryTimes();
        if (!StringUtils.isBlank((CharSequence)retryTimes)) {
            hostInfoMap.put("retrytimes", retryTimes);
        }
        if (!StringUtils.isBlank((CharSequence)(retryInterval = properties.getHostRetryInterval()))) {
            hostInfoMap.put("retryinterval", retryInterval);
        }
        if (!StringUtils.isBlank((CharSequence)(concurrence = properties.getHostConcurrence()))) {
            hostInfoMap.put("concurrence", concurrence);
        }
        return result;
    }

    public static Map<String, String> attachHostInfo(Map<String, Object> resultMap, DWEAIProperties properties) throws UnknownHostException {
        Map<String, String> hostInfo = EaiInfoUtils.getHostBasicInfo(properties);
        resultMap.put("host", hostInfo);
        return hostInfo;
    }

    public static Map<String, String> getHostBasicInfo(DWEAIProperties properties) throws UnknownHostException {
        String ip = properties.getHostIp();
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("ip", ip);
        host.put("prod", properties.getHostProd());
        host.put("ver", properties.getHostVer());
        host.put("id", properties.getHostId());
        host.put("uid", properties.getHostUid());
        return host;
    }

    private static String getTimezoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        int offsetInMillis = timeZone.getOffset(calendar.getTimeInMillis());
        String offset = String.format("%d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        return ((ServletRequestAttributes)requestAttributes).getResponse();
    }

    public static String getEAIRegSrvURL() {
        DWEAIProperties eaiProperties = DWEAIProperties.getProperties();
        String host = eaiProperties.getServerUrl();
        String url = eaiProperties.getServerRegisterServicePath();
        log.info((Object)("CROSS Server Host:" + host));
        return host + url;
    }
}

