/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.exceptions.DWMethodNotAllowAnonymousException;
import com.digiwin.gateway.filter.AllowAnonymousFilter;
import com.digiwin.gateway.filter.DWFilterUtils;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.gateway.filter.util.TokenUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenAllowAnonymousFilter
extends AllowAnonymousFilter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String token;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWMethod method = api.getMethod();
        boolean innerInvocation = DWInnerInvocationUtils.isInnerInvocation((HttpServletRequest)httpRequest);
        if (!(innerInvocation || method.allowAnonymous() || (token = TokenUtils.getToken(httpRequest)) != null && !token.isEmpty())) {
            DWParameters parameters = (DWParameters)httpRequest.getAttribute("targetParameters");
            DWHeader header = api.getHeader();
            DWMethodNotAllowAnonymousException e = new DWMethodNotAllowAnonymousException(header.getModuleName(), header.getServiceName(), method.getMethodName(), parameters);
            DWFilterUtils.failResponse((Exception)e, httpResponse);
            return;
        }
        httpRequest.setAttribute("isDWMethodAllowAnonymous", (Object)method.allowAnonymous());
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

