/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.processor.DWSourceAppSwitchProcessor;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.filter.AuthenticationFilter;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.gateway.filter.util.TokenUtils;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import com.digiwin.gateway.service.permission.util.DWAPIPermissionUtil;
import com.digiwin.gateway.token.TokenService;
import com.digiwin.gateway.token.exception.DWTokenExpiredException;
import com.digiwin.gateway.token.exception.DWTokenSignatureException;
import com.digiwin.http.client.utils.DWPathPatternHelper;
import com.digiwin.iam.DWIAMProperties;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;

public class TokenFilter
extends AuthenticationFilter {
    @Autowired
    private TokenService tokenService;
    @Autowired
    @Qualifier(value="dw-service-permission-config")
    DWServicePermissionConfig servicePermissionConfig;
    @Autowired
    @Qualifier(value="dw-api-permission-util")
    public DWAPIPermissionUtil dwapiPermissionUtil;
    @Autowired
    DWIAMProperties properties;
    private DWSourceAppSwitchProcessor switchContextAppIdProcessor = new DWSourceAppSwitchProcessor();
    private String tokenMode = "?";

    @Value(value="${serverHttpTokenmode:?}")
    public void setTokenMode(String tokenMode) {
        this.tokenMode = tokenMode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block16: {
            httpRequest = (HttpServletRequest)request;
            httpResponse = (HttpServletResponse)response;
            isDWMethodAllowAnonymous = (Boolean)httpRequest.getAttribute("isDWMethodAllowAnonymous");
            targetAPI = httpRequest.getAttribute("targetAPI");
            appIdSupplier = (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doFilter$3(java.lang.Object ), ()Ljava/lang/String;)((Object)targetAPI);
            try {
                this.processAppToken(httpRequest, isDWMethodAllowAnonymous);
            }
            catch (Exception e) {
                httpStatus = HttpStatus.BAD_REQUEST;
                standardErrorResult = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)e);
                this.generateErroResponse(httpResponse, standardErrorResult, httpStatus);
                return;
            }
            token = TokenUtils.getToken(httpRequest);
            if (isDWMethodAllowAnonymous) break block16;
            try {
                if (DWInnerInvocationUtils.isInnerInvocation((HttpServletRequest)httpRequest)) {
                    innerInvProfile = DWInnerInvocationUtils.parseInnerInvocationProfile((HttpServletRequest)httpRequest);
                    DWServiceContext.getContext().setProfile(innerInvProfile);
                    DWServiceContext.getContext().setToken(token);
                    break block16;
                }
                innerInvProfile = this.tokenMode;
                standardErrorResult = -1;
                switch (innerInvProfile.hashCode()) {
                    case 72245: {
                        if (!innerInvProfile.equals("IAM")) break;
                        standardErrorResult = 0;
                    }
                }
                switch (standardErrorResult) {
                    case 0: {
                        securityContext = DWSecurityContext.getSecurityContext();
                        openTrustChain = this.servicePermissionConfig.isOpenTrustChain();
                        tokenVerified = securityContext.isTokenVerified();
                        if (openTrustChain && (!openTrustChain || tokenVerified)) ** GOTO lbl50
                        integrationToken = null;
                        try {
                            securityContext.suspend();
                            integrationToken = (String)this.switchContextAppIdProcessor.process(appIdSupplier, (Callable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doFilter$4(java.lang.Object java.lang.String ), ()Ljava/lang/String;)((TokenFilter)this, (Object)targetAPI, (String)token));
                        }
                        finally {
                            securityContext.resume();
                        }
                        if (securityContext.getProfile() != null) {
                            DWServiceContext.getContext().getProfile().putAll(securityContext.getProfile());
                        }
                        DWServiceContext.getContext().setToken(integrationToken == null ? token : integrationToken);
                        securityContext.setTokenVerified();
                        clonedServiceContext = DWServiceContext.getContext().deepClone();
                        profile = clonedServiceContext.getProfile();
                        securityContext.setProfile(profile);
                        break;
lbl50:
                        // 1 sources

                        DWServiceContext.getContext().setToken(token);
                        DWServiceContext.getContext().setProfile(new HashMap<K, V>(securityContext.getProfile()));
                        break;
                    }
                    default: {
                        this.switchContextAppIdProcessor.process(appIdSupplier, (Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doFilter$5(java.lang.String ), ()Ljava/lang/Object;)((TokenFilter)this, (String)token));
                    }
                }
            }
            catch (DWTokenExpiredException | DWTokenSignatureException e) {
                httpStatus = HttpStatus.UNAUTHORIZED;
                standardErrorResult = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)e);
                this.generateErroResponse(httpResponse, standardErrorResult, httpStatus);
                return;
            }
            catch (Exception e) {
                httpStatus = HttpStatus.BAD_REQUEST;
                standardErrorResult = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)e);
                this.generateErroResponse(httpResponse, standardErrorResult, httpStatus);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean isAppAuthExcludeURI(HttpServletRequest httpRequest, boolean isDWMethodAllowAnonymous) {
        String lookupPath;
        if (!this.properties.isAppAuthEnabled()) {
            return true;
        }
        if (this.properties.isAppAuthExcludeAnonymousApi() && isDWMethodAllowAnonymous) {
            return true;
        }
        String type = null;
        String targetServiceId = (String)httpRequest.getAttribute("targetServiceId");
        if (targetServiceId == null) {
            lookupPath = httpRequest.getRequestURI();
        } else {
            if (targetServiceId.contains("@")) {
                type = targetServiceId.substring(0, targetServiceId.indexOf("@"));
                if ("eai-callback".equalsIgnoreCase(type) && this.properties.isAppAuthExcludeEAICallback()) {
                    return true;
                }
                targetServiceId = targetServiceId.substring(type.length() + 1);
            }
            lookupPath = targetServiceId;
        }
        for (String pattern : this.properties.getAppAuthExcludeURIs()) {
            if (DWPathPatternHelper.getMatchingPattern((String)pattern, (String)lookupPath) == null) continue;
            return true;
        }
        return false;
    }

    private void processAppToken(HttpServletRequest httpRequest, boolean isDWMethodAllowAnonymous) {
        String apptoken = httpRequest.getHeader("digi-middleware-auth-app");
        if (apptoken == null || apptoken.isEmpty()) {
            if (!this.isAppAuthExcludeURI(httpRequest, isDWMethodAllowAnonymous)) {
                throw new DWRuntimeException("app auth info is null or empty!");
            }
            return;
        }
        DecodedJWT jwt = JWT.decode((String)apptoken);
        String appid = jwt.getClaim("id").asString();
        DWServiceContext.getContext().getRequestHeader().put("digi-middleware-appid", appid);
    }

    private void generateErroResponse(HttpServletResponse response, Map<String, Object> errorResult, HttpStatus httpStatus) throws IOException {
        Gson gson = new Gson();
        String jsonFromMap = gson.toJson(errorResult);
        response.setHeader("Content-Type", "application/json");
        response.setStatus(httpStatus.value());
        response.getOutputStream().write(jsonFromMap.getBytes());
    }

    private /* synthetic */ Object lambda$doFilter$5(String token) throws Exception {
        this.tokenService.verifyToken(token);
        return null;
    }

    private /* synthetic */ String lambda$doFilter$4(Object targetAPI, String token) throws Exception {
        boolean apiPermissionEnable = this.dwapiPermissionUtil.shouldCheckPermission(((DWTargetAPI)targetAPI).getMethod().getMethod());
        if (this.properties.isExchangeIntegrationToken()) {
            return this.tokenService.verifyAndExchangeIamToken(token, apiPermissionEnable);
        }
        this.tokenService.verifyIamToken(token, apiPermissionEnable);
        return null;
    }

    private static /* synthetic */ String lambda$doFilter$3(Object targetAPI) {
        if (targetAPI instanceof DWTargetAPI) {
            return DWSourceAppAwareUtils.getSourceAppId((String)((DWTargetAPI)targetAPI).getHeader().getModuleName());
        }
        return DWSourceAppAwareUtils.getCurrentAppId();
    }
}

