/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.eai.DWEAIServiceLocationInfo;
import com.digiwin.gateway.filter.DWFilterUtils;
import com.digiwin.gateway.filter.exceptions.DWEaiMethodNotFoundException;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.json.JSONObject;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;

public class DWEaiServiceMethodLocateFilter
implements Filter {
    private Environment environment;
    private MongoClient mongoClient;
    private RedisTemplate<String, Object> redis;
    private DWContainerContext containerContext;

    public DWEaiServiceMethodLocateFilter(Environment environment, MongoClient mongoClient, RedisTemplate<String, Object> redis, DWContainerContext containerContext) {
        this.environment = environment;
        this.mongoClient = mongoClient;
        this.redis = redis;
        this.containerContext = containerContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DWServiceContext.getContext().remove();
        final HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String digiService = httpRequest.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        DWServiceContext.getContext().setDigiServiceName(name);
        DWEAIServiceLocationInfo locationInfo = new DWEAIServiceLocationInfo(name, false);
        DWTargetAPI api = this.containerContext.getAPI((DWServiceLocationInfo)locationInfo);
        if (!DWTargetAPI.isValid((DWTargetAPI)api)) {
            DWEaiMethodNotFoundException e = new DWEaiMethodNotFoundException(name);
            DWFilterUtils.failResponse((Exception)((Object)e), httpResponse);
            return;
        }
        Enumeration headerNames = httpRequest.getHeaderNames();
        TreeMap<String, String> requestHeaderForRedis = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String headerName : Collections.list(headerNames)) {
            requestHeaderForRedis.put(headerName, httpRequest.getHeader(headerName));
        }
        String reqid = httpRequest.getHeader("digi-reqid");
        String digiAsyncSupply = httpRequest.getHeader("digi-async-supply");
        if (this.mongoClient != null && digiAsyncSupply == null) {
            MongoCollection collection;
            String first = String.valueOf(reqid.charAt(0));
            String databaseName = this.environment.getProperty("fasyncMongoDatabaseName");
            String expireAfterString = this.environment.getProperty("fasyncMongoExpireAfter", "7");
            long expireAfter = Long.valueOf(expireAfterString) * 24L * 60L * 60L * 1000L;
            MongoDatabase database = this.mongoClient.getDatabase(databaseName);
            List collectionNameList = (List)database.listCollectionNames().into(new ArrayList());
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(expireAfter), TimeUnit.MILLISECONDS);
            if (!collectionNameList.contains(first)) {
                database.createCollection(first);
                collection = database.getCollection(first);
                collection.createIndex((Bson)new Document("expireAt", (Object)1), indexOptions);
            }
            collection = database.getCollection(first);
            Document document = new Document("key", (Object)("eai:chain:progress:fasync:header:" + reqid)).append("value", requestHeaderForRedis).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
            collection.insertOne((Object)document);
        }
        if (this.redis != null && digiAsyncSupply == null) {
            this.redis.opsForValue().set((Object)("eai:chain:progress:fasync:header:" + reqid), requestHeaderForRedis, DWEAIProperties.getProperties().getRedisKeyExpireTime(), TimeUnit.SECONDS);
        }
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest){

            public Enumeration<String> getHeaderNames() {
                Vector<String> headerNamesVector = new Vector<String>();
                Enumeration headerNames = super.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    if ("digi-callback-callback".equals(name) || "digi-callback-url".equals(name)) {
                        headerNamesVector.add(name);
                    }
                    if (name.startsWith("digi-callback-")) continue;
                    headerNamesVector.add(name);
                }
                Enumeration<String> newHeaderNames = headerNamesVector.elements();
                return newHeaderNames;
            }

            public String getHeader(String name) {
                String value;
                if ("token".equals(name) && (value = httpRequest.getHeader("digi-token")) != null) {
                    return value;
                }
                if ("digi-callback-callback".equals(name) || "digi-callback-url".equals(name)) {
                    return super.getHeader(name);
                }
                if (name.startsWith("digi-callback-")) {
                    return null;
                }
                return super.getHeader(name);
            }
        };
        DWDefaultParameters parameters = DWEaiServiceMethodLocateFilter.getDWParameters(requestWrapper);
        httpRequest.setAttribute("targetAPI", (Object)api);
        httpRequest.setAttribute("targetParameters", (Object)parameters);
        httpRequest.setAttribute("targetServiceId", (Object)locationInfo.getEAIServiceId());
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    protected static DWDefaultParameters getDWParameters(DWRequestWrapper request) throws IOException {
        JSONObject headerJo = new JSONObject();
        Enumeration headerNames = request.getHeaderNames();
        TreeMap<String, String> requestHeader = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String headerName : Collections.list(headerNames)) {
            requestHeader.put(headerName, request.getHeader(headerName));
            if ("digi-message".equalsIgnoreCase(headerName)) {
                headerJo.put(headerName, (Object)new String(Base64.getDecoder().decode(request.getHeader(headerName)), StandardCharsets.UTF_8));
                continue;
            }
            headerJo.put(headerName, (Object)request.getHeader(headerName));
        }
        String body = new String(request.getBody(), StandardCharsets.UTF_8);
        DWServiceContext.getContext().setRequestHeader(requestHeader);
        JSONObject invokeParameterJo = new JSONObject();
        invokeParameterJo.put("headers", (Object)headerJo);
        invokeParameterJo.put("messageBody", (Object)body);
        return new DWDefaultParameters(invokeParameterJo.toMap());
    }

    public void destroy() {
    }
}

