/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class StandardHeaderFilter
implements Filter {
    private static Log log = LogFactory.getLog(StandardHeaderFilter.class);
    private static final String DIGI_BUSINESS_KEY = "digi-business-key";
    private Map<String, String> crossSetting;
    private static final String PRE_FLIGHT_METHOD = "options";

    public StandardHeaderFilter(Map<String, String> crossSetting) {
        if (crossSetting == null) {
            crossSetting = Collections.emptyMap();
        }
        this.crossSetting = crossSetting;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.processCrossSetting(httpRequest, httpResponse);
        DWServiceContext.getContext().remove();
        this.setCustomRequestHeader(httpRequest);
        if (!PRE_FLIGHT_METHOD.equals(httpRequest.getMethod().toLowerCase())) {
            ContentCachingResponseWrapper contentCachingResponseWrapper = new ContentCachingResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)contentCachingResponseWrapper);
            contentCachingResponseWrapper.copyBodyToResponse();
        }
    }

    public void destroy() {
    }

    private void setCustomRequestHeader(HttpServletRequest httpRequest) {
        TreeMap<String, String> headerMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = httpRequest.getHeader(key);
            headerMap.put(key, value);
        }
        DWServiceContext.getContext().setRequestHeader(headerMap);
        if (headerMap.containsKey(DIGI_BUSINESS_KEY)) {
            String digiBusinessKeyValue = String.valueOf(headerMap.get(DIGI_BUSINESS_KEY));
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map digiBusinessKeyMap = (Map)DWGsonProvider.getGson().fromJson(digiBusinessKeyValue, type);
            String dataSource = (String)digiBusinessKeyMap.get("datasource");
            DWServiceContext.getContext().setDataSource(dataSource);
        }
    }

    private void processCrossSetting(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        HashMap result = new HashMap();
        for (Map.Entry<String, String> item : this.crossSetting.entrySet()) {
            if (item.getKey().equals("Access-Control-Allow-Origin")) continue;
            httpResponse.addHeader(item.getKey(), item.getValue());
        }
        String accessControlAllowOrigin = this.crossSetting.get("Access-Control-Allow-Origin");
        if ("*".equals(accessControlAllowOrigin)) {
            httpResponse.addHeader("Access-Control-Allow-Origin", accessControlAllowOrigin);
        } else {
            boolean matchAccessControlAllowOrigin;
            String origin = httpRequest.getHeader("Origin");
            if (origin != null && (matchAccessControlAllowOrigin = StandardHeaderFilter.matchAccessControlAllowOrigin(accessControlAllowOrigin, origin))) {
                httpResponse.addHeader("Access-Control-Allow-Origin", origin);
            }
        }
    }

    private static boolean matchAccessControlAllowOrigin(String accessControlAllowOriginAll, String origin) {
        boolean result = false;
        try {
            String[] accessControlAllowOrigins;
            UriComponents originComponents = UriComponentsBuilder.fromOriginHeader((String)origin).build();
            for (String accessControlAllowOrigin : accessControlAllowOrigins = accessControlAllowOriginAll.split(",")) {
                if (accessControlAllowOrigin.indexOf("*") > -1 || accessControlAllowOrigin.indexOf("http://") == -1 && accessControlAllowOrigin.indexOf("https://") == -1) {
                    int accessControlAllowOriginPort = -1;
                    String[] accessControlAllowOriginPartialHost = null;
                    if (accessControlAllowOrigin.indexOf(":") > -1) {
                        String[] accessControlAllowOriginHostSplit = accessControlAllowOrigin.split(":");
                        accessControlAllowOriginPartialHost = accessControlAllowOriginHostSplit[0].split("\\.");
                        accessControlAllowOriginPort = Integer.parseInt(accessControlAllowOriginHostSplit[1]);
                    } else {
                        accessControlAllowOriginPartialHost = accessControlAllowOrigin.split("\\.");
                    }
                    String[] originPartialHost = originComponents.getHost().split("\\.");
                    boolean partialHostMatch = StandardHeaderFilter.matchOriginHost(accessControlAllowOriginPartialHost, originPartialHost);
                    boolean portMatch = StandardHeaderFilter.matchOriginPort(accessControlAllowOriginPort, originComponents.getPort());
                    boolean bl = result = partialHostMatch && portMatch;
                    if (!result) continue;
                    break;
                }
                try {
                    UriComponents accessControlAllowOriginComponents = UriComponentsBuilder.fromOriginHeader((String)accessControlAllowOrigin).build();
                    boolean schemeMatch = accessControlAllowOriginComponents.getScheme().equals(originComponents.getScheme());
                    boolean hostMatch = accessControlAllowOriginComponents.getHost().equals(originComponents.getHost());
                    boolean portMatch = StandardHeaderFilter.matchOriginPort(accessControlAllowOriginComponents.getPort(), originComponents.getPort());
                    boolean bl = result = schemeMatch && hostMatch && portMatch;
                    if (!result) continue;
                    break;
                }
                catch (IllegalArgumentException exception) {
                    log.warn((Object)("accessControlAllowOrigin illegalArgument exception, origin=" + accessControlAllowOrigin));
                    result = false;
                }
            }
        }
        catch (IllegalArgumentException exception) {
            log.warn((Object)("origin illegalArgument exception, origin=" + origin));
            result = false;
        }
        return result;
    }

    private static boolean matchOriginPort(int accessControlAllowOriginPort, int originPort) {
        if (originPort == -1 && accessControlAllowOriginPort == 80) {
            return true;
        }
        if (originPort == 80 && accessControlAllowOriginPort == -1) {
            return true;
        }
        return originPort == accessControlAllowOriginPort;
    }

    private static boolean matchOriginHost(String[] accessControllAllowOriginPartialHost, String[] originHost) {
        boolean result = false;
        String[] revertAccessControllAllowOriginPartialHost = StandardHeaderFilter.revertArray(accessControllAllowOriginPartialHost);
        String[] revertOriginHost = StandardHeaderFilter.revertArray(originHost);
        for (int i = 0; i < revertAccessControllAllowOriginPartialHost.length; ++i) {
            if (revertAccessControllAllowOriginPartialHost[i].equals("*")) {
                result = true;
                break;
            }
            if (!revertAccessControllAllowOriginPartialHost[i].equals(revertOriginHost[i])) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    private static String[] revertArray(String[] source) {
        String[] result = null;
        List<String> list = Arrays.asList(source);
        Collections.reverse(list);
        result = (String[])list.toArray();
        return result;
    }
}

