/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWQueryStringParameters;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.restful.DWRestfulRequestInfo;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.app.service.restful.DWRestfulServiceLocationInfo;
import com.digiwin.gateway.filter.DWFilterUtils;
import com.digiwin.gateway.filter.exceptions.DWRestfulMethodNotFoundException;
import com.digiwin.gateway.http.DWRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class DWRestfulMethodLocateFilter
implements Filter {
    private DWContainerContext containerContext;

    public DWRestfulMethodLocateFilter(DWContainerContext containerContext) {
        this.containerContext = containerContext;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DWQueryStringParameters requestParam;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String[] uriParts = httpRequest.getRequestURI().replace("/restful/standard", "").split("/");
        if (!this.isValidUrl(uriParts, httpResponse)) {
            return;
        }
        String groupName = uriParts[1];
        String path = String.join((CharSequence)"/", Arrays.copyOfRange(uriParts, 2, uriParts.length));
        DWRestfulRequestInfo restfulRequestInfo = new DWRestfulRequestInfo(path, (requestParam = new DWQueryStringParameters(httpRequest)).getPararmeters());
        DWRestfulServiceLocationInfo locationInfo = new DWRestfulServiceLocationInfo(groupName, restfulRequestInfo, DWRequestMethod.valueOf((String)httpRequest.getMethod()));
        DWTargetAPI api = this.containerContext.getAPI((DWServiceLocationInfo)locationInfo);
        if (!DWTargetAPI.isValid((DWTargetAPI)api)) {
            DWRestfulMethodNotFoundException e = new DWRestfulMethodNotFoundException(path);
            DWFilterUtils.failResponse((Exception)((Object)e), httpResponse);
            return;
        }
        DWParameters parameters = this.getParameters(api.getMethod(), path, httpRequest, restfulRequestInfo, httpResponse);
        if (parameters == null) {
            return;
        }
        httpRequest.setAttribute("targetAPI", (Object)api);
        httpRequest.setAttribute("targetParameters", (Object)parameters);
        chain.doFilter((ServletRequest)httpRequest, response);
    }

    private boolean isValidUrl(String[] uriParts, HttpServletResponse response) throws IOException {
        if (uriParts == null || uriParts.length < 2) {
            Exception e = new Exception("url rule error!!");
            DWFilterUtils.failResponse(e, response, HttpStatus.NOT_FOUND);
            return false;
        }
        return true;
    }

    private DWParameters getParameters(DWMethod method, String path, HttpServletRequest request, DWRestfulRequestInfo restfulRequestInfo, HttpServletResponse response) throws IOException {
        DWDefaultParameters fileParameters = null;
        if (DWFilterUtils.isMultipartFormDataContentType(request) && (fileParameters = DWFilterUtils.getFormDataParameters(DWDefaultParameters.class, request, response)) == null) {
            return null;
        }
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)request);
        byte[] body = requestWrapper.getBody();
        DWServiceContext.getContext().setRequestBody(new String(requestWrapper.getBody(), StandardCharsets.UTF_8));
        Map pathVariable = restfulRequestInfo.getPathVariable();
        Map requestParam = restfulRequestInfo.getRequestParam();
        DWRestfulRequest restfulRequest = new DWRestfulRequest(body, path, pathVariable, requestParam);
        DWRestfulParameters restfulParameters = new DWRestfulParameters(method, request, restfulRequest);
        restfulParameters.putAll(fileParameters);
        return restfulParameters;
    }

    public void destroy() {
    }
}

