/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.event.DWEvent;
import com.digiwin.gateway.event.DWEventContext;
import com.digiwin.gateway.event.DWEventProcessResult;
import com.digiwin.gateway.event.DWTenantEmployeeDisabledEvent;
import com.digiwin.gateway.event.DWTenantUserJoinedEvent;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DWTenantUserEmployeeController {
    @Autowired
    private DWEventContext dwEventContext;
    private static Log log = LogFactory.getLog(DWTenantUserEmployeeController.class);

    public Object onUserJoined() throws Exception {
        DWTenantUserJoinedEvent joinedEvent = new DWTenantUserJoinedEvent((Object)this, this.parseParameters());
        List resultList = this.dwEventContext.publishEvent((DWEvent)joinedEvent);
        return this.buildStandardResult(resultList);
    }

    public Object onEmployeeDisabled() throws Exception {
        DWTenantEmployeeDisabledEvent disabledEvent = new DWTenantEmployeeDisabledEvent((Object)this, this.parseParameters());
        List resultList = this.dwEventContext.publishEvent((DWEvent)disabledEvent);
        return this.buildStandardResult(resultList);
    }

    private Map<String, Object> parseParameters() throws IOException {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        DWDefaultParameters parameters = new DWDefaultParameters(body);
        return parameters.getPararmeters();
    }

    private <E extends DWEvent> ResponseEntity<Object> buildStandardResult(List<DWEventProcessResult<E>> resultList) throws Exception {
        boolean success;
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        boolean bl = success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        if (!success) {
            DWBusinessException exception = new DWBusinessException("event has error occured, please check logs for details.");
            exception.getInstructors().put("result", resultList);
            throw exception;
        }
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }
}

