/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.eai.DWEAIProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class EaiHealthCheckFilter
implements Filter {
    @Autowired
    private DWEAIProperties properties;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HashSet headerNames = new HashSet(Collections.list(httpRequest.getHeaderNames()));
        if (!headerNames.contains("digi-host") && !headerNames.contains("digi-service")) {
            HttpStatus httpStatus = HttpStatus.OK;
            httpResponse.setHeader("Content-Type", "application/json");
            httpResponse.setHeader("digi-srvver", this.properties.getHostVer());
            httpResponse.setHeader("digi-srvcode", "000");
            httpResponse.setStatus(httpStatus.value());
            httpResponse.getOutputStream().write("".getBytes());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

