/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWDefaultDWDaoEnableCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return DWDefaultDWDaoEnableCondition.isEnabled(context.getEnvironment());
    }

    public static boolean isEnabled(Environment environment) {
        String scheduleEnabled = environment.getProperty("dbEnabled");
        boolean isDbUrlEmpty = DWDefaultDWDaoEnableCondition.isUrlEmpty(environment);
        return "true".equalsIgnoreCase(scheduleEnabled) && !isDbUrlEmpty;
    }

    public static boolean isUrlEmpty(Environment environment) {
        String datasourceUrl = environment.getProperty("dap.dwdao.default.datasource.url");
        String datasourceUrlHost = environment.getProperty("dap.dwdao.default.datasource.url.host");
        return !(datasourceUrl != null && !datasourceUrl.trim().equals("") || datasourceUrlHost != null && !datasourceUrlHost.trim().equals(""));
    }
}

