/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.exceptions;

import com.digiwin.app.container.exceptions.IDWException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWException
extends Exception
implements IDWException {
    private static Log log = LogFactory.getLog(DWException.class);
    public static final String ERROR_TYPE_SYSTEM = "System";
    public static final String ERROR_TYPE_BUSINESS = "Business";
    public static final String ERROR_TYPE_UNEXPECTED = "Unexpected";
    private Map<String, Object> errorInstructors;
    private String errorCode = null;
    private String[] messageArgs;

    public DWException() {
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    public DWException(String message) {
        super(message);
    }

    public DWException(String message, Throwable e) {
        super(message, e);
    }

    public DWException(String message, Throwable e, boolean enableSuppression, boolean writableStackTrace) {
        super(message, e, enableSuppression, writableStackTrace);
    }

    public DWException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public DWException(String errorCode, String message, Throwable e) {
        super(message, e);
        this.errorCode = errorCode;
    }

    public DWException(String errorCode, String message, Throwable e, boolean enableSuppression, boolean writableStackTrace) {
        super(message, e, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }

    @Override
    public String getErrorType() {
        return ERROR_TYPE_SYSTEM;
    }

    @Override
    public Map<String, Object> getInstructors() {
        if (this.errorInstructors == null) {
            this.errorInstructors = new HashMap<String, Object>();
        }
        return this.errorInstructors;
    }

    @Override
    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(String ... messageArgs) {
        this.messageArgs = messageArgs;
    }

    public DWException(String errorCode, String message, String ... messageArgs) {
        this(errorCode, message, (Throwable)null, messageArgs);
    }

    public DWException(String errorCode, String message, Throwable cause, String ... messageArgs) {
        this(errorCode, message, cause, true, false, messageArgs);
    }

    public DWException(String errorCode, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String ... messageArgs) {
        super(String.format(message, messageArgs), cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
        this.setMessageArgs(messageArgs);
    }
}

