/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.sync.DestroyWorkflowThreadError;
import com.uber.cadence.internal.sync.DeterministicRunnerImpl;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.WorkflowThreadLocalInternal;
import com.uber.cadence.workflow.CancellationScope;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Supplier;

interface WorkflowThread
extends CancellationScope {
    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        DeterministicRunnerImpl.currentThreadInternal().yield(reason, unblockCondition);
    }

    public static boolean await(long timeoutMillis, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        return DeterministicRunnerImpl.currentThreadInternal().yield(timeoutMillis, reason, unblockCondition);
    }

    public static WorkflowThread newThread(Runnable runnable, boolean detached) {
        return WorkflowThread.newThread(runnable, detached, null);
    }

    public static WorkflowThread newThread(Runnable runnable, boolean detached, String name) {
        return DeterministicRunnerImpl.currentThreadInternal().getRunner().newThread(runnable, detached, name);
    }

    public void start();

    public void setName(String var1);

    public String getName();

    public long getId();

    public String getStackTrace();

    public DeterministicRunnerImpl getRunner();

    public SyncDecisionContext getDecisionContext();

    public long getBlockedUntil();

    public boolean runUntilBlocked();

    public Throwable getUnhandledException();

    public boolean isDone();

    public Future<?> stopNow();

    public void addStackTrace(StringBuilder var1);

    public void yield(String var1, Supplier<Boolean> var2) throws DestroyWorkflowThreadError;

    public boolean yield(long var1, String var3, Supplier<Boolean> var4) throws DestroyWorkflowThreadError;

    public static <R> void exit(R value) {
        DeterministicRunnerImpl.currentThreadInternal().exitThread(value);
    }

    public <R> void exitThread(R var1);

    public <T> void setThreadLocal(WorkflowThreadLocalInternal<T> var1, T var2);

    public <T> Optional<T> getThreadLocal(WorkflowThreadLocalInternal<T> var1);
}

