/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.uber.cadence.ActivityTaskCancelRequestedEventAttributes;
import com.uber.cadence.ActivityTaskCanceledEventAttributes;
import com.uber.cadence.ActivityTaskCompletedEventAttributes;
import com.uber.cadence.ActivityTaskFailedEventAttributes;
import com.uber.cadence.ActivityTaskScheduledEventAttributes;
import com.uber.cadence.ActivityTaskStartedEventAttributes;
import com.uber.cadence.ActivityTaskTimedOutEventAttributes;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.CancelTimerDecisionAttributes;
import com.uber.cadence.CancelWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ChildWorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionFailedCause;
import com.uber.cadence.ChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionStartedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.CompleteWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.uber.cadence.DecisionTaskCompletedEventAttributes;
import com.uber.cadence.DecisionTaskFailedEventAttributes;
import com.uber.cadence.DecisionTaskScheduledEventAttributes;
import com.uber.cadence.DecisionTaskStartedEventAttributes;
import com.uber.cadence.DecisionTaskTimedOutEventAttributes;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.EventType;
import com.uber.cadence.ExternalWorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.FailWorkflowExecutionDecisionAttributes;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.RequestCancelActivityTaskDecisionAttributes;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RetryPolicy;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionFailedCause;
import com.uber.cadence.SignalExternalWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.TimeoutType;
import com.uber.cadence.TimerCanceledEventAttributes;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.TimerStartedEventAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowExecutionCancelRequestedEventAttributes;
import com.uber.cadence.WorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.WorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.WorkflowExecutionContinuedAsNewEventAttributes;
import com.uber.cadence.WorkflowExecutionFailedEventAttributes;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.internal.testservice.ActivityId;
import com.uber.cadence.internal.testservice.DecisionTaskToken;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.RequestContext;
import com.uber.cadence.internal.testservice.RetryState;
import com.uber.cadence.internal.testservice.StateMachine;
import com.uber.cadence.internal.testservice.TestWorkflowMutableState;
import com.uber.cadence.internal.testservice.TestWorkflowService;
import com.uber.cadence.internal.testservice.TestWorkflowStore;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateMachines {
    private static final Logger log = LoggerFactory.getLogger(StateMachines.class);
    private static final int NO_EVENT_ID = -1;
    private static final String TIMEOUT_ERROR_REASON = "cadenceInternal:Timeout";

    StateMachines() {
    }

    static StateMachine<WorkflowData> newWorkflowStateMachine(WorkflowData data) {
        return new StateMachine<WorkflowData>(data).add(State.NONE, Action.START, State.STARTED, StateMachines::startWorkflow).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeWorkflow).add(State.STARTED, Action.CONTINUE_AS_NEW, State.CONTINUED_AS_NEW, StateMachines::continueAsNewWorkflow).add(State.STARTED, Action.FAIL, State.FAILED, StateMachines::failWorkflow).add(State.STARTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutWorkflow).add(State.STARTED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestWorkflowCancellation).add(State.CANCELLATION_REQUESTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeWorkflow).add(State.CANCELLATION_REQUESTED, Action.CANCEL, State.CANCELED, StateMachines::cancelWorkflow).add(State.CANCELLATION_REQUESTED, Action.FAIL, State.FAILED, StateMachines::failWorkflow).add(State.CANCELLATION_REQUESTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutWorkflow);
    }

    static StateMachine<DecisionTaskData> newDecisionStateMachine(long previousStartedEventId, TestWorkflowStore store) {
        return new StateMachine<DecisionTaskData>(new DecisionTaskData(previousStartedEventId, store)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::scheduleDecisionTask).add(State.INITIATED, Action.START, State.STARTED, StateMachines::startDecisionTask).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeDecisionTask).add(State.STARTED, Action.FAIL, State.FAILED, StateMachines::failDecisionTask).add(State.STARTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutDecisionTask).add(State.TIMED_OUT, Action.INITIATE, State.INITIATED, StateMachines::scheduleDecisionTask).add(State.FAILED, Action.INITIATE, State.INITIATED, StateMachines::scheduleDecisionTask);
    }

    public static StateMachine<ActivityTaskData> newActivityStateMachine(TestWorkflowStore store, StartWorkflowExecutionRequest workflowStartedEvent) {
        return new StateMachine<ActivityTaskData>(new ActivityTaskData(store, workflowStartedEvent)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::scheduleActivityTask).add(State.INITIATED, Action.START, State.STARTED, StateMachines::startActivityTask).add(State.INITIATED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutActivityTask).add(State.INITIATED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestActivityCancellation).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeActivityTask).add(State.STARTED, Action.FAIL, new State[]{State.FAILED, State.INITIATED}, StateMachines::failActivityTask).add(State.STARTED, Action.TIME_OUT, new State[]{State.TIMED_OUT, State.INITIATED}, StateMachines::timeoutActivityTask).add(State.STARTED, Action.UPDATE, State.STARTED, StateMachines::heartbeatActivityTask).add(State.STARTED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestActivityCancellation).add(State.CANCELLATION_REQUESTED, Action.CANCEL, State.CANCELED, StateMachines::reportActivityTaskCancellation).add(State.CANCELLATION_REQUESTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeActivityTask).add(State.CANCELLATION_REQUESTED, Action.UPDATE, State.CANCELLATION_REQUESTED, StateMachines::heartbeatActivityTask).add(State.CANCELLATION_REQUESTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutActivityTask).add(State.CANCELLATION_REQUESTED, Action.FAIL, State.FAILED, StateMachines::failActivityTask);
    }

    public static StateMachine<ChildWorkflowData> newChildWorkflowStateMachine(TestWorkflowService service) {
        return new StateMachine<ChildWorkflowData>(new ChildWorkflowData(service)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::initiateChildWorkflow).add(State.INITIATED, Action.START, State.STARTED, StateMachines::childWorkflowStarted).add(State.INITIATED, Action.FAIL, State.FAILED, StateMachines::startChildWorkflowFailed).add(State.INITIATED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutChildWorkflow).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::childWorkflowCompleted).add(State.STARTED, Action.FAIL, State.FAILED, StateMachines::childWorkflowFailed).add(State.STARTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutChildWorkflow).add(State.STARTED, Action.CANCEL, State.CANCELED, StateMachines::childWorkflowCanceled);
    }

    public static StateMachine<TimerData> newTimerStateMachine() {
        return new StateMachine<TimerData>(new TimerData()).add(State.NONE, Action.START, State.STARTED, StateMachines::startTimer).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::fireTimer).add(State.STARTED, Action.CANCEL, State.CANCELED, StateMachines::cancelTimer);
    }

    public static StateMachine<SignalExternalData> newSignalExternalStateMachine() {
        return new StateMachine<SignalExternalData>(new SignalExternalData()).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::initiateExternalSignal).add(State.INITIATED, Action.FAIL, State.FAILED, StateMachines::failExternalSignal).add(State.INITIATED, Action.COMPLETE, State.COMPLETED, StateMachines::completeExternalSignal);
    }

    private static void timeoutChildWorkflow(RequestContext ctx, ChildWorkflowData data, TimeoutType timeoutType, long notUsed) {
        StartChildWorkflowExecutionInitiatedEventAttributes ie = data.initiatedEvent;
        ChildWorkflowExecutionTimedOutEventAttributes a = new ChildWorkflowExecutionTimedOutEventAttributes().setDomain(ie.getDomain()).setStartedEventId(data.startedEventId).setWorkflowExecution(data.execution).setWorkflowType(ie.getWorkflowType()).setTimeoutType(timeoutType).setInitiatedEventId(data.initiatedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ChildWorkflowExecutionTimedOut).setChildWorkflowExecutionTimedOutEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void startChildWorkflowFailed(RequestContext ctx, ChildWorkflowData data, StartChildWorkflowExecutionFailedEventAttributes a, long notUsed) {
        a.setInitiatedEventId(data.initiatedEventId);
        a.setWorkflowType(data.initiatedEvent.getWorkflowType());
        a.setWorkflowId(data.initiatedEvent.getWorkflowId());
        if (data.initiatedEvent.isSetDomain()) {
            a.setDomain(data.initiatedEvent.getDomain());
        }
        HistoryEvent event = new HistoryEvent().setEventType(EventType.StartChildWorkflowExecutionFailed).setStartChildWorkflowExecutionFailedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void childWorkflowStarted(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionStartedEventAttributes a, long notUsed) {
        a.setInitiatedEventId(data.initiatedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ChildWorkflowExecutionStarted).setChildWorkflowExecutionStartedEventAttributes(a);
        long startedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.startedEventId = startedEventId;
            data.execution = a.getWorkflowExecution();
        });
    }

    private static void childWorkflowCompleted(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionCompletedEventAttributes a, long notUsed) {
        a.setInitiatedEventId(data.initiatedEventId).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ChildWorkflowExecutionCompleted).setChildWorkflowExecutionCompletedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void childWorkflowFailed(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionFailedEventAttributes a, long notUsed) {
        a.setInitiatedEventId(data.initiatedEventId);
        a.setStartedEventId(data.startedEventId);
        a.setWorkflowExecution(data.execution);
        a.setWorkflowType(data.initiatedEvent.getWorkflowType());
        if (data.initiatedEvent.domain != null) {
            a.setDomain(data.initiatedEvent.domain);
        }
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ChildWorkflowExecutionFailed).setChildWorkflowExecutionFailedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void childWorkflowCanceled(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionCanceledEventAttributes a, long notUsed) {
        a.setInitiatedEventId(data.initiatedEventId);
        a.setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ChildWorkflowExecutionCanceled).setChildWorkflowExecutionCanceledEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void initiateChildWorkflow(RequestContext ctx, ChildWorkflowData data, StartChildWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        StartChildWorkflowExecutionInitiatedEventAttributes a = new StartChildWorkflowExecutionInitiatedEventAttributes().setControl(d.getControl()).setInput(d.getInput()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId).setDomain(d.getDomain() == null ? ctx.getDomain() : d.getDomain()).setExecutionStartToCloseTimeoutSeconds(d.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(d.getTaskStartToCloseTimeoutSeconds()).setTaskList(d.getTaskList()).setWorkflowId(d.getWorkflowId()).setWorkflowIdReusePolicy(d.getWorkflowIdReusePolicy()).setWorkflowType(d.getWorkflowType()).setRetryPolicy(d.getRetryPolicy()).setCronSchedule(d.getCronSchedule()).setHeader(d.getHeader()).setParentClosePolicy(d.getParentClosePolicy());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.StartChildWorkflowExecutionInitiated).setStartChildWorkflowExecutionInitiatedEventAttributes(a);
        long initiatedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.initiatedEventId = initiatedEventId;
            data.initiatedEvent = a;
            StartWorkflowExecutionRequest startChild = new StartWorkflowExecutionRequest().setDomain(d.getDomain() == null ? ctx.getDomain() : d.getDomain()).setExecutionStartToCloseTimeoutSeconds(d.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(d.getTaskStartToCloseTimeoutSeconds()).setTaskList(d.getTaskList()).setWorkflowId(d.getWorkflowId()).setWorkflowIdReusePolicy(d.getWorkflowIdReusePolicy()).setWorkflowType(d.getWorkflowType()).setRetryPolicy(d.getRetryPolicy()).setCronSchedule(d.getCronSchedule()).setHeader(d.getHeader());
            if (d.isSetInput()) {
                startChild.setInput(d.getInput());
            }
            StateMachines.addStartChildTask(ctx, data, initiatedEventId, startChild);
        });
    }

    private static void addStartChildTask(RequestContext ctx, ChildWorkflowData data, long initiatedEventId, StartWorkflowExecutionRequest startChild) {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                data.service.startWorkflowExecutionImpl(startChild, 0, Optional.of(ctx.getWorkflowMutableState()), OptionalLong.of(data.initiatedEventId), Optional.empty());
            }
            catch (WorkflowExecutionAlreadyStartedError workflowExecutionAlreadyStartedError) {
                StartChildWorkflowExecutionFailedEventAttributes failRequest = new StartChildWorkflowExecutionFailedEventAttributes().setInitiatedEventId(initiatedEventId).setCause(ChildWorkflowExecutionFailedCause.WORKFLOW_ALREADY_RUNNING);
                try {
                    ctx.getWorkflowMutableState().failStartChildWorkflow(data.initiatedEvent.getWorkflowId(), failRequest);
                }
                catch (Throwable e) {
                    log.error("Unexpected failure inserting failStart for a child workflow", e);
                }
            }
            catch (Exception e) {
                log.error("Unexpected failure starting a child workflow", (Throwable)e);
            }
        });
    }

    private static void startWorkflow(RequestContext ctx, WorkflowData data, StartWorkflowExecutionRequest request, long notUsed) throws BadRequestError {
        WorkflowExecutionStartedEventAttributes a = new WorkflowExecutionStartedEventAttributes();
        if (request.isSetIdentity()) {
            a.setIdentity(request.getIdentity());
        }
        if (!request.isSetTaskStartToCloseTimeoutSeconds()) {
            throw new BadRequestError("missing taskStartToCloseTimeoutSeconds");
        }
        a.setTaskStartToCloseTimeoutSeconds(request.getTaskStartToCloseTimeoutSeconds());
        if (!request.isSetWorkflowType()) {
            throw new BadRequestError("missing workflowType");
        }
        a.setWorkflowType(request.getWorkflowType());
        if (!request.isSetTaskList()) {
            throw new BadRequestError("missing taskList");
        }
        a.setTaskList(request.getTaskList());
        if (!request.isSetExecutionStartToCloseTimeoutSeconds()) {
            throw new BadRequestError("missing executionStartToCloseTimeoutSeconds");
        }
        a.setExecutionStartToCloseTimeoutSeconds(request.getExecutionStartToCloseTimeoutSeconds());
        if (request.isSetInput()) {
            a.setInput(request.getInput());
        }
        if (data.retryState.isPresent()) {
            a.setAttempt(data.retryState.get().getAttempt());
        }
        a.setOriginalExecutionRunId(data.originalExecutionRunId);
        if (data.continuedExecutionRunId.isPresent()) {
            a.setContinuedExecutionRunId(data.continuedExecutionRunId.get());
        }
        a.setLastCompletionResult(data.lastCompletionResult);
        a.setMemo(request.getMemo());
        a.setSearchAttributes(request.getSearchAttributes());
        a.setHeader(request.getHeader());
        Optional<TestWorkflowMutableState> parent = ctx.getWorkflowMutableState().getParent();
        if (parent.isPresent()) {
            ExecutionId parentExecutionId = parent.get().getExecutionId();
            a.setParentWorkflowDomain(parentExecutionId.getDomain());
            a.setParentWorkflowExecution(parentExecutionId.getExecution());
        }
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionStarted).setWorkflowExecutionStartedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void completeWorkflow(RequestContext ctx, WorkflowData data, CompleteWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        WorkflowExecutionCompletedEventAttributes a = new WorkflowExecutionCompletedEventAttributes().setResult(d.getResult()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionCompleted).setWorkflowExecutionCompletedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void continueAsNewWorkflow(RequestContext ctx, WorkflowData data, ContinueAsNewWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        StartWorkflowExecutionRequest sr = ctx.getWorkflowMutableState().getStartRequest();
        WorkflowExecutionContinuedAsNewEventAttributes a = new WorkflowExecutionContinuedAsNewEventAttributes();
        a.setInput(d.getInput());
        if (d.isSetExecutionStartToCloseTimeoutSeconds()) {
            a.setExecutionStartToCloseTimeoutSeconds(d.getExecutionStartToCloseTimeoutSeconds());
        } else {
            a.setExecutionStartToCloseTimeoutSeconds(sr.getExecutionStartToCloseTimeoutSeconds());
        }
        if (d.isSetTaskList()) {
            a.setTaskList(d.getTaskList());
        } else {
            a.setTaskList(sr.getTaskList());
        }
        if (d.isSetWorkflowType()) {
            a.setWorkflowType(d.getWorkflowType());
        } else {
            a.setWorkflowType(sr.getWorkflowType());
        }
        if (d.isSetTaskStartToCloseTimeoutSeconds()) {
            a.setTaskStartToCloseTimeoutSeconds(d.getTaskStartToCloseTimeoutSeconds());
        } else {
            a.setTaskStartToCloseTimeoutSeconds(sr.getTaskStartToCloseTimeoutSeconds());
        }
        a.setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        a.setBackoffStartIntervalInSeconds(d.getBackoffStartIntervalInSeconds());
        a.setLastCompletionResult(d.getLastCompletionResult());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionContinuedAsNew).setWorkflowExecutionContinuedAsNewEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void failWorkflow(RequestContext ctx, WorkflowData data, FailWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        WorkflowExecutionFailedEventAttributes a = new WorkflowExecutionFailedEventAttributes().setReason(d.getReason()).setDetails(d.getDetails()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionFailed).setWorkflowExecutionFailedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void timeoutWorkflow(RequestContext ctx, WorkflowData data, TimeoutType timeoutType, long notUsed) {
        WorkflowExecutionTimedOutEventAttributes a = new WorkflowExecutionTimedOutEventAttributes().setTimeoutType(timeoutType);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionTimedOut).setWorkflowExecutionTimedOutEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void cancelWorkflow(RequestContext ctx, WorkflowData data, CancelWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        WorkflowExecutionCanceledEventAttributes a = new WorkflowExecutionCanceledEventAttributes().setDetails(d.getDetails()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.WorkflowExecutionCanceled).setWorkflowExecutionCanceledEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void requestWorkflowCancellation(RequestContext ctx, WorkflowData data, RequestCancelWorkflowExecutionRequest cancelRequest, long notUsed) {
        WorkflowExecutionCancelRequestedEventAttributes a = new WorkflowExecutionCancelRequestedEventAttributes().setIdentity(cancelRequest.getIdentity());
        HistoryEvent cancelRequested = new HistoryEvent().setEventType(EventType.WorkflowExecutionCancelRequested).setWorkflowExecutionCancelRequestedEventAttributes(a);
        ctx.addEvent(cancelRequested);
    }

    private static void scheduleActivityTask(RequestContext ctx, ActivityTaskData data, ScheduleActivityTaskDecisionAttributes d, long decisionTaskCompletedEventId) throws BadRequestError {
        ActivityTaskScheduledEventAttributes a;
        RetryState retryState;
        int scheduleToCloseTimeoutSeconds = d.getScheduleToCloseTimeoutSeconds();
        int scheduleToStartTimeoutSeconds = d.getScheduleToStartTimeoutSeconds();
        RetryPolicy retryPolicy = d.getRetryPolicy();
        if (retryPolicy != null) {
            long expirationInterval = TimeUnit.SECONDS.toMillis(retryPolicy.getExpirationIntervalInSeconds());
            long expirationTime = data.store.currentTimeMillis() + expirationInterval;
            retryState = new RetryState(retryPolicy, expirationTime);
            int overriddenTimeout = retryPolicy.getExpirationIntervalInSeconds() > 0 ? retryPolicy.getExpirationIntervalInSeconds() : data.startWorkflowExecutionRequest.getExecutionStartToCloseTimeoutSeconds();
            scheduleToCloseTimeoutSeconds = overriddenTimeout;
            scheduleToStartTimeoutSeconds = overriddenTimeout;
        } else {
            retryState = null;
        }
        data.scheduledEvent = a = new ActivityTaskScheduledEventAttributes().setInput(d.getInput()).setActivityId(d.getActivityId()).setActivityType(d.getActivityType()).setDomain(d.getDomain() == null ? ctx.getDomain() : d.getDomain()).setHeartbeatTimeoutSeconds(d.getHeartbeatTimeoutSeconds()).setScheduleToCloseTimeoutSeconds(scheduleToCloseTimeoutSeconds).setScheduleToStartTimeoutSeconds(scheduleToStartTimeoutSeconds).setStartToCloseTimeoutSeconds(d.getStartToCloseTimeoutSeconds()).setTaskList(d.getTaskList()).setRetryPolicy(retryPolicy).setHeader(d.getHeader()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskScheduled).setActivityTaskScheduledEventAttributes(a);
        long scheduledEventId = ctx.addEvent(event);
        PollForActivityTaskResponse taskResponse = new PollForActivityTaskResponse().setWorkflowDomain(ctx.getDomain()).setWorkflowType(data.startWorkflowExecutionRequest.workflowType).setActivityType(d.getActivityType()).setWorkflowExecution(ctx.getExecution()).setActivityId(d.getActivityId()).setInput(d.getInput()).setHeartbeatTimeoutSeconds(d.getHeartbeatTimeoutSeconds()).setScheduleToCloseTimeoutSeconds(scheduleToCloseTimeoutSeconds).setStartToCloseTimeoutSeconds(d.getStartToCloseTimeoutSeconds()).setScheduledTimestamp(ctx.currentTimeInNanoseconds()).setScheduledTimestampOfThisAttempt(ctx.currentTimeInNanoseconds()).setHeader(d.getHeader()).setAttempt(0);
        TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(ctx.getDomain(), d.getTaskList().getName());
        TestWorkflowStore.ActivityTask activityTask = new TestWorkflowStore.ActivityTask(taskListId, taskResponse);
        ctx.addActivityTask(activityTask);
        ctx.onCommit(historySize -> {
            data.scheduledEventId = scheduledEventId;
            data.activityTask = activityTask;
            data.retryState = retryState;
        });
    }

    private static void requestActivityCancellation(RequestContext ctx, ActivityTaskData data, RequestCancelActivityTaskDecisionAttributes d, long decisionTaskCompletedEventId) {
        ActivityTaskCancelRequestedEventAttributes a = new ActivityTaskCancelRequestedEventAttributes().setActivityId(d.getActivityId()).setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskCancelRequested).setActivityTaskCancelRequestedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void scheduleDecisionTask(RequestContext ctx, DecisionTaskData data, StartWorkflowExecutionRequest request, long notUsed) {
        DecisionTaskScheduledEventAttributes a = new DecisionTaskScheduledEventAttributes().setStartToCloseTimeoutSeconds(request.getTaskStartToCloseTimeoutSeconds()).setTaskList(request.getTaskList()).setAttempt(data.attempt);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.DecisionTaskScheduled).setDecisionTaskScheduledEventAttributes(a);
        long scheduledEventId = ctx.addEvent(event);
        PollForDecisionTaskResponse decisionTaskResponse = new PollForDecisionTaskResponse();
        if (data.previousStartedEventId > 0L) {
            decisionTaskResponse.setPreviousStartedEventId(data.previousStartedEventId);
        }
        decisionTaskResponse.setWorkflowExecution(ctx.getExecution());
        decisionTaskResponse.setWorkflowType(request.getWorkflowType());
        decisionTaskResponse.setAttempt(data.attempt);
        TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(ctx.getDomain(), request.getTaskList().getName());
        TestWorkflowStore.DecisionTask decisionTask = new TestWorkflowStore.DecisionTask(taskListId, decisionTaskResponse);
        ctx.setDecisionTask(decisionTask);
        ctx.onCommit(historySize -> {
            data.scheduledEventId = scheduledEventId;
            data.decisionTask = decisionTaskResponse;
        });
    }

    private static void startDecisionTask(RequestContext ctx, DecisionTaskData data, PollForDecisionTaskRequest request, long notUsed) {
        DecisionTaskStartedEventAttributes a = new DecisionTaskStartedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.DecisionTaskStarted).setDecisionTaskStartedEventAttributes(a);
        long startedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            List<HistoryEvent> events;
            data.decisionTask.setStartedEventId(startedEventId);
            DecisionTaskToken taskToken = new DecisionTaskToken(ctx.getExecutionId(), historySize);
            data.decisionTask.setTaskToken(taskToken.toBytes());
            GetWorkflowExecutionHistoryRequest getRequest = new GetWorkflowExecutionHistoryRequest().setDomain(request.getDomain()).setExecution(ctx.getExecution());
            try {
                events = data.store.getWorkflowExecutionHistory(ctx.getExecutionId(), getRequest).getHistory().getEvents();
                if (ctx.getWorkflowMutableState().getStickyExecutionAttributes() != null) {
                    events = events.subList((int)data.previousStartedEventId, events.size());
                }
            }
            catch (EntityNotExistsError entityNotExistsError) {
                throw new InternalServiceError(entityNotExistsError.toString());
            }
            data.decisionTask.setHistory(new History().setEvents(events));
            data.startedEventId = startedEventId;
            ++data.attempt;
        });
    }

    private static void startActivityTask(RequestContext ctx, ActivityTaskData data, PollForActivityTaskRequest request, long notUsed) {
        ActivityTaskStartedEventAttributes a = new ActivityTaskStartedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId);
        if (data.retryState != null) {
            a.setAttempt(data.retryState.getAttempt());
        }
        long timestamp = TimeUnit.MILLISECONDS.toNanos(data.store.currentTimeMillis());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskStarted).setTimestamp(timestamp).setActivityTaskStartedEventAttributes(a);
        long startedEventId = data.retryState == null ? ctx.addEvent(event) : -1L;
        ctx.onCommit(historySize -> {
            data.startedEventId = startedEventId;
            data.startedEvent = event;
            PollForActivityTaskResponse task = data.activityTask.getTask();
            task.setTaskToken(new ActivityId(ctx.getExecutionId(), task.getActivityId()).toBytes());
            task.setStartedTimestamp(timestamp);
        });
    }

    private static void completeDecisionTask(RequestContext ctx, DecisionTaskData data, RespondDecisionTaskCompletedRequest request, long notUsed) {
        DecisionTaskCompletedEventAttributes a = new DecisionTaskCompletedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.DecisionTaskCompleted).setDecisionTaskCompletedEventAttributes(a);
        ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.attempt = 0;
        });
    }

    private static void failDecisionTask(RequestContext ctx, DecisionTaskData data, RespondDecisionTaskFailedRequest request, long notUsed) {
        DecisionTaskFailedEventAttributes a = new DecisionTaskFailedEventAttributes().setIdentity(request.getIdentity()).setCause(request.getCause()).setDetails(request.getDetails()).setStartedEventId(data.startedEventId).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.DecisionTaskFailed).setDecisionTaskFailedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void timeoutDecisionTask(RequestContext ctx, DecisionTaskData data, Object ignored, long notUsed) {
        DecisionTaskTimedOutEventAttributes a = new DecisionTaskTimedOutEventAttributes().setStartedEventId(data.startedEventId).setTimeoutType(TimeoutType.START_TO_CLOSE).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.DecisionTaskTimedOut).setDecisionTaskTimedOutEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void completeActivityTask(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        if (data.retryState != null) {
            ctx.addEvent(data.startedEvent);
        }
        if (request instanceof RespondActivityTaskCompletedRequest) {
            StateMachines.completeActivityTaskByTaskToken(ctx, data, (RespondActivityTaskCompletedRequest)request);
        } else if (request instanceof RespondActivityTaskCompletedByIDRequest) {
            StateMachines.completeActivityTaskById(ctx, data, (RespondActivityTaskCompletedByIDRequest)request);
        } else {
            throw new IllegalArgumentException("Unknown request: " + request);
        }
    }

    private static void completeActivityTaskByTaskToken(RequestContext ctx, ActivityTaskData data, RespondActivityTaskCompletedRequest request) {
        ActivityTaskCompletedEventAttributes a = new ActivityTaskCompletedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setResult(request.getResult()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskCompleted).setActivityTaskCompletedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void completeActivityTaskById(RequestContext ctx, ActivityTaskData data, RespondActivityTaskCompletedByIDRequest request) {
        ActivityTaskCompletedEventAttributes a = new ActivityTaskCompletedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setResult(request.getResult()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskCompleted).setActivityTaskCompletedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static State failActivityTask(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        if (request instanceof RespondActivityTaskFailedRequest) {
            return StateMachines.failActivityTaskByTaskToken(ctx, data, (RespondActivityTaskFailedRequest)request);
        }
        if (request instanceof RespondActivityTaskFailedByIDRequest) {
            return StateMachines.failActivityTaskById(ctx, data, (RespondActivityTaskFailedByIDRequest)request);
        }
        throw new IllegalArgumentException("Unknown request: " + request);
    }

    private static State failActivityTaskByTaskToken(RequestContext ctx, ActivityTaskData data, RespondActivityTaskFailedRequest request) {
        if (StateMachines.attemptActivityRetry(ctx, request.getReason(), data)) {
            return State.INITIATED;
        }
        ActivityTaskFailedEventAttributes a = new ActivityTaskFailedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setDetails(request.getDetails()).setReason(request.getReason()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskFailed).setActivityTaskFailedEventAttributes(a);
        ctx.addEvent(event);
        return State.FAILED;
    }

    private static State failActivityTaskById(RequestContext ctx, ActivityTaskData data, RespondActivityTaskFailedByIDRequest request) {
        if (StateMachines.attemptActivityRetry(ctx, request.getReason(), data)) {
            return State.INITIATED;
        }
        ActivityTaskFailedEventAttributes a = new ActivityTaskFailedEventAttributes().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setDetails(request.getDetails()).setReason(request.getReason()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskFailed).setActivityTaskFailedEventAttributes(a);
        ctx.addEvent(event);
        return State.FAILED;
    }

    private static State timeoutActivityTask(RequestContext ctx, ActivityTaskData data, TimeoutType timeoutType, long notUsed) {
        if (timeoutType != TimeoutType.SCHEDULE_TO_START && StateMachines.attemptActivityRetry(ctx, TIMEOUT_ERROR_REASON, data)) {
            return State.INITIATED;
        }
        ActivityTaskTimedOutEventAttributes a = new ActivityTaskTimedOutEventAttributes().setScheduledEventId(data.scheduledEventId).setDetails(data.heartbeatDetails).setTimeoutType(timeoutType).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskTimedOut).setActivityTaskTimedOutEventAttributes(a);
        ctx.addEvent(event);
        return State.TIMED_OUT;
    }

    private static boolean attemptActivityRetry(RequestContext ctx, String errorReason, ActivityTaskData data) {
        if (data.retryState != null) {
            RetryState nextAttempt = data.retryState.getNextAttempt();
            data.nextBackoffIntervalSeconds = data.retryState.getBackoffIntervalInSeconds(errorReason, data.store.currentTimeMillis());
            if (data.nextBackoffIntervalSeconds > 0L) {
                PollForActivityTaskResponse task = data.activityTask.getTask();
                task.setHeartbeatDetails(data.heartbeatDetails);
                ctx.onCommit(historySize -> {
                    data.retryState = nextAttempt;
                    task.setAttempt(nextAttempt.getAttempt());
                    task.setScheduledTimestampOfThisAttempt(ctx.currentTimeInNanoseconds());
                });
                return true;
            }
            data.startedEventId = ctx.addEvent(data.startedEvent);
        }
        return false;
    }

    private static void reportActivityTaskCancellation(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        byte[] details = null;
        if (request instanceof RespondActivityTaskCanceledRequest) {
            details = ((RespondActivityTaskCanceledRequest)request).getDetails();
        } else if (request instanceof RespondActivityTaskCanceledByIDRequest) {
            details = ((RespondActivityTaskCanceledByIDRequest)request).getDetails();
        }
        ActivityTaskCanceledEventAttributes a = new ActivityTaskCanceledEventAttributes().setScheduledEventId(data.scheduledEventId).setStartedEventId(data.startedEventId);
        if (details != null) {
            a.setDetails(details);
        }
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ActivityTaskCanceled).setActivityTaskCanceledEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void heartbeatActivityTask(RequestContext nullCtx, ActivityTaskData data, byte[] details, long notUsed) {
        data.heartbeatDetails = details;
    }

    private static void startTimer(RequestContext ctx, TimerData data, StartTimerDecisionAttributes d, long decisionTaskCompletedEventId) {
        TimerStartedEventAttributes a = new TimerStartedEventAttributes().setDecisionTaskCompletedEventId(decisionTaskCompletedEventId).setStartToFireTimeoutSeconds(d.getStartToFireTimeoutSeconds()).setTimerId(d.getTimerId());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.TimerStarted).setTimerStartedEventAttributes(a);
        long startedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.startedEvent = a;
            data.startedEventId = startedEventId;
        });
    }

    private static void fireTimer(RequestContext ctx, TimerData data, Object ignored, long notUsed) {
        TimerFiredEventAttributes a = new TimerFiredEventAttributes().setTimerId(data.startedEvent.getTimerId()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.TimerFired).setTimerFiredEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void cancelTimer(RequestContext ctx, TimerData data, CancelTimerDecisionAttributes d, long decisionTaskCompletedEventId) {
        TimerCanceledEventAttributes a = new TimerCanceledEventAttributes().setDecisionTaskCompletedEventId(decisionTaskCompletedEventId).setTimerId(d.getTimerId()).setStartedEventId(data.startedEventId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.TimerCanceled).setTimerCanceledEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void initiateExternalSignal(RequestContext ctx, SignalExternalData data, SignalExternalWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedEventId) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes a = new SignalExternalWorkflowExecutionInitiatedEventAttributes();
        a.setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        if (d.isSetControl()) {
            a.setControl(d.getControl());
        }
        if (d.isSetInput()) {
            a.setInput(d.getInput());
        }
        if (d.isSetDomain()) {
            a.setDomain(d.getDomain());
        }
        if (d.isSetChildWorkflowOnly()) {
            a.setChildWorkflowOnly(d.isChildWorkflowOnly());
        }
        a.setSignalName(d.getSignalName());
        a.setWorkflowExecution(d.getExecution());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.SignalExternalWorkflowExecutionInitiated).setSignalExternalWorkflowExecutionInitiatedEventAttributes(a);
        long initiatedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.initiatedEventId = initiatedEventId;
            data.initiatedEvent = a;
        });
    }

    private static void failExternalSignal(RequestContext ctx, SignalExternalData data, SignalExternalWorkflowExecutionFailedCause cause, long notUsed) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        SignalExternalWorkflowExecutionFailedEventAttributes a = new SignalExternalWorkflowExecutionFailedEventAttributes().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(initiatedEvent.getWorkflowExecution()).setControl(initiatedEvent.getControl()).setCause(cause).setDomain(initiatedEvent.getDomain());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.SignalExternalWorkflowExecutionFailed).setSignalExternalWorkflowExecutionFailedEventAttributes(a);
        ctx.addEvent(event);
    }

    private static void completeExternalSignal(RequestContext ctx, SignalExternalData data, String runId, long notUsed) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        WorkflowExecution signaledExecution = initiatedEvent.getWorkflowExecution().deepCopy().setRunId(runId);
        ExternalWorkflowExecutionSignaledEventAttributes a = new ExternalWorkflowExecutionSignaledEventAttributes().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(signaledExecution).setControl(initiatedEvent.getControl()).setDomain(initiatedEvent.getDomain());
        HistoryEvent event = new HistoryEvent().setEventType(EventType.ExternalWorkflowExecutionSignaled).setExternalWorkflowExecutionSignaledEventAttributes(a);
        ctx.addEvent(event);
    }

    static final class TimerData {
        TimerStartedEventAttributes startedEvent;
        public long startedEventId;

        TimerData() {
        }
    }

    static final class ChildWorkflowData {
        final TestWorkflowService service;
        StartChildWorkflowExecutionInitiatedEventAttributes initiatedEvent;
        long initiatedEventId;
        long startedEventId;
        WorkflowExecution execution;

        public ChildWorkflowData(TestWorkflowService service) {
            this.service = service;
        }
    }

    static final class SignalExternalData {
        long initiatedEventId = -1L;
        public SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent;

        SignalExternalData() {
        }
    }

    static final class ActivityTaskData {
        StartWorkflowExecutionRequest startWorkflowExecutionRequest;
        ActivityTaskScheduledEventAttributes scheduledEvent;
        TestWorkflowStore.ActivityTask activityTask;
        final TestWorkflowStore store;
        long scheduledEventId = -1L;
        long startedEventId = -1L;
        public HistoryEvent startedEvent;
        byte[] heartbeatDetails;
        long lastHeartbeatTime;
        RetryState retryState;
        long nextBackoffIntervalSeconds;

        ActivityTaskData(TestWorkflowStore store, StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
            this.store = store;
            this.startWorkflowExecutionRequest = startWorkflowExecutionRequest;
        }
    }

    static final class DecisionTaskData {
        final long previousStartedEventId;
        final TestWorkflowStore store;
        long startedEventId = -1L;
        PollForDecisionTaskResponse decisionTask;
        long scheduledEventId = -1L;
        int attempt;

        DecisionTaskData(long previousStartedEventId, TestWorkflowStore store) {
            this.previousStartedEventId = previousStartedEventId;
            this.store = store;
        }
    }

    static final class WorkflowData {
        Optional<RetryState> retryState = Optional.empty();
        int backoffStartIntervalInSeconds;
        String cronSchedule;
        byte[] lastCompletionResult;
        String originalExecutionRunId;
        Optional<String> continuedExecutionRunId;

        WorkflowData(Optional<RetryState> retryState, int backoffStartIntervalInSeconds, String cronSchedule, byte[] lastCompletionResult, String originalExecutionRunId, Optional<String> continuedExecutionRunId) {
            this.retryState = retryState;
            this.backoffStartIntervalInSeconds = backoffStartIntervalInSeconds;
            this.cronSchedule = cronSchedule;
            this.lastCompletionResult = lastCompletionResult;
            this.originalExecutionRunId = originalExecutionRunId;
            this.continuedExecutionRunId = continuedExecutionRunId;
        }
    }

    static enum Action {
        INITIATE,
        START,
        FAIL,
        TIME_OUT,
        REQUEST_CANCELLATION,
        CANCEL,
        UPDATE,
        COMPLETE,
        CONTINUE_AS_NEW;

    }

    static enum State {
        NONE,
        INITIATED,
        STARTED,
        FAILED,
        TIMED_OUT,
        CANCELLATION_REQUESTED,
        CANCELED,
        COMPLETED,
        CONTINUED_AS_NEW;

    }
}

