/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.uber.cadence.ActivityTaskScheduledEventAttributes;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.CancelTimerDecisionAttributes;
import com.uber.cadence.CancelTimerFailedEventAttributes;
import com.uber.cadence.CancelWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ChildWorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionStartedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.CompleteWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.uber.cadence.Decision;
import com.uber.cadence.DecisionTaskFailedCause;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.EventType;
import com.uber.cadence.FailWorkflowExecutionDecisionAttributes;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.QueryRejectCondition;
import com.uber.cadence.QueryRejected;
import com.uber.cadence.QueryTaskCompletedType;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.RecordMarkerDecisionAttributes;
import com.uber.cadence.RequestCancelActivityTaskDecisionAttributes;
import com.uber.cadence.RequestCancelActivityTaskFailedEventAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.RetryPolicy;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionFailedCause;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StickyExecutionAttributes;
import com.uber.cadence.TimeoutType;
import com.uber.cadence.UpsertWorkflowSearchAttributesDecisionAttributes;
import com.uber.cadence.UpsertWorkflowSearchAttributesEventAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionCloseStatus;
import com.uber.cadence.WorkflowExecutionContinuedAsNewEventAttributes;
import com.uber.cadence.WorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.LockHandle;
import com.uber.cadence.internal.testservice.RequestContext;
import com.uber.cadence.internal.testservice.RetryState;
import com.uber.cadence.internal.testservice.SelfAdvancingTimer;
import com.uber.cadence.internal.testservice.StateMachine;
import com.uber.cadence.internal.testservice.StateMachines;
import com.uber.cadence.internal.testservice.TestWorkflowMutableState;
import com.uber.cadence.internal.testservice.TestWorkflowService;
import com.uber.cadence.internal.testservice.TestWorkflowStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestWorkflowMutableStateImpl
implements TestWorkflowMutableState {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowMutableStateImpl.class);
    private final Lock lock = new ReentrantLock();
    private final SelfAdvancingTimer selfAdvancingTimer;
    private final LongSupplier clock;
    private final ExecutionId executionId;
    private final Optional<TestWorkflowMutableState> parent;
    private final OptionalLong parentChildInitiatedEventId;
    private final TestWorkflowStore store;
    private final TestWorkflowService service;
    private final StartWorkflowExecutionRequest startRequest;
    private long nextEventId;
    private final List<RequestContext> concurrentToDecision = new ArrayList<RequestContext>();
    private final Map<String, StateMachine<StateMachines.ActivityTaskData>> activities = new HashMap<String, StateMachine<StateMachines.ActivityTaskData>>();
    private final Map<Long, StateMachine<StateMachines.ChildWorkflowData>> childWorkflows = new HashMap<Long, StateMachine<StateMachines.ChildWorkflowData>>();
    private final Map<String, StateMachine<StateMachines.TimerData>> timers = new HashMap<String, StateMachine<StateMachines.TimerData>>();
    private final Map<String, StateMachine<StateMachines.SignalExternalData>> externalSignals = new HashMap<String, StateMachine<StateMachines.SignalExternalData>>();
    private StateMachine<StateMachines.WorkflowData> workflow;
    private volatile StateMachine<StateMachines.DecisionTaskData> decision;
    private long lastNonFailedDecisionStartEventId;
    private final Map<String, CompletableFuture<QueryWorkflowResponse>> queries = new ConcurrentHashMap<String, CompletableFuture<QueryWorkflowResponse>>();
    private final Map<String, PollForDecisionTaskResponse> queryRequests = new ConcurrentHashMap<String, PollForDecisionTaskResponse>();
    private final Optional<String> continuedExecutionRunId;
    public StickyExecutionAttributes stickyExecutionAttributes;

    TestWorkflowMutableStateImpl(StartWorkflowExecutionRequest startRequest, Optional<RetryState> retryState, int backoffStartIntervalInSeconds, byte[] lastCompletionResult, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<String> continuedExecutionRunId, TestWorkflowService service, TestWorkflowStore store) {
        this.startRequest = startRequest;
        this.parent = parent;
        this.parentChildInitiatedEventId = parentChildInitiatedEventId;
        this.continuedExecutionRunId = continuedExecutionRunId;
        this.service = service;
        String runId = UUID.randomUUID().toString();
        this.executionId = new ExecutionId(startRequest.getDomain(), startRequest.getWorkflowId(), runId);
        this.store = store;
        this.selfAdvancingTimer = store.getTimer();
        this.clock = this.selfAdvancingTimer.getClock();
        StateMachines.WorkflowData data = new StateMachines.WorkflowData(retryState, backoffStartIntervalInSeconds, startRequest.getCronSchedule(), lastCompletionResult, runId, continuedExecutionRunId);
        this.workflow = StateMachines.newWorkflowStateMachine(data);
    }

    private void update(UpdateProcedure updater) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.update(false, updater, stackTraceElements[2].getMethodName());
    }

    private void completeDecisionUpdate(UpdateProcedure updater, StickyExecutionAttributes attributes) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.stickyExecutionAttributes = attributes;
        this.update(true, updater, stackTraceElements[2].getMethodName());
    }

    private void update(boolean completeDecisionUpdate, UpdateProcedure updater, String caller) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        String callerInfo = "Decision Update from " + caller;
        this.lock.lock();
        LockHandle lockHandle = this.selfAdvancingTimer.lockTimeSkipping(callerInfo);
        try {
            this.checkCompleted();
            boolean concurrentDecision = !completeDecisionUpdate && this.decision != null && this.decision.getState() == StateMachines.State.STARTED;
            RequestContext ctx = new RequestContext(this.clock, this, this.nextEventId);
            updater.apply(ctx);
            if (concurrentDecision && this.workflow.getState() != StateMachines.State.TIMED_OUT) {
                this.concurrentToDecision.add(ctx);
                ctx.fireCallbacks(0);
                this.store.applyTimersAndLocks(ctx);
            } else {
                this.nextEventId = ctx.commitChanges(this.store);
            }
        }
        catch (BadRequestError | EntityNotExistsError | InternalServiceError e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            lockHandle.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    @Override
    public Optional<WorkflowExecutionCloseStatus> getCloseStatus() {
        switch (this.workflow.getState()) {
            case NONE: 
            case INITIATED: 
            case STARTED: 
            case CANCELLATION_REQUESTED: {
                return Optional.empty();
            }
            case FAILED: {
                return Optional.of(WorkflowExecutionCloseStatus.FAILED);
            }
            case TIMED_OUT: {
                return Optional.of(WorkflowExecutionCloseStatus.TIMED_OUT);
            }
            case CANCELED: {
                return Optional.of(WorkflowExecutionCloseStatus.CANCELED);
            }
            case COMPLETED: {
                return Optional.of(WorkflowExecutionCloseStatus.COMPLETED);
            }
            case CONTINUED_AS_NEW: {
                return Optional.of(WorkflowExecutionCloseStatus.CONTINUED_AS_NEW);
            }
        }
        throw new IllegalStateException("unreachable");
    }

    @Override
    public StartWorkflowExecutionRequest getStartRequest() {
        return this.startRequest;
    }

    @Override
    public StickyExecutionAttributes getStickyExecutionAttributes() {
        return this.stickyExecutionAttributes;
    }

    @Override
    public Optional<TestWorkflowMutableState> getParent() {
        return this.parent;
    }

    @Override
    public void startDecisionTask(PollForDecisionTaskResponse task, PollForDecisionTaskRequest pollRequest) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        if (task.getQuery() == null) {
            this.update(ctx -> {
                long scheduledEventId = this.decision.getData().scheduledEventId;
                this.decision.action(StateMachines.Action.START, ctx, pollRequest, 0L);
                ctx.addTimer(this.startRequest.getTaskStartToCloseTimeoutSeconds(), () -> this.timeoutDecisionTask(scheduledEventId), "DecisionTask StartToCloseTimeout");
            });
        }
    }

    @Override
    public void completeDecisionTask(int historySize, RespondDecisionTaskCompletedRequest request) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        List<Decision> decisions = request.getDecisions();
        this.completeDecisionUpdate(ctx -> {
            boolean completed;
            if (ctx.getInitialEventId() != (long)(historySize + 1)) {
                throw new BadRequestError("Expired decision: expectedHistorySize=" + historySize + ", actualHistorySize=" + ctx.getInitialEventId());
            }
            long decisionTaskCompletedId = ctx.getNextEventId() - 1L;
            if (!this.concurrentToDecision.isEmpty() && this.hasCompleteDecision(request.getDecisions())) {
                RespondDecisionTaskFailedRequest failedRequest = new RespondDecisionTaskFailedRequest().setCause(DecisionTaskFailedCause.UNHANDLED_DECISION).setIdentity(request.getIdentity());
                this.decision.action(StateMachines.Action.FAIL, ctx, failedRequest, decisionTaskCompletedId);
                for (RequestContext deferredCtx : this.concurrentToDecision) {
                    ctx.add(deferredCtx);
                }
                this.concurrentToDecision.clear();
                this.stickyExecutionAttributes = null;
                this.scheduleDecision(ctx);
                return;
            }
            if (this.decision == null) {
                throw new EntityNotExistsError("No outstanding decision");
            }
            this.decision.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            for (Decision d : decisions) {
                this.processDecision(ctx, d, request.getIdentity(), decisionTaskCompletedId);
            }
            for (RequestContext deferredCtx : this.concurrentToDecision) {
                ctx.add(deferredCtx);
            }
            this.lastNonFailedDecisionStartEventId = this.decision.getData().startedEventId;
            this.decision = null;
            boolean bl = completed = this.workflow.getState() == StateMachines.State.COMPLETED || this.workflow.getState() == StateMachines.State.FAILED || this.workflow.getState() == StateMachines.State.CANCELED;
            if (!completed && (ctx.isNeedDecision() || !this.concurrentToDecision.isEmpty() || request.isForceCreateNewDecisionTask())) {
                this.scheduleDecision(ctx);
            }
            this.concurrentToDecision.clear();
            ctx.unlockTimer();
        }, request.getStickyAttributes());
    }

    private boolean hasCompleteDecision(List<Decision> decisions) {
        for (Decision d : decisions) {
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompleteDecision(d)) continue;
            return true;
        }
        return false;
    }

    private void processDecision(RequestContext ctx, Decision d, String identity, long decisionTaskCompletedId) throws BadRequestError, InternalServiceError {
        switch (d.getDecisionType()) {
            case CompleteWorkflowExecution: {
                this.processCompleteWorkflowExecution(ctx, d.getCompleteWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId, identity);
                break;
            }
            case FailWorkflowExecution: {
                this.processFailWorkflowExecution(ctx, d.getFailWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId, identity);
                break;
            }
            case CancelWorkflowExecution: {
                this.processCancelWorkflowExecution(ctx, d.getCancelWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case ContinueAsNewWorkflowExecution: {
                this.processContinueAsNewWorkflowExecution(ctx, d.getContinueAsNewWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId, identity);
                break;
            }
            case ScheduleActivityTask: {
                this.processScheduleActivityTask(ctx, d.getScheduleActivityTaskDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case RequestCancelActivityTask: {
                this.processRequestCancelActivityTask(ctx, d.getRequestCancelActivityTaskDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case StartTimer: {
                this.processStartTimer(ctx, d.getStartTimerDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case CancelTimer: {
                this.processCancelTimer(ctx, d.getCancelTimerDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case StartChildWorkflowExecution: {
                this.processStartChildWorkflow(ctx, d.getStartChildWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case SignalExternalWorkflowExecution: {
                this.processSignalExternalWorkflowExecution(ctx, d.getSignalExternalWorkflowExecutionDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case RecordMarker: {
                this.processRecordMarker(ctx, d.getRecordMarkerDecisionAttributes(), decisionTaskCompletedId);
                break;
            }
            case RequestCancelExternalWorkflowExecution: {
                this.processRequestCancelExternalWorkflowExecution(ctx, d.getRequestCancelExternalWorkflowExecutionDecisionAttributes());
                break;
            }
            case UpsertWorkflowSearchAttributes: {
                this.processUpsertWorkflowSearchAttributes(ctx, d.getUpsertWorkflowSearchAttributesDecisionAttributes(), decisionTaskCompletedId);
            }
        }
    }

    private void processRequestCancelExternalWorkflowExecution(RequestContext ctx, RequestCancelExternalWorkflowExecutionDecisionAttributes attr) {
        ForkJoinPool.commonPool().execute(() -> {
            RequestCancelWorkflowExecutionRequest request = new RequestCancelWorkflowExecutionRequest();
            WorkflowExecution workflowExecution = new WorkflowExecution();
            workflowExecution.setWorkflowId(attr.workflowId);
            request.setWorkflowExecution(workflowExecution);
            request.setDomain(ctx.getDomain());
            try {
                this.service.RequestCancelWorkflowExecution(request);
            }
            catch (Exception e) {
                log.error("Failure to request cancel external workflow", (Throwable)e);
            }
        });
    }

    private void processRecordMarker(RequestContext ctx, RecordMarkerDecisionAttributes attr, long decisionTaskCompletedId) throws BadRequestError {
        if (!attr.isSetMarkerName()) {
            throw new BadRequestError("marker name is required");
        }
        MarkerRecordedEventAttributes marker = new MarkerRecordedEventAttributes().setMarkerName(attr.getMarkerName()).setHeader(attr.getHeader()).setDetails(attr.getDetails()).setDecisionTaskCompletedEventId(decisionTaskCompletedId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.MarkerRecorded).setMarkerRecordedEventAttributes(marker);
        ctx.addEvent(event);
    }

    private void processCancelTimer(RequestContext ctx, CancelTimerDecisionAttributes d, long decisionTaskCompletedId) throws InternalServiceError, BadRequestError {
        String timerId = d.getTimerId();
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer == null) {
            CancelTimerFailedEventAttributes failedAttr = new CancelTimerFailedEventAttributes().setTimerId(timerId).setCause("TIMER_ID_UNKNOWN").setDecisionTaskCompletedEventId(decisionTaskCompletedId);
            HistoryEvent cancellationFailed = new HistoryEvent().setEventType(EventType.CancelTimerFailed).setCancelTimerFailedEventAttributes(failedAttr);
            ctx.addEvent(cancellationFailed);
            return;
        }
        timer.action(StateMachines.Action.CANCEL, ctx, d, decisionTaskCompletedId);
        this.timers.remove(timerId);
    }

    private void processRequestCancelActivityTask(RequestContext ctx, RequestCancelActivityTaskDecisionAttributes a, long decisionTaskCompletedId) throws InternalServiceError, BadRequestError {
        String activityId = a.getActivityId();
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(activityId);
        if (activity == null) {
            RequestCancelActivityTaskFailedEventAttributes failedAttr = new RequestCancelActivityTaskFailedEventAttributes().setActivityId(activityId).setCause("ACTIVITY_ID_UNKNOWN").setDecisionTaskCompletedEventId(decisionTaskCompletedId);
            HistoryEvent cancellationFailed = new HistoryEvent().setEventType(EventType.RequestCancelActivityTaskFailed).setRequestCancelActivityTaskFailedEventAttributes(failedAttr);
            ctx.addEvent(cancellationFailed);
            return;
        }
        StateMachines.State beforeState = activity.getState();
        activity.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, a, decisionTaskCompletedId);
        if (beforeState == StateMachines.State.INITIATED) {
            activity.action(StateMachines.Action.CANCEL, ctx, null, 0L);
            this.activities.remove(activityId);
            ctx.setNeedDecision(true);
        }
    }

    private void processScheduleActivityTask(RequestContext ctx, ScheduleActivityTaskDecisionAttributes a, long decisionTaskCompletedId) throws BadRequestError, InternalServiceError {
        this.validateScheduleActivityTask(a);
        String activityId = a.getActivityId();
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(activityId);
        if (activity != null) {
            throw new BadRequestError("Already open activity with " + activityId);
        }
        activity = StateMachines.newActivityStateMachine(this.store, this.startRequest);
        this.activities.put(activityId, activity);
        activity.action(StateMachines.Action.INITIATE, ctx, a, decisionTaskCompletedId);
        ActivityTaskScheduledEventAttributes scheduledEvent = activity.getData().scheduledEvent;
        ctx.addTimer(scheduledEvent.getScheduleToCloseTimeoutSeconds(), () -> this.timeoutActivity(activityId, TimeoutType.SCHEDULE_TO_CLOSE), "Activity ScheduleToCloseTimeout");
        ctx.addTimer(scheduledEvent.getScheduleToStartTimeoutSeconds(), () -> this.timeoutActivity(activityId, TimeoutType.SCHEDULE_TO_START), "Activity ScheduleToStartTimeout");
        ctx.lockTimer();
    }

    private void validateScheduleActivityTask(ScheduleActivityTaskDecisionAttributes a) throws BadRequestError {
        if (a == null) {
            throw new BadRequestError("ScheduleActivityTaskDecisionAttributes is not set on decision.");
        }
        if (a.getTaskList() == null || a.getTaskList().getName().isEmpty()) {
            throw new BadRequestError("TaskList is not set on decision.");
        }
        if (a.getActivityId() == null || a.getActivityId().isEmpty()) {
            throw new BadRequestError("ActivityId is not set on decision.");
        }
        if (a.getActivityType() == null || a.getActivityType().getName() == null || a.getActivityType().getName().isEmpty()) {
            throw new BadRequestError("ActivityType is not set on decision.");
        }
        if (a.getStartToCloseTimeoutSeconds() <= 0) {
            throw new BadRequestError("A valid StartToCloseTimeoutSeconds is not set on decision.");
        }
        if (a.getScheduleToStartTimeoutSeconds() <= 0) {
            throw new BadRequestError("A valid ScheduleToStartTimeoutSeconds is not set on decision.");
        }
        if (a.getScheduleToCloseTimeoutSeconds() <= 0) {
            throw new BadRequestError("A valid ScheduleToCloseTimeoutSeconds is not set on decision.");
        }
        if (a.getHeartbeatTimeoutSeconds() < 0) {
            throw new BadRequestError("Ac valid HeartbeatTimeoutSeconds is not set on decision.");
        }
    }

    private void processStartChildWorkflow(RequestContext ctx, StartChildWorkflowExecutionDecisionAttributes a, long decisionTaskCompletedId) throws BadRequestError, InternalServiceError {
        this.validateStartChildExecutionAttributes(a);
        StateMachine<StateMachines.ChildWorkflowData> child = StateMachines.newChildWorkflowStateMachine(this.service);
        this.childWorkflows.put(ctx.getNextEventId(), child);
        child.action(StateMachines.Action.INITIATE, ctx, a, decisionTaskCompletedId);
        ctx.lockTimer();
    }

    private void validateStartChildExecutionAttributes(StartChildWorkflowExecutionDecisionAttributes a) throws BadRequestError {
        RetryPolicy retryPolicy;
        if (a == null) {
            throw new BadRequestError("StartChildWorkflowExecutionDecisionAttributes is not set on decision.");
        }
        if (a.getWorkflowId().isEmpty()) {
            throw new BadRequestError("Required field WorkflowID is not set on decision.");
        }
        if (a.getWorkflowType() == null || a.getWorkflowType().getName().isEmpty()) {
            throw new BadRequestError("Required field WorkflowType is not set on decision.");
        }
        if (a.getTaskList() == null || a.getTaskList().getName().isEmpty()) {
            a.setTaskList(this.startRequest.getTaskList());
        }
        if (a.getExecutionStartToCloseTimeoutSeconds() <= 0) {
            a.setExecutionStartToCloseTimeoutSeconds(this.startRequest.getExecutionStartToCloseTimeoutSeconds());
        }
        if (a.getTaskStartToCloseTimeoutSeconds() <= 0) {
            a.setTaskStartToCloseTimeoutSeconds(this.startRequest.getTaskStartToCloseTimeoutSeconds());
        }
        if ((retryPolicy = a.getRetryPolicy()) != null) {
            RetryState.validateRetryPolicy(retryPolicy);
        }
    }

    private void processSignalExternalWorkflowExecution(RequestContext ctx, SignalExternalWorkflowExecutionDecisionAttributes a, long decisionTaskCompletedId) throws InternalServiceError, BadRequestError {
        String signalId = UUID.randomUUID().toString();
        StateMachine<StateMachines.SignalExternalData> signalStateMachine = StateMachines.newSignalExternalStateMachine();
        this.externalSignals.put(signalId, signalStateMachine);
        signalStateMachine.action(StateMachines.Action.INITIATE, ctx, a, decisionTaskCompletedId);
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.service.signalExternalWorkflowExecution(signalId, a, this);
            }
            catch (Exception e) {
                log.error("Failure signalling an external workflow execution", (Throwable)e);
            }
        });
        ctx.lockTimer();
    }

    @Override
    public void completeSignalExternalWorkflowExecution(String signalId, String runId) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.COMPLETE, ctx, runId, 0L);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void failSignalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionFailedCause cause) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.FAIL, ctx, cause, 0L);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    private StateMachine<StateMachines.SignalExternalData> getSignal(String signalId) throws EntityNotExistsError {
        StateMachine<StateMachines.SignalExternalData> signal = this.externalSignals.get(signalId);
        if (signal == null) {
            throw new EntityNotExistsError("unknown signalId: " + signalId);
        }
        return signal;
    }

    @Override
    public void failDecisionTask(RespondDecisionTaskFailedRequest request) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.completeDecisionUpdate(ctx -> {
            this.decision.action(StateMachines.Action.FAIL, ctx, request, 0L);
            this.scheduleDecision(ctx);
        }, null);
    }

    private void timeoutDecisionTask(long scheduledEventId) {
        try {
            this.completeDecisionUpdate(ctx -> {
                if (this.decision == null || this.decision.getData().scheduledEventId != scheduledEventId || this.decision.getState() == StateMachines.State.COMPLETED) {
                    return;
                }
                this.decision.action(StateMachines.Action.TIME_OUT, ctx, TimeoutType.START_TO_CLOSE, 0L);
                this.scheduleDecision(ctx);
            }, null);
        }
        catch (EntityNotExistsError entityNotExistsError) {
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a decision scheduledEventId=" + scheduledEventId, (Throwable)e);
        }
    }

    @Override
    public void childWorkflowStarted(ChildWorkflowExecutionStartedEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.START, ctx, a, 0L);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void childWorkflowFailed(String activityId, ChildWorkflowExecutionFailedEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void childWorkflowTimedOut(String activityId, ChildWorkflowExecutionTimedOutEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.TIME_OUT, ctx, a.getTimeoutType(), 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void failStartChildWorkflow(String childId, StartChildWorkflowExecutionFailedEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void childWorkflowCompleted(String activityId, ChildWorkflowExecutionCompletedEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.COMPLETE, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void childWorkflowCanceled(String activityId, ChildWorkflowExecutionCanceledEventAttributes a) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.CANCEL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    private void processStartTimer(RequestContext ctx, StartTimerDecisionAttributes a, long decisionTaskCompletedId) throws BadRequestError, InternalServiceError {
        String timerId = a.getTimerId();
        if (timerId == null) {
            throw new BadRequestError("A valid TimerId is not set on StartTimerDecision");
        }
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer != null) {
            throw new BadRequestError("Already open timer with " + timerId);
        }
        timer = StateMachines.newTimerStateMachine();
        this.timers.put(timerId, timer);
        timer.action(StateMachines.Action.START, ctx, a, decisionTaskCompletedId);
        ctx.addTimer(a.getStartToFireTimeoutSeconds(), () -> this.fireTimer(timerId), "fire timer");
    }

    private void fireTimer(String timerId) {
        StateMachine<StateMachines.TimerData> timer;
        this.lock.lock();
        try {
            timer = this.timers.get(timerId);
            if (timer == null || this.workflow.getState() != StateMachines.State.STARTED) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                timer.action(StateMachines.Action.COMPLETE, ctx, null, 0L);
                this.timers.remove(timerId);
                this.scheduleDecision(ctx);
            });
        }
        catch (BadRequestError | EntityNotExistsError | InternalServiceError e) {
            log.error("Failure firing a timer", (Throwable)e);
        }
    }

    private void processFailWorkflowExecution(RequestContext ctx, FailWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedId, String identity) throws InternalServiceError, BadRequestError {
        RetryState rs;
        int backoffIntervalSeconds;
        StateMachines.WorkflowData data = this.workflow.getData();
        if (data.retryState.isPresent() && (backoffIntervalSeconds = (rs = data.retryState.get()).getBackoffIntervalInSeconds(d.getReason(), this.store.currentTimeMillis())) > 0) {
            ContinueAsNewWorkflowExecutionDecisionAttributes continueAsNewAttr = new ContinueAsNewWorkflowExecutionDecisionAttributes().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setExecutionStartToCloseTimeoutSeconds(this.startRequest.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(this.startRequest.getTaskStartToCloseTimeoutSeconds()).setTaskList(this.startRequest.getTaskList()).setBackoffStartIntervalInSeconds(backoffIntervalSeconds).setRetryPolicy(this.startRequest.getRetryPolicy());
            this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, continueAsNewAttr, decisionTaskCompletedId);
            HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
            WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
            Optional<RetryState> continuedRetryState = Optional.of(rs.getNextAttempt());
            String runId = this.service.continueAsNew(this.startRequest, continuedAsNewEventAttributes, continuedRetryState, identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
            continuedAsNewEventAttributes.setNewExecutionRunId(runId);
            return;
        }
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, decisionTaskCompletedId, identity, data, data.lastCompletionResult);
            return;
        }
        this.workflow.action(StateMachines.Action.FAIL, ctx, d, decisionTaskCompletedId);
        if (this.parent.isPresent()) {
            ctx.lockTimer();
            ChildWorkflowExecutionFailedEventAttributes a = new ChildWorkflowExecutionFailedEventAttributes().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setDetails(d.getDetails()).setReason(d.getReason()).setWorkflowType(this.startRequest.getWorkflowType()).setDomain(ctx.getDomain()).setWorkflowExecution(ctx.getExecution());
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowFailed(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (EntityNotExistsError entityNotExistsError) {
                }
                catch (BadRequestError | InternalServiceError e) {
                    log.error("Failure reporting child completion", (Throwable)e);
                }
            });
        }
    }

    private void processCompleteWorkflowExecution(RequestContext ctx, CompleteWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedId, String identity) throws InternalServiceError, BadRequestError {
        StateMachines.WorkflowData data = this.workflow.getData();
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, decisionTaskCompletedId, identity, data, d.getResult());
            return;
        }
        this.workflow.action(StateMachines.Action.COMPLETE, ctx, d, decisionTaskCompletedId);
        if (this.parent.isPresent()) {
            ctx.lockTimer();
            ChildWorkflowExecutionCompletedEventAttributes a = new ChildWorkflowExecutionCompletedEventAttributes().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setResult(d.getResult()).setDomain(ctx.getDomain()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType());
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCompleted(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (EntityNotExistsError entityNotExistsError) {
                }
                catch (BadRequestError | InternalServiceError e) {
                    log.error("Failure reporting child completion", (Throwable)e);
                }
            });
        }
    }

    private void startNewCronRun(RequestContext ctx, long decisionTaskCompletedId, String identity, StateMachines.WorkflowData data, byte[] lastCompletionResult) throws InternalServiceError, BadRequestError {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        CronParser parser = new CronParser(cronDefinition);
        Cron cron = parser.parse(data.cronSchedule);
        Instant i = Instant.ofEpochMilli(this.store.currentTimeMillis());
        ZonedDateTime now = ZonedDateTime.ofInstant(i, ZoneOffset.UTC);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        Optional backoff = executionTime.timeToNextExecution(now);
        int backoffIntervalSeconds = (int)((Duration)backoff.get()).getSeconds();
        if (backoffIntervalSeconds == 0) {
            backoff = executionTime.timeToNextExecution(now.plusSeconds(1L));
            backoffIntervalSeconds = (int)((Duration)backoff.get()).getSeconds() + 1;
        }
        ContinueAsNewWorkflowExecutionDecisionAttributes continueAsNewAttr = new ContinueAsNewWorkflowExecutionDecisionAttributes().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setExecutionStartToCloseTimeoutSeconds(this.startRequest.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(this.startRequest.getTaskStartToCloseTimeoutSeconds()).setTaskList(this.startRequest.getTaskList()).setBackoffStartIntervalInSeconds(backoffIntervalSeconds).setRetryPolicy(this.startRequest.getRetryPolicy()).setLastCompletionResult(lastCompletionResult);
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, continueAsNewAttr, decisionTaskCompletedId);
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
        String runId = this.service.continueAsNew(this.startRequest, continuedAsNewEventAttributes, Optional.empty(), identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
        continuedAsNewEventAttributes.setNewExecutionRunId(runId);
    }

    private void processCancelWorkflowExecution(RequestContext ctx, CancelWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedId) throws InternalServiceError, BadRequestError {
        this.workflow.action(StateMachines.Action.CANCEL, ctx, d, decisionTaskCompletedId);
        if (this.parent.isPresent()) {
            ctx.lockTimer();
            ChildWorkflowExecutionCanceledEventAttributes a = new ChildWorkflowExecutionCanceledEventAttributes().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setDetails(d.getDetails()).setDomain(ctx.getDomain()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType());
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCanceled(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (EntityNotExistsError entityNotExistsError) {
                }
                catch (BadRequestError | InternalServiceError e) {
                    log.error("Failure reporting child completion", (Throwable)e);
                }
            });
        }
    }

    private void processContinueAsNewWorkflowExecution(RequestContext ctx, ContinueAsNewWorkflowExecutionDecisionAttributes d, long decisionTaskCompletedId, String identity) throws InternalServiceError, BadRequestError {
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, d, decisionTaskCompletedId);
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        String runId = this.service.continueAsNew(this.startRequest, event.getWorkflowExecutionContinuedAsNewEventAttributes(), this.workflow.getData().retryState, identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
        event.getWorkflowExecutionContinuedAsNewEventAttributes().setNewExecutionRunId(runId);
    }

    private void processUpsertWorkflowSearchAttributes(RequestContext ctx, UpsertWorkflowSearchAttributesDecisionAttributes attr, long decisionTaskCompletedId) throws BadRequestError, InternalServiceError {
        UpsertWorkflowSearchAttributesEventAttributes upsertEventAttr = new UpsertWorkflowSearchAttributesEventAttributes().setSearchAttributes(attr.getSearchAttributes()).setDecisionTaskCompletedEventId(decisionTaskCompletedId);
        HistoryEvent event = new HistoryEvent().setEventType(EventType.UpsertWorkflowSearchAttributes).setUpsertWorkflowSearchAttributesEventAttributes(upsertEventAttr);
        ctx.addEvent(event);
    }

    @Override
    public void startWorkflow(boolean continuedAsNew, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal) throws InternalServiceError, BadRequestError {
        try {
            this.update(ctx -> {
                int backoffStartIntervalInSeconds;
                this.workflow.action(StateMachines.Action.START, ctx, this.startRequest, 0L);
                if (signalWithStartSignal.isPresent()) {
                    this.addExecutionSignaledEvent(ctx, (SignalWorkflowExecutionRequest)signalWithStartSignal.get());
                }
                if ((backoffStartIntervalInSeconds = this.workflow.getData().backoffStartIntervalInSeconds) > 0) {
                    ctx.addTimer(backoffStartIntervalInSeconds, () -> {
                        try {
                            this.update(ctx1 -> this.scheduleDecision(ctx1));
                        }
                        catch (EntityNotExistsError entityNotExistsError) {
                        }
                        catch (Exception e) {
                            log.error("Failure trying to add task for an delayed workflow retry", (Throwable)e);
                        }
                    }, "delayedFirstDecision");
                } else {
                    this.scheduleDecision(ctx);
                }
                int executionTimeoutTimerDelay = this.startRequest.getExecutionStartToCloseTimeoutSeconds();
                if (backoffStartIntervalInSeconds > 0) {
                    executionTimeoutTimerDelay += backoffStartIntervalInSeconds;
                }
                ctx.addTimer(executionTimeoutTimerDelay, this::timeoutWorkflow, "workflow execution timeout");
            });
        }
        catch (EntityNotExistsError entityNotExistsError) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)((Object)entityNotExistsError)));
        }
        if (!continuedAsNew && this.parent.isPresent()) {
            ChildWorkflowExecutionStartedEventAttributes a = new ChildWorkflowExecutionStartedEventAttributes().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setWorkflowExecution(this.getExecutionId().getExecution()).setDomain(this.getExecutionId().getDomain()).setWorkflowType(this.startRequest.getWorkflowType());
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowStarted(a);
                }
                catch (EntityNotExistsError entityNotExistsError) {
                }
                catch (BadRequestError | InternalServiceError e) {
                    log.error("Failure reporting child completion", (Throwable)e);
                }
            });
        }
    }

    private void scheduleDecision(RequestContext ctx) throws InternalServiceError, BadRequestError {
        if (this.decision != null) {
            if (this.decision.getState() == StateMachines.State.INITIATED) {
                return;
            }
            if (this.decision.getState() == StateMachines.State.STARTED) {
                ctx.setNeedDecision(true);
                return;
            }
            if (this.decision.getState() == StateMachines.State.FAILED || this.decision.getState() == StateMachines.State.COMPLETED || this.decision.getState() == StateMachines.State.TIMED_OUT) {
                this.decision.action(StateMachines.Action.INITIATE, ctx, this.startRequest, 0L);
                ctx.lockTimer();
                return;
            }
            throw new InternalServiceError("unexpected decision state: " + (Object)((Object)this.decision.getState()));
        }
        this.decision = StateMachines.newDecisionStateMachine(this.lastNonFailedDecisionStartEventId, this.store);
        this.decision.action(StateMachines.Action.INITIATE, ctx, this.startRequest, 0L);
        ctx.lockTimer();
    }

    @Override
    public void startActivityTask(PollForActivityTaskResponse task, PollForActivityTaskRequest pollRequest) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            String activityId = task.getActivityId();
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.START, ctx, pollRequest, 0L);
            StateMachines.ActivityTaskData data = activity.getData();
            int startToCloseTimeout = data.scheduledEvent.getStartToCloseTimeoutSeconds();
            int heartbeatTimeout = data.scheduledEvent.getHeartbeatTimeoutSeconds();
            if (startToCloseTimeout > 0) {
                ctx.addTimer(startToCloseTimeout, () -> this.timeoutActivity(activityId, TimeoutType.START_TO_CLOSE), "Activity StartToCloseTimeout");
            }
            this.updateHeartbeatTimer(ctx, activityId, activity, startToCloseTimeout, heartbeatTimeout);
        });
    }

    private void checkCompleted() throws EntityNotExistsError {
        StateMachines.State workflowState = this.workflow.getState();
        if (this.isTerminalState(workflowState)) {
            throw new EntityNotExistsError("Workflow is already completed: " + (Object)((Object)workflowState));
        }
    }

    private boolean isTerminalState(StateMachines.State workflowState) {
        return workflowState == StateMachines.State.COMPLETED || workflowState == StateMachines.State.TIMED_OUT || workflowState == StateMachines.State.FAILED || workflowState == StateMachines.State.CANCELED || workflowState == StateMachines.State.CONTINUED_AS_NEW;
    }

    private void updateHeartbeatTimer(RequestContext ctx, String activityId, StateMachine<StateMachines.ActivityTaskData> activity, int startToCloseTimeout, int heartbeatTimeout) {
        if (heartbeatTimeout > 0 && heartbeatTimeout < startToCloseTimeout) {
            activity.getData().lastHeartbeatTime = this.clock.getAsLong();
            ctx.addTimer(heartbeatTimeout, () -> this.timeoutActivity(activityId, TimeoutType.HEARTBEAT), "Activity Heartbeat Timeout");
        }
    }

    @Override
    public void completeActivityTask(String activityId, RespondActivityTaskCompletedRequest request) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.activities.remove(activityId);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void completeActivityTaskById(String activityId, RespondActivityTaskCompletedByIDRequest request) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.activities.remove(activityId);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void failActivityTask(String activityId, RespondActivityTaskFailedRequest request) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.activities.remove(activityId);
                this.scheduleDecision(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer();
        });
    }

    private void addActivityRetryTimer(RequestContext ctx, StateMachine<StateMachines.ActivityTaskData> activity) {
        StateMachines.ActivityTaskData data = activity.getData();
        int attempt = data.retryState.getAttempt();
        ctx.addTimer(data.nextBackoffIntervalSeconds, () -> {
            if (activity.getState() != StateMachines.State.INITIATED && data.retryState.getAttempt() != attempt) {
                return;
            }
            this.selfAdvancingTimer.lockTimeSkipping("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
            boolean unlockTimer = false;
            try {
                this.update(ctx1 -> ctx1.addActivityTask(data.activityTask));
            }
            catch (EntityNotExistsError e) {
                unlockTimer = true;
            }
            catch (Exception e) {
                unlockTimer = true;
                log.error("Failure trying to add task for an activity retry", (Throwable)e);
            }
            finally {
                if (unlockTimer) {
                    this.selfAdvancingTimer.unlockTimeSkipping("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
                }
            }
        }, "Activity Retry");
    }

    @Override
    public void failActivityTaskById(String activityId, RespondActivityTaskFailedByIDRequest request) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.activities.remove(activityId);
                this.scheduleDecision(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer();
        });
    }

    @Override
    public void cancelActivityTask(String activityId, RespondActivityTaskCanceledRequest request) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.activities.remove(activityId);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public void cancelActivityTaskById(String activityId, RespondActivityTaskCanceledByIDRequest request) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.activities.remove(activityId);
            this.scheduleDecision(ctx);
            ctx.unlockTimer();
        });
    }

    @Override
    public RecordActivityTaskHeartbeatResponse heartbeatActivityTask(String activityId, byte[] details) throws InternalServiceError, EntityNotExistsError {
        RecordActivityTaskHeartbeatResponse result = new RecordActivityTaskHeartbeatResponse();
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
                activity.action(StateMachines.Action.UPDATE, ctx, details, 0L);
                if (activity.getState() == StateMachines.State.CANCELLATION_REQUESTED) {
                    result.setCancelRequested(true);
                }
                StateMachines.ActivityTaskData data = activity.getData();
                data.lastHeartbeatTime = this.clock.getAsLong();
                int startToCloseTimeout = data.scheduledEvent.getStartToCloseTimeoutSeconds();
                int heartbeatTimeout = data.scheduledEvent.getHeartbeatTimeoutSeconds();
                this.updateHeartbeatTimer(ctx, activityId, activity, startToCloseTimeout, heartbeatTimeout);
            });
        }
        catch (EntityNotExistsError | InternalServiceError e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutActivity(String activityId, TimeoutType timeoutType) {
        boolean unlockTimer = true;
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(activityId);
                if (timeoutType == TimeoutType.SCHEDULE_TO_START && activity.getState() != StateMachines.State.INITIATED) {
                    throw new EntityNotExistsError("Not in INITIATED");
                }
                if (timeoutType == TimeoutType.HEARTBEAT) {
                    long heartbeatTimeout = TimeUnit.SECONDS.toMillis(activity.getData().scheduledEvent.getHeartbeatTimeoutSeconds());
                    if (this.clock.getAsLong() - activity.getData().lastHeartbeatTime < heartbeatTimeout) {
                        throw new EntityNotExistsError("Not heartbeat timeout");
                    }
                }
                activity.action(StateMachines.Action.TIME_OUT, ctx, timeoutType, 0L);
                if (this.isTerminalState(activity.getState())) {
                    this.activities.remove(activityId);
                    this.scheduleDecision(ctx);
                } else {
                    this.addActivityRetryTimer(ctx, activity);
                }
            });
        }
        catch (EntityNotExistsError e) {
            unlockTimer = false;
        }
        catch (Exception e) {
            log.error("Failure trying to timeout an activity", (Throwable)e);
        }
        finally {
            if (unlockTimer) {
                this.selfAdvancingTimer.unlockTimeSkipping("timeoutActivity " + activityId);
            }
        }
    }

    private void timeoutWorkflow() {
        this.lock.lock();
        try {
            if (this.isTerminalState(this.workflow.getState())) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                if (this.isTerminalState(this.workflow.getState())) {
                    return;
                }
                this.workflow.action(StateMachines.Action.TIME_OUT, ctx, TimeoutType.START_TO_CLOSE, 0L);
                if (this.parent != null) {
                    ctx.lockTimer();
                }
                ForkJoinPool.commonPool().execute(() -> this.reportWorkflowTimeoutToParent(ctx));
            });
        }
        catch (BadRequestError | EntityNotExistsError | InternalServiceError e) {
            log.error("Failure trying to timeout a workflow", (Throwable)e);
        }
    }

    private void reportWorkflowTimeoutToParent(RequestContext ctx) {
        if (!this.parent.isPresent()) {
            return;
        }
        try {
            ChildWorkflowExecutionTimedOutEventAttributes a = new ChildWorkflowExecutionTimedOutEventAttributes().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setTimeoutType(TimeoutType.START_TO_CLOSE).setWorkflowType(this.startRequest.getWorkflowType()).setDomain(ctx.getDomain()).setWorkflowExecution(ctx.getExecution());
            this.parent.get().childWorkflowTimedOut(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
        }
        catch (EntityNotExistsError a) {
        }
        catch (BadRequestError | InternalServiceError e) {
            log.error("Failure reporting child timing out", (Throwable)e);
        }
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest signalRequest) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            this.addExecutionSignaledEvent(ctx, signalRequest);
            this.scheduleDecision(ctx);
        });
    }

    @Override
    public void signalFromWorkflow(SignalExternalWorkflowExecutionDecisionAttributes a) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            this.addExecutionSignaledByExternalEvent(ctx, a);
            this.scheduleDecision(ctx);
        });
    }

    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest) throws EntityNotExistsError, InternalServiceError, BadRequestError {
        this.update(ctx -> {
            this.workflow.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, cancelRequest, 0L);
            this.scheduleDecision(ctx);
        });
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryRequest) throws TException {
        QueryId queryId = new QueryId(this.executionId);
        Optional<WorkflowExecutionCloseStatus> optCloseStatus = this.getCloseStatus();
        if (optCloseStatus.isPresent() && queryRequest.getQueryRejectCondition() != null) {
            boolean rejectNotCompletedCleanly;
            WorkflowExecutionCloseStatus closeStatus = optCloseStatus.get();
            boolean rejectNotOpen = queryRequest.getQueryRejectCondition() == QueryRejectCondition.NOT_OPEN;
            boolean bl = rejectNotCompletedCleanly = queryRequest.getQueryRejectCondition() == QueryRejectCondition.NOT_COMPLETED_CLEANLY && closeStatus != WorkflowExecutionCloseStatus.COMPLETED;
            if (rejectNotOpen || rejectNotCompletedCleanly) {
                return new QueryWorkflowResponse().setQueryRejected(new QueryRejected().setCloseStatus(closeStatus));
            }
        }
        PollForDecisionTaskResponse task = new PollForDecisionTaskResponse().setTaskToken(queryId.toBytes()).setWorkflowExecution(this.executionId.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).setQuery(queryRequest.getQuery()).setWorkflowExecutionTaskList(this.startRequest.getTaskList());
        TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(queryRequest.getDomain(), this.stickyExecutionAttributes == null ? this.startRequest.getTaskList().getName() : this.stickyExecutionAttributes.getWorkerTaskList().getName());
        CompletableFuture result = new CompletableFuture();
        this.queryRequests.put(queryId.getQueryId(), task);
        this.queries.put(queryId.getQueryId(), result);
        this.store.sendQueryTask(this.executionId, taskListId, task);
        try {
            return (QueryWorkflowResponse)result.get();
        }
        catch (InterruptedException e) {
            return new QueryWorkflowResponse();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TException) {
                throw (TException)cause;
            }
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)cause));
        }
    }

    @Override
    public void completeQuery(QueryId queryId, RespondQueryTaskCompletedRequest completeRequest) throws EntityNotExistsError {
        CompletableFuture<QueryWorkflowResponse> result = this.queries.get(queryId.getQueryId());
        if (result == null) {
            throw new EntityNotExistsError("Unknown query id: " + queryId.getQueryId());
        }
        if (completeRequest.getCompletedType() == QueryTaskCompletedType.COMPLETED) {
            QueryWorkflowResponse response = new QueryWorkflowResponse().setQueryResult(completeRequest.getQueryResult());
            result.complete(response);
        } else if (this.stickyExecutionAttributes != null) {
            this.stickyExecutionAttributes = null;
            PollForDecisionTaskResponse task = this.queryRequests.remove(queryId.getQueryId());
            TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(this.startRequest.getDomain(), this.startRequest.getTaskList().getName());
            this.store.sendQueryTask(this.executionId, taskListId, task);
        } else {
            QueryFailedError error = new QueryFailedError().setMessage(completeRequest.getErrorMessage());
            result.completeExceptionally((Throwable)((Object)error));
        }
    }

    private void addExecutionSignaledEvent(RequestContext ctx, SignalWorkflowExecutionRequest signalRequest) {
        WorkflowExecutionSignaledEventAttributes a = new WorkflowExecutionSignaledEventAttributes().setInput(this.startRequest.getInput()).setIdentity(signalRequest.getIdentity()).setInput(signalRequest.getInput()).setSignalName(signalRequest.getSignalName());
        HistoryEvent executionSignaled = new HistoryEvent().setEventType(EventType.WorkflowExecutionSignaled).setWorkflowExecutionSignaledEventAttributes(a);
        ctx.addEvent(executionSignaled);
    }

    private void addExecutionSignaledByExternalEvent(RequestContext ctx, SignalExternalWorkflowExecutionDecisionAttributes d) {
        WorkflowExecutionSignaledEventAttributes a = new WorkflowExecutionSignaledEventAttributes().setInput(this.startRequest.getInput()).setInput(d.getInput()).setSignalName(d.getSignalName());
        HistoryEvent executionSignaled = new HistoryEvent().setEventType(EventType.WorkflowExecutionSignaled).setWorkflowExecutionSignaledEventAttributes(a);
        ctx.addEvent(executionSignaled);
    }

    private StateMachine<StateMachines.ActivityTaskData> getActivity(String activityId) throws EntityNotExistsError {
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(activityId);
        if (activity == null) {
            throw new EntityNotExistsError("unknown activityId: " + activityId);
        }
        return activity;
    }

    private StateMachine<StateMachines.ChildWorkflowData> getChildWorkflow(long initiatedEventId) throws InternalServiceError {
        StateMachine<StateMachines.ChildWorkflowData> child = this.childWorkflows.get(initiatedEventId);
        if (child == null) {
            throw new InternalServiceError("unknown initiatedEventId: " + initiatedEventId);
        }
        return child;
    }

    static class QueryId {
        private final ExecutionId executionId;
        private final String queryId;

        QueryId(ExecutionId executionId) {
            this.executionId = Objects.requireNonNull(executionId);
            this.queryId = UUID.randomUUID().toString();
        }

        private QueryId(ExecutionId executionId, String queryId) {
            this.executionId = Objects.requireNonNull(executionId);
            this.queryId = queryId;
        }

        public ExecutionId getExecutionId() {
            return this.executionId;
        }

        String getQueryId() {
            return this.queryId;
        }

        byte[] toBytes() throws InternalServiceError {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            this.addBytes(out);
            return bout.toByteArray();
        }

        void addBytes(DataOutputStream out) throws InternalServiceError {
            try {
                this.executionId.addBytes(out);
                out.writeUTF(this.queryId);
            }
            catch (IOException e) {
                throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        static QueryId fromBytes(byte[] serialized) throws InternalServiceError {
            ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
            DataInputStream in = new DataInputStream(bin);
            try {
                ExecutionId executionId = ExecutionId.readFromBytes(in);
                String queryId = in.readUTF();
                return new QueryId(executionId, queryId);
            }
            catch (IOException e) {
                throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
    }

    @FunctionalInterface
    private static interface UpdateProcedure {
        public void apply(RequestContext var1) throws InternalServiceError, BadRequestError, EntityNotExistsError;
    }
}

