/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.decider.cache;

import com.digiwin.decider.cache.LocalCacheRemovalListener;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache<K, V>
implements LoadingCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LocalCache.class);
    private long maxCacheSize;
    private int cacheExpireTime;
    private LocalCacheRemovalListener<? super K, ? super V> removalListener;
    private ConcurrentHashMap<K, V> cacheMap = new ConcurrentHashMap();
    private ConcurrentHashMap<K, Date> cacheTimeMap = new ConcurrentHashMap();
    private ReentrantLock cacheLock = new ReentrantLock();

    public LocalCache(long maxCacheSize, int cacheExpireTime, LocalCacheRemovalListener removalListener) {
        this.maxCacheSize = maxCacheSize;
        this.cacheExpireTime = cacheExpireTime;
        this.removalListener = removalListener;
    }

    public V get(K key) throws ExecutionException {
        log.debug("local cache get " + key);
        return this.cacheMap.get(key);
    }

    public V getUnchecked(K key) {
        try {
            log.debug("local cache getUnchecked " + key);
            return this.get(key);
        }
        catch (ExecutionException exception) {
            throw new UncheckedExecutionException(exception.getCause());
        }
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> iterable) throws ExecutionException {
        log.debug("local cache getAll ");
        return ImmutableMap.copyOf(this.cacheMap);
    }

    public V apply(K key) {
        log.debug("local cache apply " + key);
        return this.getUnchecked(key);
    }

    public void refresh(K key) {
    }

    public @Nullable V getIfPresent(Object o) {
        log.debug("local cache getIfPresent " + o);
        return this.getUnchecked(o);
    }

    public V get(K key, Callable<? extends V> callable) throws ExecutionException {
        log.debug("local cache get((K key, Callable<? extends V> callable) " + key);
        return this.getUnchecked(key);
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> iterable) {
        log.debug("local cache getAllPresent");
        return ImmutableMap.copyOf(this.cacheMap);
    }

    public void put(K k, V v) {
        log.debug("local cache put " + k);
        this.cacheLock.lock();
        try {
            this.cleanCacheWithExpireTime();
            this.cacheMap.put(k, v);
            this.cacheTimeMap.put(k, new Date());
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        log.debug("local cache putAll");
        this.cacheLock.lock();
        try {
            this.cleanCacheWithExpireTime();
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void invalidate(Object o) {
        log.debug("local cache invalidate " + o);
        this.removalListener.onRemoval(o, this.cacheMap.get(o));
        this.cacheMap.remove(o);
        this.cacheTimeMap.remove(o);
    }

    public void invalidateAll(Iterable<?> iterable) {
        log.debug("local cache invalidateAll(Iterable<?> iterable)");
        for (Map.Entry e : iterable) {
            this.invalidate(e.getKey());
        }
    }

    public void invalidateAll() {
        log.debug("local cache invalidateAll");
        for (Map.Entry<K, V> e : this.cacheMap.entrySet()) {
            this.removalListener.onRemoval(e.getKey(), e.getValue());
        }
        this.cacheMap.clear();
        this.cacheTimeMap.clear();
    }

    public long size() {
        log.debug("local cache size(), size=" + ((ConcurrentHashMap.CollectionView)((Object)this.cacheMap.keySet())).size());
        return ((ConcurrentHashMap.CollectionView)((Object)this.cacheMap.keySet())).size();
    }

    public CacheStats stats() {
        log.debug("local cache stats");
        return null;
    }

    public ConcurrentMap<K, V> asMap() {
        log.debug("local cache asMap");
        return this.cacheMap;
    }

    public void cleanUp() {
        log.debug("local cache cleanUp");
        for (Map.Entry<K, V> e : this.cacheMap.entrySet()) {
            this.removalListener.onRemoval(e.getKey(), e.getValue());
        }
        this.cacheMap.clear();
    }

    private void cleanCacheWithExpireTime() {
        long cacheMapSize = this.size();
        if (cacheMapSize > this.maxCacheSize) {
            HashSet<K> expireTimeKeys = new HashSet<K>();
            Date expireTime = this.generateDateWithExpireTime();
            for (Map.Entry<K, Date> entry : this.cacheTimeMap.entrySet()) {
                Date cacheTime = entry.getValue();
                if (!this.dateAfterExpireTime(expireTime, cacheTime)) continue;
                expireTimeKeys.add(entry.getKey());
            }
            for (Map.Entry<K, Date> expireTimeKey : expireTimeKeys) {
                this.invalidate(expireTimeKey);
                this.cacheTimeMap.remove(expireTimeKey);
            }
        }
    }

    private Date generateDateWithExpireTime() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(13, -this.cacheExpireTime);
        return calendar.getTime();
    }

    private boolean dateAfterExpireTime(Date expireTime, Date cacheTime) {
        return expireTime.after(cacheTime);
    }
}

