/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.activity;

import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.common.OptionsUtils;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public final class ActivityOptions {
    private final Duration heartbeatTimeout;
    private final Duration scheduleToCloseTimeout;
    private final Duration scheduleToStartTimeout;
    private final Duration startToCloseTimeout;
    private final String taskList;
    private final RetryOptions retryOptions;
    private final List<ContextPropagator> contextPropagators;

    public static ActivityOptions merge(ActivityMethod a, MethodRetry r, ActivityOptions o) {
        if (a == null) {
            if (r == null) {
                return new Builder(o).validateAndBuildWithDefaults();
            }
            RetryOptions mergedR = RetryOptions.merge(r, o.getRetryOptions());
            return new Builder().setRetryOptions(mergedR).validateAndBuildWithDefaults();
        }
        if (o == null) {
            o = new Builder().build();
        }
        return new Builder().setScheduleToCloseTimeout(ActivityOptions.mergeDuration(a.scheduleToCloseTimeoutSeconds(), o.getScheduleToCloseTimeout())).setScheduleToStartTimeout(ActivityOptions.mergeDuration(a.scheduleToStartTimeoutSeconds(), o.getScheduleToStartTimeout())).setStartToCloseTimeout(ActivityOptions.mergeDuration(a.startToCloseTimeoutSeconds(), o.getStartToCloseTimeout())).setHeartbeatTimeout(ActivityOptions.mergeDuration(a.heartbeatTimeoutSeconds(), o.getHeartbeatTimeout())).setTaskList((String)(o.getTaskList() != null ? o.getTaskList() : (a.taskList().isEmpty() ? null : a.taskList()))).setRetryOptions(RetryOptions.merge(r, o.getRetryOptions())).setContextPropagators(o.getContextPropagators()).validateAndBuildWithDefaults();
    }

    private ActivityOptions(Duration heartbeatTimeout, Duration scheduleToCloseTimeout, Duration scheduleToStartTimeout, Duration startToCloseTimeout, String taskList, RetryOptions retryOptions, List<ContextPropagator> contextPropagators) {
        this.heartbeatTimeout = heartbeatTimeout;
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        if (scheduleToCloseTimeout != null) {
            this.scheduleToStartTimeout = scheduleToStartTimeout == null ? scheduleToCloseTimeout : scheduleToStartTimeout;
            this.startToCloseTimeout = startToCloseTimeout == null ? scheduleToCloseTimeout : startToCloseTimeout;
        } else {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            this.startToCloseTimeout = startToCloseTimeout;
        }
        this.taskList = taskList;
        this.retryOptions = retryOptions;
        this.contextPropagators = contextPropagators;
    }

    public Duration getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public Duration getScheduleToStartTimeout() {
        return this.scheduleToStartTimeout;
    }

    public Duration getStartToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public String toString() {
        return "ActivityOptions{heartbeatTimeout=" + this.heartbeatTimeout + ", scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", scheduleToStartTimeout=" + this.scheduleToStartTimeout + ", startToCloseTimeout=" + this.startToCloseTimeout + ", taskList='" + this.taskList + '\'' + ", retryOptions=" + this.retryOptions + ", contextPropagators" + this.contextPropagators + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityOptions that = (ActivityOptions)o;
        return Objects.equals(this.heartbeatTimeout, that.heartbeatTimeout) && Objects.equals(this.scheduleToCloseTimeout, that.scheduleToCloseTimeout) && Objects.equals(this.scheduleToStartTimeout, that.scheduleToStartTimeout) && Objects.equals(this.startToCloseTimeout, that.startToCloseTimeout) && Objects.equals(this.taskList, that.taskList) && Objects.equals(this.retryOptions, that.retryOptions) && Objects.equals(this.contextPropagators, that.contextPropagators);
    }

    public int hashCode() {
        return Objects.hash(this.heartbeatTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.startToCloseTimeout, this.taskList, this.retryOptions, this.contextPropagators);
    }

    static Duration mergeDuration(int annotationSeconds, Duration options) {
        if (options == null) {
            if (annotationSeconds == 0) {
                return null;
            }
            return Duration.ofSeconds(annotationSeconds);
        }
        return options;
    }

    public static final class Builder {
        private Duration heartbeatTimeout;
        private Duration scheduleToCloseTimeout;
        private Duration scheduleToStartTimeout;
        private Duration startToCloseTimeout;
        private String taskList;
        private RetryOptions retryOptions;
        private List<ContextPropagator> contextPropagators;

        public Builder() {
        }

        public Builder(ActivityOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToStartTimeout = options.getScheduleToStartTimeout();
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
            this.heartbeatTimeout = options.getHeartbeatTimeout();
            this.startToCloseTimeout = options.getStartToCloseTimeout();
            this.taskList = options.taskList;
            this.retryOptions = options.retryOptions;
            this.contextPropagators = options.contextPropagators;
        }

        public Builder setScheduleToCloseTimeout(Duration scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public Builder setScheduleToStartTimeout(Duration scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public Builder setStartToCloseTimeout(Duration startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public Builder setHeartbeatTimeout(Duration heartbeatTimeoutSeconds) {
            this.heartbeatTimeout = heartbeatTimeoutSeconds;
            return this;
        }

        public Builder setTaskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public ActivityOptions build() {
            return new ActivityOptions(this.heartbeatTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.startToCloseTimeout, this.taskList, this.retryOptions, this.contextPropagators);
        }

        public ActivityOptions validateAndBuildWithDefaults() {
            Duration startToClose;
            if (this.scheduleToCloseTimeout == null && (this.scheduleToStartTimeout == null || this.startToCloseTimeout == null)) {
                throw new IllegalStateException("Either ScheduleToClose or both ScheduleToStart and StartToClose timeouts are required: ");
            }
            Duration scheduleToClose = this.scheduleToCloseTimeout;
            if (scheduleToClose == null) {
                scheduleToClose = this.scheduleToStartTimeout.plus(this.startToCloseTimeout);
            }
            if ((startToClose = this.startToCloseTimeout) == null) {
                startToClose = this.scheduleToCloseTimeout;
            }
            Duration scheduleToStart = this.scheduleToStartTimeout;
            if (this.scheduleToStartTimeout == null) {
                scheduleToStart = scheduleToClose;
            }
            Duration heartbeat = this.heartbeatTimeout;
            if (this.heartbeatTimeout == null) {
                heartbeat = scheduleToClose;
            }
            RetryOptions ro = null;
            if (this.retryOptions != null) {
                ro = new RetryOptions.Builder(this.retryOptions).validateBuildWithDefaults();
            }
            return new ActivityOptions(OptionsUtils.roundUpToSeconds(heartbeat), OptionsUtils.roundUpToSeconds(scheduleToClose), OptionsUtils.roundUpToSeconds(scheduleToStart), OptionsUtils.roundUpToSeconds(startToClose), this.taskList, ro, this.contextPropagators);
        }
    }
}

