/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.google.common.base.Defaults;
import java.time.Duration;

public final class OptionsUtils {
    public static final Duration DEFAULT_TASK_START_TO_CLOSE_TIMEOUT = Duration.ofSeconds(10L);
    public static final float SECOND = 1000.0f;

    public static <G> G merge(G annotation, G options, Class<G> type) {
        Object defaultValue = Defaults.defaultValue(type);
        if (defaultValue == null ? options != null : !defaultValue.equals(options)) {
            return options;
        }
        if (type.equals(String.class)) {
            return ((String)annotation).isEmpty() ? null : (G)annotation;
        }
        return annotation;
    }

    public static Duration merge(long aSeconds, Duration o) {
        if (o != null) {
            return o;
        }
        return aSeconds == 0L ? null : Duration.ofSeconds(aSeconds);
    }

    public static Duration roundUpToSeconds(Duration duration, Duration defaultValue) {
        if (duration == null) {
            return defaultValue;
        }
        return OptionsUtils.roundUpToSeconds(duration);
    }

    public static Duration roundUpToSeconds(Duration duration) {
        if (duration == null) {
            return Duration.ZERO;
        }
        Duration result = Duration.ofMillis((long)(Math.ceil((float)duration.toMillis() / 1000.0f) * 1000.0));
        return result;
    }

    private OptionsUtils() {
    }
}

