/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.metrics;

import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.CapableOf;
import com.uber.m3.tally.Counter;
import com.uber.m3.tally.Gauge;
import com.uber.m3.tally.Histogram;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.tally.Timer;
import com.uber.m3.util.Duration;
import java.util.Map;

public final class NoopScope
implements Scope {
    private static Scope noopScope;
    private static Counter noopCounter;
    private static Gauge noopGauge;
    private static Timer noopTimer;
    private static Histogram noopHistogram;

    public Counter counter(String name) {
        return noopCounter;
    }

    public Gauge gauge(String name) {
        return noopGauge;
    }

    public Timer timer(String name) {
        return noopTimer;
    }

    public Histogram histogram(String name, Buckets buckets) {
        return noopHistogram;
    }

    public Scope tagged(Map<String, String> tags) {
        return this;
    }

    public Scope subScope(String name) {
        return this;
    }

    public Capabilities capabilities() {
        return CapableOf.NONE;
    }

    public void close() {
    }

    private NoopScope() {
    }

    public static synchronized Scope getInstance() {
        if (noopScope == null) {
            noopCounter = delta -> {};
            noopGauge = value -> {};
            noopTimer = new Timer(){

                public void record(Duration interval) {
                }

                public Stopwatch start() {
                    return new Stopwatch(0L, stopwatchStart -> {});
                }
            };
            noopHistogram = new Histogram(){

                public void recordValue(double value) {
                }

                public void recordDuration(Duration value) {
                }

                public Stopwatch start() {
                    return new Stopwatch(0L, stopwatchStart -> {});
                }
            };
            noopScope = new NoopScope();
        }
        return noopScope;
    }
}

