/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.metrics;

import com.uber.cadence.internal.replay.ReplayAware;
import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.Counter;
import com.uber.m3.tally.Gauge;
import com.uber.m3.tally.Histogram;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.ScopeCloseException;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.tally.StopwatchRecorder;
import com.uber.m3.tally.Timer;
import com.uber.m3.util.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ReplayAwareScope
implements Scope {
    private final Scope scope;
    private final ReplayAware context;
    private final Supplier<Long> clock;

    public ReplayAwareScope(Scope scope, ReplayAware context, Supplier<Long> clock) {
        this.scope = Objects.requireNonNull(scope);
        this.context = Objects.requireNonNull(context);
        this.clock = Objects.requireNonNull(clock);
    }

    public Counter counter(String name) {
        return new ReplayAwareCounter(this.scope.counter(name));
    }

    public Gauge gauge(String name) {
        return new ReplayAwareGauge(this.scope.gauge(name));
    }

    public Timer timer(String name) {
        return new ReplayAwareTimer(this.scope.timer(name));
    }

    public Histogram histogram(String name, Buckets buckets) {
        return new ReplayAwareHistogram(this.scope.histogram(name, buckets));
    }

    public Scope tagged(Map<String, String> tags) {
        return new ReplayAwareScope(this.scope.tagged(tags), this.context, this.clock);
    }

    public Scope subScope(String name) {
        return new ReplayAwareScope(this.scope.subScope(name), this.context, this.clock);
    }

    public Capabilities capabilities() {
        return this.scope.capabilities();
    }

    public void close() throws ScopeCloseException {
        this.scope.close();
    }

    private class ReplayAwareHistogram
    implements Histogram,
    DurationRecorder {
        Histogram histogram;

        ReplayAwareHistogram(Histogram histogram) {
            this.histogram = Objects.requireNonNull(histogram);
        }

        public void recordValue(double value) {
            if (ReplayAwareScope.this.context.isReplaying()) {
                return;
            }
            this.histogram.recordValue(value);
        }

        @Override
        public void recordDuration(Duration value) {
            if (ReplayAwareScope.this.context.isReplaying()) {
                return;
            }
            this.histogram.recordDuration(value);
        }

        public Stopwatch start() {
            long startNanos = TimeUnit.MILLISECONDS.toNanos((Long)ReplayAwareScope.this.clock.get());
            return new Stopwatch(startNanos, (StopwatchRecorder)new ReplayAwareStopwatchRecorder(this));
        }
    }

    private class ReplayAwareStopwatchRecorder
    implements StopwatchRecorder {
        DurationRecorder recorder;

        ReplayAwareStopwatchRecorder(DurationRecorder recorder) {
            this.recorder = recorder;
        }

        public void recordStopwatch(long startNanos) {
            long endNanos = TimeUnit.MILLISECONDS.toNanos((Long)ReplayAwareScope.this.clock.get());
            this.recorder.recordDuration(Duration.between((long)startNanos, (long)endNanos));
        }
    }

    static interface DurationRecorder {
        public void recordDuration(Duration var1);
    }

    private class ReplayAwareTimer
    implements Timer,
    DurationRecorder {
        Timer timer;

        ReplayAwareTimer(Timer timer) {
            this.timer = Objects.requireNonNull(timer);
        }

        public void record(Duration interval) {
            if (ReplayAwareScope.this.context.isReplaying()) {
                return;
            }
            this.timer.record(interval);
        }

        public Stopwatch start() {
            long startNanos = TimeUnit.MILLISECONDS.toNanos((Long)ReplayAwareScope.this.clock.get());
            return new Stopwatch(startNanos, (StopwatchRecorder)new ReplayAwareStopwatchRecorder(this));
        }

        @Override
        public void recordDuration(Duration interval) {
            this.record(interval);
        }
    }

    private class ReplayAwareGauge
    implements Gauge {
        Gauge gauge;

        ReplayAwareGauge(Gauge gauge) {
            this.gauge = Objects.requireNonNull(gauge);
        }

        public void update(double value) {
            if (ReplayAwareScope.this.context.isReplaying()) {
                return;
            }
            this.gauge.update(value);
        }
    }

    private class ReplayAwareCounter
    implements Counter {
        Counter counter;

        ReplayAwareCounter(Counter counter) {
            this.counter = Objects.requireNonNull(counter);
        }

        public void inc(long delta) {
            if (ReplayAwareScope.this.context.isReplaying()) {
                return;
            }
            this.counter.inc(delta);
        }
    }
}

