/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.common.CronSchedule;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.ChildWorkflowStubImpl;
import com.uber.cadence.internal.sync.WorkflowInvocationHandler;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ChildWorkflowStub;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.SignalMethod;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ChildWorkflowInvocationHandler
implements InvocationHandler {
    private final ChildWorkflowStub stub;

    ChildWorkflowInvocationHandler(Class<?> workflowInterface, ChildWorkflowOptions options, WorkflowInterceptor decisionContext) {
        Method workflowMethod = InternalUtils.getWorkflowMethod(workflowInterface);
        WorkflowMethod workflowAnnotation = workflowMethod.getAnnotation(WorkflowMethod.class);
        String workflowType = InternalUtils.getWorkflowType(workflowMethod, workflowAnnotation);
        MethodRetry retryAnnotation = workflowMethod.getAnnotation(MethodRetry.class);
        CronSchedule cronSchedule = workflowMethod.getAnnotation(CronSchedule.class);
        ChildWorkflowOptions merged = ChildWorkflowOptions.merge(workflowAnnotation, retryAnnotation, cronSchedule, options);
        this.stub = new ChildWorkflowStubImpl(workflowType, merged, decisionContext);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("__getWorkflowExecution")) {
            return this.stub.getExecution();
        }
        WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
        QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
        SignalMethod signalMethod = method.getAnnotation(SignalMethod.class);
        WorkflowInvocationHandler.checkAnnotations(method, workflowMethod, queryMethod, signalMethod);
        if (workflowMethod != null) {
            return InternalUtils.getValueOrDefault(this.stub.execute(method.getReturnType(), method.getGenericReturnType(), args), method.getReturnType());
        }
        if (queryMethod != null) {
            throw new UnsupportedOperationException("Query is not supported from workflow to workflow. Use activity that perform the query instead.");
        }
        if (signalMethod != null) {
            this.signalWorkflow(method, signalMethod, args);
            return null;
        }
        throw new IllegalArgumentException(method + " is not annotated with @WorkflowMethod or @QueryMethod");
    }

    private void signalWorkflow(Method method, SignalMethod signalMethod, Object[] args) {
        String signalName = signalMethod.name();
        if (signalName.isEmpty()) {
            signalName = InternalUtils.getSimpleName(method);
        }
        this.stub.signal(signalName, args);
    }
}

