/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.EventType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.DecisionContext;
import com.uber.cadence.internal.replay.ReplayWorkflow;
import com.uber.cadence.internal.sync.DeterministicRunner;
import com.uber.cadence.internal.sync.POJOWorkflowImplementationFactory;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.SyncWorkflowDefinition;
import com.uber.cadence.internal.sync.WorkflowRunnable;
import com.uber.cadence.internal.worker.WorkflowExecutionException;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

class SyncWorkflow
implements ReplayWorkflow {
    private final DataConverter dataConverter;
    private final List<ContextPropagator> contextPropagators;
    private final ExecutorService threadPool;
    private final SyncWorkflowDefinition workflow;
    WorkflowImplementationOptions workflowImplementationOptions;
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;
    private DeciderCache cache;
    private WorkflowRunnable workflowProc;
    private DeterministicRunner runner;

    public SyncWorkflow(SyncWorkflowDefinition workflow, WorkflowImplementationOptions workflowImplementationOptions, DataConverter dataConverter, ExecutorService threadPool, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, DeciderCache cache, List<ContextPropagator> contextPropagators) {
        this.workflow = Objects.requireNonNull(workflow);
        this.workflowImplementationOptions = workflowImplementationOptions == null ? new WorkflowImplementationOptions.Builder().build() : workflowImplementationOptions;
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
        this.cache = cache;
        this.contextPropagators = contextPropagators;
    }

    @Override
    public WorkflowImplementationOptions getWorkflowImplementationOptions() {
        return this.workflowImplementationOptions;
    }

    @Override
    public void start(HistoryEvent event, DecisionContext context) {
        WorkflowType workflowType = event.getWorkflowExecutionStartedEventAttributes().getWorkflowType();
        if (this.workflow == null) {
            throw new IllegalArgumentException("Unknown workflow type: " + workflowType);
        }
        if (event.getEventType() != EventType.WorkflowExecutionStarted) {
            throw new IllegalArgumentException("first event is not WorkflowExecutionStarted, but " + (Object)((Object)event.getEventType()));
        }
        SyncDecisionContext syncContext = new SyncDecisionContext(context, this.dataConverter, this.contextPropagators, this.interceptorFactory, event.getWorkflowExecutionStartedEventAttributes().getLastCompletionResult());
        this.workflowProc = new WorkflowRunnable(syncContext, this.workflow, event.getWorkflowExecutionStartedEventAttributes());
        this.runner = DeterministicRunner.newRunner(this.threadPool, syncContext, context::currentTimeMillis, this.workflowProc, this.cache);
        syncContext.setRunner(this.runner);
    }

    @Override
    public void handleSignal(String signalName, byte[] input, long eventId) {
        String threadName = "\"" + signalName + "\" signal handler";
        this.runner.executeInWorkflowThread(threadName, () -> this.workflowProc.processSignal(signalName, input, eventId));
    }

    @Override
    public boolean eventLoop() throws Throwable {
        if (this.runner == null) {
            return false;
        }
        this.workflowProc.fireTimers();
        this.runner.runUntilAllBlocked();
        return this.runner.isDone() || this.workflowProc.isDone();
    }

    @Override
    public byte[] getOutput() {
        return this.workflowProc.getOutput();
    }

    @Override
    public void cancel(String reason) {
        this.runner.cancel(reason);
    }

    @Override
    public void close() {
        if (this.runner != null) {
            this.runner.close();
        }
    }

    @Override
    public long getNextWakeUpTime() {
        return this.runner.getNextWakeUpTime();
    }

    @Override
    public byte[] query(WorkflowQuery query) {
        if ("__replay_only".equals(query.getQueryType())) {
            return new byte[0];
        }
        if ("__stack_trace".equals(query.getQueryType())) {
            return this.dataConverter.toData(this.runner.stackTrace());
        }
        return this.workflowProc.query(query.getQueryType(), query.getQueryArgs());
    }

    @Override
    public WorkflowExecutionException mapUnexpectedException(Exception failure) {
        return POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(failure, this.dataConverter);
    }

    @Override
    public WorkflowExecutionException mapError(Error failure) {
        return POJOWorkflowImplementationFactory.mapError(failure, this.dataConverter);
    }
}

