/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.google.common.base.Throwables;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.internal.testservice.ExecutionId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

final class DecisionTaskToken {
    private final ExecutionId executionId;
    private final int historySize;

    DecisionTaskToken(ExecutionId executionId, int historySize) {
        this.executionId = Objects.requireNonNull(executionId);
        this.historySize = Objects.requireNonNull(historySize);
    }

    ExecutionId getExecutionId() {
        return this.executionId;
    }

    int getHistorySize() {
        return this.historySize;
    }

    byte[] toBytes() throws InternalServiceError {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            this.addBytes(out);
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
        return bout.toByteArray();
    }

    private void addBytes(DataOutputStream out) throws IOException {
        this.executionId.addBytes(out);
        out.writeInt(this.historySize);
    }

    static DecisionTaskToken fromBytes(byte[] serialized) throws InternalServiceError {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            ExecutionId executionId = ExecutionId.readFromBytes(in);
            int historySize = in.readInt();
            return new DecisionTaskToken(executionId, historySize);
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

