/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.DecisionTaskFailedCause;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.internal.worker.ShutdownableTaskExecutor;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollDecisionTaskDispatcher
implements ShutdownableTaskExecutor<PollForDecisionTaskResponse> {
    private static final Logger log = LoggerFactory.getLogger(PollDecisionTaskDispatcher.class);
    private final Map<String, Consumer<PollForDecisionTaskResponse>> subscribers = new ConcurrentHashMap<String, Consumer<PollForDecisionTaskResponse>>();
    private IWorkflowService service;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (t, e) -> log.error("uncaught exception", e);
    private AtomicBoolean shutdown = new AtomicBoolean();

    public PollDecisionTaskDispatcher(IWorkflowService service) {
        this.service = Objects.requireNonNull(service);
    }

    public PollDecisionTaskDispatcher(IWorkflowService service, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.service = Objects.requireNonNull(service);
        if (exceptionHandler != null) {
            this.uncaughtExceptionHandler = exceptionHandler;
        }
    }

    @Override
    public void process(PollForDecisionTaskResponse t) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("shutdown");
        }
        String taskListName = t.getWorkflowExecutionTaskList().getName();
        if (this.subscribers.containsKey(taskListName)) {
            this.subscribers.get(taskListName).accept(t);
        } else {
            RespondDecisionTaskFailedRequest request = new RespondDecisionTaskFailedRequest();
            request.setTaskToken(t.getTaskToken());
            request.setCause(DecisionTaskFailedCause.RESET_STICKY_TASKLIST);
            String message = String.format("No handler is subscribed for the PollForDecisionTaskResponse.WorkflowExecutionTaskList %s", taskListName);
            request.setDetails(message.getBytes(Charset.defaultCharset()));
            log.warn(message);
            try {
                this.service.RespondDecisionTaskFailed(request);
            }
            catch (Exception e) {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    public void subscribe(String taskList, Consumer<PollForDecisionTaskResponse> consumer) {
        this.subscribers.put(taskList, consumer);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get();
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
    }

    @Override
    public void shutdownNow() {
        this.shutdown.set(true);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
    }
}

