/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.serviceclient;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.m3.tally.Scope;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClientOptions {
    private static final int DEFAULT_LOCAL_CADENCE_SERVER_PORT = 7933;
    private static final String LOCALHOST = "127.0.0.1";
    private static final long DEFAULT_RPC_TIMEOUT_MILLIS = 3000L;
    private static final long DEFAULT_POLL_RPC_TIMEOUT_MILLIS = 30000L;
    private static final long DEFAULT_QUERY_RPC_TIMEOUT_MILLIS = 10000L;
    private static final long DEFAULT_LIST_ARCHIVED_WORKFLOW_TIMEOUT_MILLIS = 180000L;
    private static final String DEFAULT_CLIENT_APP_NAME = "cadence-client";
    private static final String DEFAULT_SERVICE_NAME = "cadence-frontend";
    private static final boolean DEFAULT_RPC_ERROR_RETRY = false;
    private static final int DEFAULT_RPC_ERROR_RETRY_TIMES = 3;
    private static final long DEFAULT_RPC_ERROR_RETRY_INTERVAL = 120000L;
    private static final List<Integer> DEFAULT_RPC_ERROR_RETRY_TYPES = Stream.of(3, 99).collect(Collectors.toList());
    private final String host;
    private final int port;
    private final long rpcTimeoutMillis;
    private final long rpcLongPollTimeoutMillis;
    private final long rpcQueryTimeoutMillis;
    private final long rpcListArchivedWorkflowTimeoutMillis;
    private final String serviceName;
    private final String clientAppName;
    private final Scope metricsScope;
    private final Map<String, String> transportHeaders;
    private final Map<String, String> headers;
    private final boolean rpcErrorRetry;
    private final int rpcErrorRetryTimes;
    private final long rpcErrorRetryInterval;
    private final List<Integer> rpcErrorRetryTypes;
    private static final ClientOptions DEFAULT_INSTANCE = new Builder().build();

    public static ClientOptions defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ClientOptions(Builder builder) {
        this.host = Strings.isNullOrEmpty((String)builder.host) ? (Strings.isNullOrEmpty((String)System.getenv("CADENCE_SEEDS")) ? LOCALHOST : System.getenv("CADENCE_SEEDS")) : builder.host;
        this.port = builder.port;
        this.rpcTimeoutMillis = builder.rpcTimeoutMillis;
        this.clientAppName = builder.clientAppName == null ? DEFAULT_CLIENT_APP_NAME : builder.clientAppName;
        this.serviceName = builder.serviceName == null ? DEFAULT_SERVICE_NAME : builder.serviceName;
        this.rpcLongPollTimeoutMillis = builder.rpcLongPollTimeoutMillis;
        this.rpcQueryTimeoutMillis = builder.rpcQueryTimeoutMillis;
        this.rpcListArchivedWorkflowTimeoutMillis = builder.rpcListArchivedWorkflowTimeoutMillis;
        if (builder.metricsScope == null) {
            builder.metricsScope = NoopScope.getInstance();
        }
        this.metricsScope = builder.metricsScope;
        this.transportHeaders = builder.transportHeaders != null ? ImmutableMap.copyOf((Map)builder.transportHeaders) : ImmutableMap.of();
        this.headers = builder.headers != null ? ImmutableMap.copyOf((Map)builder.headers) : ImmutableMap.of();
        this.rpcErrorRetry = builder.rpcErrorRetry;
        this.rpcErrorRetryTimes = builder.rpcErrorRetryTimes;
        this.rpcErrorRetryInterval = builder.rpcErrorRetryInterval;
        this.rpcErrorRetryTypes = builder.rpcErrorRetryTypes;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getRpcTimeoutMillis() {
        return this.rpcTimeoutMillis;
    }

    public long getRpcLongPollTimeoutMillis() {
        return this.rpcLongPollTimeoutMillis;
    }

    public long getRpcQueryTimeoutMillis() {
        return this.rpcQueryTimeoutMillis;
    }

    public long getRpcListArchivedWorkflowTimeoutMillis() {
        return this.rpcListArchivedWorkflowTimeoutMillis;
    }

    public String getClientAppName() {
        return this.clientAppName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean getRpcErrorRetry() {
        return this.rpcErrorRetry;
    }

    public int getRpcErrorRetryTimes() {
        return this.rpcErrorRetryTimes;
    }

    public long getRpcErrorRetryInterval() {
        return this.rpcErrorRetryInterval;
    }

    public List<Integer> getRpcErrorRetryTypes() {
        return this.rpcErrorRetryTypes;
    }

    static /* synthetic */ List access$1600() {
        return DEFAULT_RPC_ERROR_RETRY_TYPES;
    }

    public static class Builder {
        private String host;
        private int port = 7933;
        private String clientAppName = "cadence-client";
        private long rpcTimeoutMillis = 3000L;
        private long rpcLongPollTimeoutMillis = 30000L;
        private long rpcQueryTimeoutMillis = 10000L;
        private long rpcListArchivedWorkflowTimeoutMillis = 180000L;
        private String serviceName;
        private Scope metricsScope;
        private Map<String, String> transportHeaders;
        private Map<String, String> headers;
        private boolean rpcErrorRetry = false;
        private int rpcErrorRetryTimes = 3;
        private long rpcErrorRetryInterval = 120000L;
        private List<Integer> rpcErrorRetryTypes = ClientOptions.access$1600();

        private Builder() {
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setRpcTimeout(long timeoutMillis) {
            this.rpcTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setRpcLongPollTimeout(long timeoutMillis) {
            this.rpcLongPollTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setQueryRpcTimeout(long timeoutMillis) {
            this.rpcQueryTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setListArchivedWorkflowRpcTimeout(long timeoutMillis) {
            this.rpcListArchivedWorkflowTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setClientAppName(String clientAppName) {
            this.clientAppName = clientAppName;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setTransportHeaders(Map<String, String> transportHeaders) {
            this.transportHeaders = transportHeaders;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setRpcErrorRetry(boolean rpcErrorRetry) {
            this.rpcErrorRetry = rpcErrorRetry;
            return this;
        }

        public Builder setRpcErrorRetryTimes(int rpcErrorRetryTimes) {
            this.rpcErrorRetryTimes = rpcErrorRetryTimes;
            return this;
        }

        public Builder setRpcErrorRetryInterval(long rpcErrorRetryInterval) {
            this.rpcErrorRetryInterval = rpcErrorRetryInterval;
            return this;
        }

        public Builder addRpcErrorRetryTypes(Integer ... errorTypes) {
            this.rpcErrorRetryTypes.clear();
            this.rpcErrorRetryTypes = Arrays.asList(errorTypes);
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

