/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.worker.PollDecisionTaskDispatcher;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.WorkflowPollTaskFactory;
import com.uber.cadence.worker.Worker;
import com.uber.cadence.worker.WorkerFactoryOptions;
import com.uber.cadence.worker.WorkerOptions;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkerFactory {
    private final List<Worker> workers = new ArrayList<Worker>();
    private final WorkflowClient workflowClient;
    private final UUID id = UUID.randomUUID();
    private final ThreadPoolExecutor workflowThreadPool;
    private final AtomicInteger workflowThreadCounter = new AtomicInteger();
    private final WorkerFactoryOptions factoryOptions;
    private Poller<PollForDecisionTaskResponse> stickyPoller;
    private PollDecisionTaskDispatcher dispatcher;
    private DeciderCache cache;
    private State state = State.Initial;
    private final String statusErrorMessage = "attempted to %s while in %s state. Acceptable States: %s";
    private static final Logger log = LoggerFactory.getLogger(WorkerFactory.class);
    private static final String STICKY_TASK_LIST_PREFIX = "sticky";
    private static final String POLL_THREAD_NAME = "Sticky Task Poller";

    public static WorkerFactory newInstance(WorkflowClient workflowClient) {
        return WorkerFactory.newInstance(workflowClient, WorkerFactoryOptions.defaultInstance());
    }

    public static WorkerFactory newInstance(WorkflowClient workflowClient, WorkerFactoryOptions options) {
        return new WorkerFactory(workflowClient, options);
    }

    public WorkerFactory(WorkflowClient workflowClient, WorkerFactoryOptions factoryOptions) {
        this.workflowClient = Objects.requireNonNull(workflowClient);
        this.factoryOptions = (WorkerFactoryOptions)MoreObjects.firstNonNull((Object)factoryOptions, (Object)WorkerFactoryOptions.defaultInstance());
        this.workflowThreadPool = new ThreadPoolExecutor(0, this.factoryOptions.getMaxWorkflowThreadCount(), 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.workflowThreadPool.setThreadFactory(r -> new Thread(r, "workflow-thread-" + this.workflowThreadCounter.incrementAndGet()));
        if (this.factoryOptions.isDisableStickyExecution()) {
            return;
        }
        Scope stickyScope = workflowClient.getOptions().getMetricsScope().tagged((Map)ImmutableMap.of((Object)"Domain", (Object)workflowClient.getOptions().getDomain(), (Object)"TaskList", (Object)this.getStickyTaskListName()));
        this.cache = new DeciderCache(this.factoryOptions.getCacheMaximumSize(), stickyScope);
        this.dispatcher = new PollDecisionTaskDispatcher(workflowClient.getService());
        this.stickyPoller = new Poller<PollForDecisionTaskResponse>(this.id.toString(), (Poller.PollTask<PollForDecisionTaskResponse>)new WorkflowPollTaskFactory(workflowClient.getService(), workflowClient.getOptions().getDomain(), this.getStickyTaskListName(), stickyScope, this.id.toString()).get(), this.dispatcher, PollerOptions.newBuilder().setPollThreadNamePrefix(POLL_THREAD_NAME).setPollThreadCount(this.factoryOptions.getStickyPollerCount()).build(), stickyScope);
    }

    public Worker newWorker(String taskList) {
        return this.newWorker(taskList, null);
    }

    public synchronized Worker newWorker(String taskList, WorkerOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskList) ? 1 : 0) != 0, (Object)"taskList should not be an empty string");
        Preconditions.checkState((this.state == State.Initial ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "create new worker", this.state.name(), State.Initial.name()));
        Worker worker = new Worker(this.workflowClient, taskList, this.factoryOptions, options, this.cache, this.getStickyTaskListName(), this.factoryOptions.getStickyTaskScheduleToStartTimeout(), this.workflowThreadPool, this.workflowClient.getOptions().getContextPropagators());
        this.workers.add(worker);
        if (!this.factoryOptions.isDisableStickyExecution()) {
            this.dispatcher.subscribe(taskList, worker.getWorkflowWorker());
        }
        return worker;
    }

    public synchronized void start() {
        Preconditions.checkState((this.state == State.Initial || this.state == State.Started ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "start WorkerFactory", this.state.name(), String.format("%s, %s", State.Initial.name(), State.Initial.name())));
        if (this.state == State.Started) {
            return;
        }
        this.state = State.Started;
        for (Worker worker : this.workers) {
            worker.start();
        }
        if (this.stickyPoller != null) {
            this.stickyPoller.start();
        }
    }

    public synchronized boolean isStarted() {
        return this.state != State.Initial;
    }

    public synchronized boolean isShutdown() {
        return this.state == State.Shutdown;
    }

    public synchronized boolean isTerminated() {
        if (this.state != State.Shutdown) {
            return false;
        }
        if (this.stickyPoller != null && !this.stickyPoller.isTerminated()) {
            return false;
        }
        for (Worker worker : this.workers) {
            if (worker.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    public synchronized void shutdown() {
        log.info("shutdown");
        this.state = State.Shutdown;
        if (this.stickyPoller != null) {
            this.stickyPoller.shutdown();
            this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
        }
        for (Worker worker : this.workers) {
            worker.shutdown();
        }
    }

    public synchronized void shutdownNow() {
        log.info("shutdownNow");
        this.state = State.Shutdown;
        if (this.stickyPoller != null) {
            this.stickyPoller.shutdownNow();
            this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
        }
        for (Worker worker : this.workers) {
            worker.shutdownNow();
        }
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        log.debug("awaitTermination begin");
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = InternalUtils.awaitTermination(this.stickyPoller, timeoutMillis);
        for (Worker worker : this.workers) {
            long t = timeoutMillis;
            timeoutMillis = InternalUtils.awaitTermination(timeoutMillis, () -> worker.awaitTermination(t, TimeUnit.MILLISECONDS));
        }
        log.debug("awaitTermination done");
    }

    @VisibleForTesting
    DeciderCache getCache() {
        return this.cache;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "UnknownHost";
        }
    }

    @VisibleForTesting
    String getStickyTaskListName() {
        return this.factoryOptions.isDisableStickyExecution() ? null : String.format("%s:%s:%s", STICKY_TASK_LIST_PREFIX, this.getHostName(), this.id);
    }

    public synchronized void suspendPolling() {
        if (this.state != State.Started) {
            return;
        }
        log.info("suspendPolling");
        this.state = State.Suspended;
        if (this.stickyPoller != null) {
            this.stickyPoller.suspendPolling();
        }
        for (Worker worker : this.workers) {
            worker.suspendPolling();
        }
    }

    public synchronized void resumePolling() {
        if (this.state != State.Suspended) {
            return;
        }
        log.info("resumePolling");
        this.state = State.Started;
        if (this.stickyPoller != null) {
            this.stickyPoller.resumePolling();
        }
        for (Worker worker : this.workers) {
            worker.resumePolling();
        }
    }

    public void cleanDeciderCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    static enum State {
        Initial,
        Started,
        Suspended,
        Shutdown;

    }
}

