/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.workflow;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.workflow.ActivityStub;
import com.uber.cadence.workflow.CancellationScope;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ChildWorkflowStub;
import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.ExternalWorkflowStub;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.WorkflowInfo;
import com.uber.cadence.workflow.WorkflowQueue;
import com.uber.m3.tally.Scope;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.slf4j.Logger;

public final class Workflow {
    public static final int DEFAULT_VERSION = -1;

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        return WorkflowInternal.newActivityStub(activityInterface, options);
    }

    public static <T> T newActivityStub(Class<T> activityInterface) {
        return WorkflowInternal.newActivityStub(activityInterface, null);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return WorkflowInternal.newUntypedActivityStub(options);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options) {
        return WorkflowInternal.newLocalActivityStub(activityInterface, options);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface) {
        return WorkflowInternal.newLocalActivityStub(activityInterface, null);
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return WorkflowInternal.newUntypedLocalActivityStub(options);
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface) {
        return WorkflowInternal.newChildWorkflowStub(workflowInterface, null);
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return WorkflowInternal.newChildWorkflowStub(workflowInterface, options);
    }

    public static <R> R newExternalWorkflowStub(Class<? extends R> workflowInterface, String workflowId) {
        WorkflowExecution execution = new WorkflowExecution().setWorkflowId(workflowId);
        return WorkflowInternal.newExternalWorkflowStub(workflowInterface, execution);
    }

    public static <R> R newExternalWorkflowStub(Class<? extends R> workflowInterface, WorkflowExecution execution) {
        return WorkflowInternal.newExternalWorkflowStub(workflowInterface, execution);
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object childWorkflowStub) {
        return WorkflowInternal.getWorkflowExecution(childWorkflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return WorkflowInternal.newUntypedChildWorkflowStub(workflowType, options);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType) {
        return WorkflowInternal.newUntypedChildWorkflowStub(workflowType, null);
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return WorkflowInternal.newUntypedExternalWorkflowStub(execution);
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(String workflowId) {
        WorkflowExecution execution = new WorkflowExecution().setWorkflowId(workflowId);
        return Workflow.newUntypedExternalWorkflowStub(execution);
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return WorkflowInternal.newContinueAsNewStub(workflowInterface, options);
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface) {
        return WorkflowInternal.newContinueAsNewStub(workflowInterface, null);
    }

    public static void continueAsNew(Object ... args) {
        Workflow.continueAsNew(Optional.empty(), Optional.empty(), args);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object ... args) {
        WorkflowInternal.continueAsNew(workflowType, options, args);
    }

    public static WorkflowInfo getWorkflowInfo() {
        return WorkflowInternal.getWorkflowInfo();
    }

    public static CancellationScope newCancellationScope(Runnable runnable) {
        return WorkflowInternal.newCancellationScope(false, runnable);
    }

    public static CancellationScope newCancellationScope(Functions.Proc1<CancellationScope> proc) {
        return WorkflowInternal.newCancellationScope(false, proc);
    }

    public static CancellationScope newDetachedCancellationScope(Runnable runnable) {
        return WorkflowInternal.newCancellationScope(true, runnable);
    }

    public static Promise<Void> newTimer(Duration delay) {
        return WorkflowInternal.newTimer(delay);
    }

    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return WorkflowInternal.newQueue(capacity);
    }

    public static <E> CompletablePromise<E> newPromise() {
        return WorkflowInternal.newCompletablePromise();
    }

    public static <E> Promise<E> newPromise(E value) {
        return WorkflowInternal.newPromise(value);
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        return WorkflowInternal.newFailedPromise(failure);
    }

    public static void registerQuery(Object queryImplementation) {
        WorkflowInternal.registerQuery(queryImplementation);
    }

    public static long currentTimeMillis() {
        return WorkflowInternal.currentTimeMillis();
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.sleep(duration);
    }

    public static void sleep(long millis) {
        WorkflowInternal.sleep(Duration.ofMillis(millis));
    }

    public static void await(Supplier<Boolean> unblockCondition) {
        WorkflowInternal.await("await", () -> {
            CancellationScope.throwCancelled();
            return (Boolean)unblockCondition.get();
        });
    }

    public static boolean await(Duration timeout, Supplier<Boolean> unblockCondition) {
        return WorkflowInternal.await(timeout, "await", () -> {
            CancellationScope.throwCancelled();
            return (Boolean)unblockCondition.get();
        });
    }

    public static <R> R retry(RetryOptions options, Functions.Func<R> fn) {
        return WorkflowInternal.retry(options, fn);
    }

    public static void retry(RetryOptions options, Functions.Proc proc) {
        WorkflowInternal.retry(options, () -> {
            proc.apply();
            return null;
        });
    }

    public static RuntimeException wrap(Exception e) {
        return WorkflowInternal.wrap(e);
    }

    public static Exception unwrap(Exception e) {
        return WorkflowInternal.unwrap(e);
    }

    public static UUID randomUUID() {
        return WorkflowInternal.randomUUID();
    }

    public static Random newRandom() {
        return WorkflowInternal.newRandom();
    }

    public static boolean isReplaying() {
        return WorkflowInternal.isReplaying();
    }

    public static <R> R sideEffect(Class<R> resultClass, Functions.Func<R> func) {
        return WorkflowInternal.sideEffect(resultClass, resultClass, func);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        return WorkflowInternal.sideEffect(resultClass, resultType, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.mutableSideEffect(id, resultClass, resultClass, updated, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static int getVersion(String changeID, int minSupported, int maxSupported) {
        return WorkflowInternal.getVersion(changeID, minSupported, maxSupported);
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getMetricsScope();
    }

    public static Logger getLogger(Class<?> clazz) {
        return WorkflowInternal.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return WorkflowInternal.getLogger(name);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass) {
        return WorkflowInternal.getLastCompletionResult(resultClass, resultClass);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getLastCompletionResult(resultClass, resultType);
    }

    public static void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        WorkflowInternal.upsertSearchAttributes(searchAttributes);
    }

    private Workflow() {
    }
}

