/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.QueryRejectCondition;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.client.WorkflowOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public interface WorkflowStub {
    public static <T> WorkflowStub fromTyped(T typed) {
        if (!(typed instanceof Proxy)) {
            throw new IllegalArgumentException("arguments must be created through WorkflowClient.newWorkflowStub");
        }
        InvocationHandler handler = Proxy.getInvocationHandler(typed);
        if (!(handler instanceof Supplier)) {
            throw new IllegalArgumentException("arguments must be created through WorkflowClient.newWorkflowStub");
        }
        Supplier supplier = (Supplier)((Object)handler);
        return (WorkflowStub)supplier.get();
    }

    public void signal(String var1, Object ... var2);

    public CompletableFuture<Void> signalAsync(String var1, Object ... var2);

    public CompletableFuture<Void> signalAsyncWithTimeout(long var1, TimeUnit var3, String var4, Object ... var5);

    public WorkflowExecution start(Object ... var1);

    public CompletableFuture<WorkflowExecution> startAsync(Object ... var1);

    public CompletableFuture<WorkflowExecution> startAsyncWithTimeout(long var1, TimeUnit var3, Object ... var4);

    public WorkflowExecution signalWithStart(String var1, Object[] var2, Object[] var3);

    public Optional<String> getWorkflowType();

    public WorkflowExecution getExecution();

    public <R> R getResult(Class<R> var1, Type var2);

    public <R> CompletableFuture<R> getResultAsync(Class<R> var1, Type var2);

    public <R> R getResult(Class<R> var1);

    public <R> CompletableFuture<R> getResultAsync(Class<R> var1);

    public <R> R getResult(long var1, TimeUnit var3, Class<R> var4, Type var5) throws TimeoutException;

    public <R> R getResult(long var1, TimeUnit var3, Class<R> var4) throws TimeoutException;

    public <R> CompletableFuture<R> getResultAsync(long var1, TimeUnit var3, Class<R> var4, Type var5);

    public <R> CompletableFuture<R> getResultAsync(long var1, TimeUnit var3, Class<R> var4);

    public <R> R query(String var1, Class<R> var2, Object ... var3);

    public <R> R query(String var1, Class<R> var2, Type var3, Object ... var4);

    public <R> R query(String var1, Class<R> var2, QueryRejectCondition var3, Object ... var4);

    public <R> R query(String var1, Class<R> var2, Type var3, QueryRejectCondition var4, Object ... var5);

    public void cancel();

    public Optional<WorkflowOptions> getOptions();
}

