/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.converter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.uber.cadence.converter.DataConverterException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TBaseTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, final TypeToken<T> typeToken) {
        if (!TBase.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        TypeAdapter result = new TypeAdapter<T>(){

            public void write(JsonWriter jsonWriter, T value) throws IOException {
                try {
                    String result = TBaseTypeAdapterFactory.newThriftSerializer().toString((TBase)value);
                    jsonWriter.value(result);
                }
                catch (TException e) {
                    throw new DataConverterException("Failed to serialize TBase", e);
                }
            }

            public T read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                try {
                    Object instance = typeToken.getRawType().getConstructor(new Class[0]).newInstance(new Object[0]);
                    TBaseTypeAdapterFactory.newThriftDeserializer().deserialize((TBase)instance, value, StandardCharsets.UTF_8.name());
                    return instance;
                }
                catch (Exception e) {
                    throw new DataConverterException("Failed to deserialize TBase", e);
                }
            }
        }.nullSafe();
        return result;
    }

    private static TSerializer newThriftSerializer() {
        try {
            return new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        }
        catch (TException err) {
            throw new RuntimeException("newThriftSerializer failed", err);
        }
    }

    private static TDeserializer newThriftDeserializer() {
        try {
            return new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        }
        catch (TException err) {
            throw new RuntimeException("newThriftDeserializer failed", err);
        }
    }
}

