/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackoffThrottler {
    private final Duration initialSleep;
    private final Duration maxSleep;
    private final double backoffCoefficient;
    private final AtomicLong failureCount = new AtomicLong();
    private static final Logger log = LoggerFactory.getLogger(BackoffThrottler.class);

    public BackoffThrottler(Duration initialSleep, Duration maxSleep, double backoffCoefficient) {
        Objects.requireNonNull(initialSleep, "initialSleep");
        this.initialSleep = initialSleep;
        this.maxSleep = maxSleep;
        this.backoffCoefficient = backoffCoefficient;
    }

    private long calculateSleepTime() {
        double sleepMillis = Math.pow(this.backoffCoefficient, this.failureCount.get() - 1L) * (double)this.initialSleep.toMillis();
        if (this.maxSleep != null) {
            return Math.min((long)sleepMillis, this.maxSleep.toMillis());
        }
        return (long)sleepMillis;
    }

    public void throttle() throws InterruptedException {
        if (this.failureCount.get() > 0L) {
            long sleepTime = this.calculateSleepTime();
            log.warn("Retrying sleep time " + sleepTime);
            Thread.sleep(this.calculateSleepTime());
        }
    }

    public void success() {
        this.failureCount.set(0L);
    }

    public void failure() {
        this.failureCount.incrementAndGet();
    }
}

