/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.external;

import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.client.ActivityCancelledException;
import com.uber.cadence.client.ActivityCompletionFailureException;
import com.uber.cadence.client.ActivityNotExistsException;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.external.ManualActivityCompletionClient;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import java.util.concurrent.CancellationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManualActivityCompletionClientImpl
extends ManualActivityCompletionClient {
    private static final Logger log = LoggerFactory.getLogger(ManualActivityCompletionClientImpl.class);
    private final IWorkflowService service;
    private final byte[] taskToken;
    private final DataConverter dataConverter;
    private final String domain;
    private final WorkflowExecution execution;
    private final String activityId;
    private final Scope metricsScope;

    ManualActivityCompletionClientImpl(IWorkflowService service, String domain, byte[] taskToken, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.taskToken = taskToken;
        this.dataConverter = dataConverter;
        this.domain = domain;
        this.execution = null;
        this.activityId = null;
        this.metricsScope = metricsScope;
    }

    ManualActivityCompletionClientImpl(IWorkflowService service, String domain, WorkflowExecution execution, String activityId, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.taskToken = null;
        this.domain = domain;
        this.execution = execution;
        this.activityId = activityId;
        this.dataConverter = dataConverter;
        this.metricsScope = metricsScope;
    }

    @Override
    public void complete(Object result) {
        if (this.taskToken != null) {
            RespondActivityTaskCompletedRequest request = new RespondActivityTaskCompletedRequest();
            byte[] convertedResult = this.dataConverter.toData(result);
            request.setResult(convertedResult);
            request.setTaskToken(this.taskToken);
            try {
                RpcRetryer.retry(() -> this.service.RespondActivityTaskCompleted(request));
                this.metricsScope.counter("cadence-activity-task-completed").inc(1L);
            }
            catch (EntityNotExistsError e) {
                throw new ActivityNotExistsException((Throwable)((Object)e));
            }
            catch (TException e) {
                throw new ActivityCompletionFailureException(e);
            }
        }
        if (this.activityId == null) {
            throw new IllegalArgumentException("Either activity id or task token are required");
        }
        RespondActivityTaskCompletedByIDRequest request = new RespondActivityTaskCompletedByIDRequest();
        request.setActivityID(this.activityId);
        byte[] convertedResult = this.dataConverter.toData(result);
        request.setResult(convertedResult);
        request.setDomain(this.domain);
        request.setWorkflowID(this.execution.getWorkflowId());
        request.setRunID(this.execution.getRunId());
        try {
            this.service.RespondActivityTaskCompletedByID(request);
            this.metricsScope.counter("cadence-activity-task-completed-by-id").inc(1L);
        }
        catch (EntityNotExistsError e) {
            throw new ActivityNotExistsException((Throwable)((Object)e));
        }
        catch (TException e) {
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (failure == null) {
            throw new IllegalArgumentException("null failure");
        }
        if (this.taskToken != null) {
            RespondActivityTaskFailedRequest request = new RespondActivityTaskFailedRequest();
            request.setReason(failure.getClass().getName());
            request.setDetails(this.dataConverter.toData(failure));
            request.setTaskToken(this.taskToken);
            try {
                RpcRetryer.retry(() -> this.service.RespondActivityTaskFailed(request));
                this.metricsScope.counter("cadence-activity-task-failed").inc(1L);
            }
            catch (EntityNotExistsError e) {
                throw new ActivityNotExistsException((Throwable)((Object)e));
            }
            catch (TException e) {
                throw new ActivityCompletionFailureException(e);
            }
        }
        RespondActivityTaskFailedByIDRequest request = new RespondActivityTaskFailedByIDRequest();
        request.setReason(failure.getClass().getName());
        request.setDetails(this.dataConverter.toData(failure));
        request.setDomain(this.domain);
        request.setWorkflowID(this.execution.getWorkflowId());
        request.setRunID(this.execution.getRunId());
        try {
            RpcRetryer.retry(() -> this.service.RespondActivityTaskFailedByID(request));
            this.metricsScope.counter("cadence-activity-task-failed-by-id").inc(1L);
        }
        catch (EntityNotExistsError e) {
            throw new ActivityNotExistsException((Throwable)((Object)e));
        }
        catch (TException e) {
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
    }

    @Override
    public void recordHeartbeat(Object details) throws CancellationException {
        block5: {
            if (this.taskToken != null) {
                RecordActivityTaskHeartbeatRequest request = new RecordActivityTaskHeartbeatRequest();
                request.setDetails(this.dataConverter.toData(details));
                request.setTaskToken(this.taskToken);
                RecordActivityTaskHeartbeatResponse status = null;
                try {
                    status = this.service.RecordActivityTaskHeartbeat(request);
                    if (status.isCancelRequested()) {
                        throw new ActivityCancelledException();
                    }
                    break block5;
                }
                catch (EntityNotExistsError e) {
                    throw new ActivityNotExistsException((Throwable)((Object)e));
                }
                catch (TException e) {
                    throw new ActivityCompletionFailureException(e);
                }
            }
            throw new UnsupportedOperationException("Heartbeating by id is not implemented by Cadence service yet.");
        }
    }

    @Override
    public void reportCancellation(Object details) {
        if (this.taskToken != null) {
            RespondActivityTaskCanceledRequest request = new RespondActivityTaskCanceledRequest();
            request.setDetails(this.dataConverter.toData(details));
            request.setTaskToken(this.taskToken);
            try {
                this.service.RespondActivityTaskCanceled(request);
                this.metricsScope.counter("cadence-activity-task-canceled").inc(1L);
            }
            catch (TException e) {
                log.info("reportCancellation", (Throwable)e);
            }
        } else {
            RespondActivityTaskCanceledByIDRequest request = new RespondActivityTaskCanceledByIDRequest();
            request.setDetails(this.dataConverter.toData(details));
            request.setDomain(this.domain);
            request.setWorkflowID(this.execution.getWorkflowId());
            request.setRunID(this.execution.getRunId());
            try {
                this.service.RespondActivityTaskCanceledByID(request);
                this.metricsScope.counter("cadence-activity-task-canceled-by-id").inc(1L);
            }
            catch (TException e) {
                log.info("reportCancellation", (Throwable)e);
            }
        }
    }
}

