/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryTaskCompletedType;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.StickyExecutionAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.replay.Decider;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.ReplayDecider;
import com.uber.cadence.internal.replay.ReplayWorkflow;
import com.uber.cadence.internal.replay.ReplayWorkflowFactory;
import com.uber.cadence.internal.worker.DecisionTaskHandler;
import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayDecisionTaskHandler
implements DecisionTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(ReplayDecisionTaskHandler.class);
    private final ReplayWorkflowFactory workflowFactory;
    private final String domain;
    private final DeciderCache cache;
    private final SingleWorkerOptions options;
    private final Duration stickyTaskListScheduleToStartTimeout;
    private IWorkflowService service;
    private String stickyTaskListName;
    private final BiFunction<LocalActivityWorker.Task, Duration, Boolean> laTaskPoller;

    public ReplayDecisionTaskHandler(String domain, ReplayWorkflowFactory asyncWorkflowFactory, DeciderCache cache, SingleWorkerOptions options, String stickyTaskListName, Duration stickyTaskListScheduleToStartTimeout, IWorkflowService service, BiFunction<LocalActivityWorker.Task, Duration, Boolean> laTaskPoller) {
        this.domain = domain;
        this.workflowFactory = asyncWorkflowFactory;
        this.cache = cache;
        this.options = options;
        this.stickyTaskListName = stickyTaskListName;
        this.stickyTaskListScheduleToStartTimeout = stickyTaskListScheduleToStartTimeout;
        this.service = Objects.requireNonNull(service);
        this.laTaskPoller = laTaskPoller;
    }

    @Override
    public DecisionTaskHandler.Result handleDecisionTask(PollForDecisionTaskResponse decisionTask) throws Exception {
        try {
            return this.handleDecisionTaskImpl(decisionTask);
        }
        catch (Throwable e) {
            this.options.getMetricsScope().counter("cadence-decision-execution-failed").inc(1L);
            if (decisionTask.getAttempt() > 0L) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw (Exception)e;
            }
            if (log.isErrorEnabled()) {
                WorkflowExecution execution = decisionTask.getWorkflowExecution();
                log.error("Workflow task failure. startedEventId=" + decisionTask.getStartedEventId() + ", WorkflowID=" + execution.getWorkflowId() + ", RunID=" + execution.getRunId() + ". If see continuously the workflow might be stuck.", e);
            }
            RespondDecisionTaskFailedRequest failedRequest = new RespondDecisionTaskFailedRequest();
            failedRequest.setTaskToken(decisionTask.getTaskToken());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String stackTrace = sw.toString();
            failedRequest.setDetails(stackTrace.getBytes(StandardCharsets.UTF_8));
            return new DecisionTaskHandler.Result(null, failedRequest, null);
        }
    }

    private DecisionTaskHandler.Result handleDecisionTaskImpl(PollForDecisionTaskResponse decisionTask) throws Throwable {
        if (decisionTask.isSetQuery()) {
            return this.processQuery(decisionTask);
        }
        return this.processDecision(decisionTask);
    }

    private DecisionTaskHandler.Result processDecision(PollForDecisionTaskResponse decisionTask) throws Throwable {
        Decider decider = null;
        AtomicBoolean createdNew = new AtomicBoolean();
        try {
            WorkflowExecution execution;
            decider = this.stickyTaskListName == null ? this.createDecider(decisionTask) : this.cache.getOrCreate(decisionTask, () -> {
                createdNew.set(true);
                return this.createDecider(decisionTask);
            });
            Decider.DecisionResult result = decider.decide(decisionTask);
            if (this.stickyTaskListName != null && createdNew.get()) {
                this.cache.addToCache(decisionTask, decider);
            }
            if (log.isTraceEnabled()) {
                execution = decisionTask.getWorkflowExecution();
                log.trace("WorkflowTask startedEventId=" + decisionTask.getStartedEventId() + ", WorkflowID=" + execution.getWorkflowId() + ", RunID=" + execution.getRunId() + " completed with " + WorkflowExecutionUtils.prettyPrintDecisions(result.getDecisions()) + " forceCreateNewDecisionTask " + result.getForceCreateNewDecisionTask());
            } else if (log.isDebugEnabled()) {
                execution = decisionTask.getWorkflowExecution();
                log.debug("WorkflowTask startedEventId=" + decisionTask.getStartedEventId() + ", WorkflowID=" + execution.getWorkflowId() + ", RunID=" + execution.getRunId() + " completed with " + result.getDecisions().size() + " new decisions forceCreateNewDecisionTask " + result.getForceCreateNewDecisionTask());
            }
            DecisionTaskHandler.Result result2 = this.createCompletedRequest(decisionTask, result);
            return result2;
        }
        catch (Throwable e) {
            if (decider != null) {
                decider.close();
            }
            if (this.stickyTaskListName != null) {
                this.cache.invalidate(decisionTask.getWorkflowExecution().getRunId());
            }
            throw e;
        }
        finally {
            if (this.stickyTaskListName == null && decider != null) {
                decider.close();
            } else {
                this.cache.markProcessingDone(decisionTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecisionTaskHandler.Result processQuery(PollForDecisionTaskResponse decisionTask) {
        RespondQueryTaskCompletedRequest queryCompletedRequest = new RespondQueryTaskCompletedRequest();
        queryCompletedRequest.setTaskToken(decisionTask.getTaskToken());
        Decider decider = null;
        AtomicBoolean createdNew = new AtomicBoolean();
        try {
            decider = this.stickyTaskListName == null ? this.createDecider(decisionTask) : this.cache.getOrCreate(decisionTask, () -> {
                createdNew.set(true);
                return this.createDecider(decisionTask);
            });
            byte[] queryResult = decider.query(decisionTask, decisionTask.getQuery());
            if (this.stickyTaskListName != null && createdNew.get()) {
                this.cache.addToCache(decisionTask, decider);
            }
            queryCompletedRequest.setQueryResult(queryResult);
            queryCompletedRequest.setCompletedType(QueryTaskCompletedType.COMPLETED);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            queryCompletedRequest.setErrorMessage(sw.toString());
            queryCompletedRequest.setCompletedType(QueryTaskCompletedType.FAILED);
        }
        finally {
            if (this.stickyTaskListName == null && decider != null) {
                decider.close();
            } else {
                this.cache.markProcessingDone(decisionTask);
            }
        }
        return new DecisionTaskHandler.Result(null, null, queryCompletedRequest);
    }

    private DecisionTaskHandler.Result createCompletedRequest(PollForDecisionTaskResponse decisionTask, Decider.DecisionResult result) {
        RespondDecisionTaskCompletedRequest completedRequest = new RespondDecisionTaskCompletedRequest();
        completedRequest.setTaskToken(decisionTask.getTaskToken());
        completedRequest.setDecisions(result.getDecisions());
        completedRequest.setForceCreateNewDecisionTask(result.getForceCreateNewDecisionTask());
        if (this.stickyTaskListName != null) {
            StickyExecutionAttributes attributes = new StickyExecutionAttributes();
            attributes.setWorkerTaskList(InternalUtils.createStickyTaskList(this.stickyTaskListName));
            attributes.setScheduleToStartTimeoutSeconds((int)this.stickyTaskListScheduleToStartTimeout.getSeconds());
            completedRequest.setStickyAttributes(attributes);
        }
        return new DecisionTaskHandler.Result(completedRequest, null, null);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return this.workflowFactory.isAnyTypeSupported();
    }

    private Decider createDecider(PollForDecisionTaskResponse decisionTask) throws Exception {
        WorkflowType workflowType = decisionTask.getWorkflowType();
        List<HistoryEvent> events = decisionTask.getHistory().getEvents();
        if (events.isEmpty() || events.get(0).getEventId() > 1L) {
            GetWorkflowExecutionHistoryRequest getHistoryRequest = new GetWorkflowExecutionHistoryRequest().setDomain(this.domain).setExecution(decisionTask.getWorkflowExecution());
            GetWorkflowExecutionHistoryResponse getHistoryResponse = this.service.GetWorkflowExecutionHistory(getHistoryRequest);
            decisionTask.setHistory(getHistoryResponse.getHistory());
            decisionTask.setNextPageToken(getHistoryResponse.getNextPageToken());
        }
        DecisionsHelper decisionsHelper = new DecisionsHelper(decisionTask, this.options);
        ReplayWorkflow workflow = this.workflowFactory.getWorkflow(workflowType);
        return new ReplayDecider(this.service, this.domain, workflowType, workflow, decisionsHelper, this.options, this.laTaskPoller);
    }
}

