/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.google.common.base.Strings;
import com.uber.cadence.ChildWorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionFailedCause;
import com.uber.cadence.ChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionStartedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTerminatedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.ExternalWorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.Header;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.ParentClosePolicy;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.TaskList;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.internal.common.RetryParameters;
import com.uber.cadence.internal.replay.ChildWorkflowTaskFailedException;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.OpenChildWorkflowRequestInfo;
import com.uber.cadence.internal.replay.OpenRequestInfo;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import com.uber.cadence.internal.replay.StartChildWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.WorkflowContext;
import com.uber.cadence.workflow.ChildWorkflowTerminatedException;
import com.uber.cadence.workflow.ChildWorkflowTimedOutException;
import com.uber.cadence.workflow.SignalExternalWorkflowException;
import com.uber.cadence.workflow.StartChildWorkflowFailedException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class WorkflowDecisionContext {
    private final DecisionsHelper decisions;
    private final WorkflowContext workflowContext;
    private final Map<Long, OpenChildWorkflowRequestInfo> scheduledExternalWorkflows = new HashMap<Long, OpenChildWorkflowRequestInfo>();
    private final Map<Long, OpenRequestInfo<Void, Void>> scheduledSignals = new HashMap<Long, OpenRequestInfo<Void, Void>>();

    WorkflowDecisionContext(DecisionsHelper decisions, WorkflowContext workflowContext) {
        this.decisions = decisions;
        this.workflowContext = workflowContext;
    }

    Consumer<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Consumer<WorkflowExecution> executionCallback, BiConsumer<byte[], Exception> callback) {
        StartChildWorkflowExecutionDecisionAttributes attributes = new StartChildWorkflowExecutionDecisionAttributes();
        attributes.setWorkflowType(parameters.getWorkflowType());
        String workflowId = parameters.getWorkflowId();
        if (workflowId == null) {
            workflowId = this.randomUUID().toString();
        }
        attributes.setWorkflowId(workflowId);
        if (parameters.getDomain() == null) {
            attributes.setDomain(this.workflowContext.getDomain());
        } else {
            attributes.setDomain(parameters.getDomain());
        }
        attributes.setInput(parameters.getInput());
        if (parameters.getExecutionStartToCloseTimeoutSeconds() == 0L) {
            attributes.setExecutionStartToCloseTimeoutSeconds(this.workflowContext.getExecutionStartToCloseTimeoutSeconds());
        } else {
            attributes.setExecutionStartToCloseTimeoutSeconds((int)parameters.getExecutionStartToCloseTimeoutSeconds());
        }
        if (parameters.getTaskStartToCloseTimeoutSeconds() == 0L) {
            attributes.setTaskStartToCloseTimeoutSeconds(this.workflowContext.getDecisionTaskTimeoutSeconds());
        } else {
            attributes.setTaskStartToCloseTimeoutSeconds((int)parameters.getTaskStartToCloseTimeoutSeconds());
        }
        String taskList = parameters.getTaskList();
        TaskList tl = new TaskList();
        if (taskList != null && !taskList.isEmpty()) {
            tl.setName(taskList);
        } else {
            tl.setName(this.workflowContext.getTaskList());
        }
        attributes.setTaskList(tl);
        attributes.setWorkflowIdReusePolicy(parameters.getWorkflowIdReusePolicy());
        RetryParameters retryParameters = parameters.getRetryParameters();
        if (retryParameters != null) {
            attributes.setRetryPolicy(retryParameters.toRetryPolicy());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getCronSchedule())) {
            attributes.setCronSchedule(parameters.getCronSchedule());
        }
        attributes.setHeader(this.toHeaderThrift(parameters.getContext()));
        ParentClosePolicy parentClosePolicy = parameters.getParentClosePolicy();
        if (parentClosePolicy != null) {
            attributes.setParentClosePolicy(parentClosePolicy);
        }
        long initiatedEventId = this.decisions.startChildWorkflowExecution(attributes);
        OpenChildWorkflowRequestInfo context = new OpenChildWorkflowRequestInfo(executionCallback);
        context.setCompletionHandle(callback);
        this.scheduledExternalWorkflows.put(initiatedEventId, context);
        return new ChildWorkflowCancellationHandler(initiatedEventId, attributes.getWorkflowId());
    }

    private Header toHeaderThrift(Map<String, byte[]> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        HashMap<String, ByteBuffer> fields = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, byte[]> item : headers.entrySet()) {
            fields.put(item.getKey(), ByteBuffer.wrap(item.getValue()));
        }
        Header headerThrift = new Header();
        headerThrift.setFields(fields);
        return headerThrift;
    }

    boolean isChildWorkflowExecutionStartedWithRetryOptions() {
        return this.decisions.isChildWorkflowExecutionInitiatedWithRetryOptions();
    }

    Consumer<Exception> signalWorkflowExecution(SignalExternalWorkflowParameters parameters, BiConsumer<Void, Exception> callback) {
        OpenRequestInfo context = new OpenRequestInfo();
        SignalExternalWorkflowExecutionDecisionAttributes attributes = new SignalExternalWorkflowExecutionDecisionAttributes();
        if (parameters.getDomain() == null) {
            attributes.setDomain(this.workflowContext.getDomain());
        } else {
            attributes.setDomain(parameters.getDomain());
        }
        String signalId = this.decisions.getAndIncrementNextId();
        attributes.setControl(signalId.getBytes(StandardCharsets.UTF_8));
        attributes.setSignalName(parameters.getSignalName());
        attributes.setInput(parameters.getInput());
        WorkflowExecution execution = new WorkflowExecution();
        execution.setRunId(parameters.getRunId());
        execution.setWorkflowId(parameters.getWorkflowId());
        attributes.setExecution(execution);
        long finalSignalId = this.decisions.signalExternalWorkflowExecution(attributes);
        context.setCompletionHandle(callback);
        this.scheduledSignals.put(finalSignalId, context);
        return e -> {
            if (!this.scheduledSignals.containsKey(finalSignalId)) {
                return;
            }
            this.decisions.cancelSignalExternalWorkflowExecution(finalSignalId, null);
            OpenRequestInfo<Void, Void> scheduled = this.scheduledSignals.remove(finalSignalId);
            if (scheduled == null) {
                throw new IllegalArgumentException("Signal \"" + finalSignalId + "\" wasn't scheduled");
            }
            callback.accept((Void)null, (Exception)e);
        };
    }

    void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelExternalWorkflowExecutionDecisionAttributes attributes = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
        String workflowId = execution.getWorkflowId();
        attributes.setWorkflowId(workflowId);
        if (execution.isSetRunId()) {
            attributes.setRunId(execution.getRunId());
        }
        this.decisions.requestCancelExternalWorkflowExecution(attributes);
    }

    void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.workflowContext.setContinueAsNewOnCompletion(continueParameters);
    }

    UUID randomUUID() {
        String runId = this.workflowContext.getCurrentRunId();
        if (runId == null) {
            throw new Error("null currentRunId");
        }
        String id = runId + ":" + this.decisions.getAndIncrementNextId();
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes);
    }

    Random newRandom() {
        return new Random(this.randomUUID().getLeastSignificantBits());
    }

    void handleChildWorkflowExecutionCanceled(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        ChildWorkflowExecutionCanceledEventAttributes attributes = event.getChildWorkflowExecutionCanceledEventAttributes();
        if (this.decisions.handleChildWorkflowExecutionCanceled(attributes) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            CancellationException e = new CancellationException();
            BiConsumer<Object, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, e);
        }
    }

    void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.getChildWorkflowExecutionStartedEventAttributes();
        this.decisions.handleChildWorkflowExecutionStarted(event);
        OpenChildWorkflowRequestInfo scheduled = this.scheduledExternalWorkflows.get(attributes.getInitiatedEventId());
        if (scheduled != null) {
            scheduled.getExecutionCallback().accept(attributes.getWorkflowExecution());
        }
    }

    void handleChildWorkflowExecutionTimedOut(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        ChildWorkflowExecutionTimedOutEventAttributes attributes = event.getChildWorkflowExecutionTimedOutEventAttributes();
        if (this.decisions.handleChildWorkflowExecutionTimedOut(attributes) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            ChildWorkflowTimedOutException failure = new ChildWorkflowTimedOutException(event.getEventId(), attributes.getWorkflowExecution(), attributes.getWorkflowType());
            BiConsumer<Object, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, failure);
        }
    }

    void handleChildWorkflowExecutionTerminated(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        ChildWorkflowExecutionTerminatedEventAttributes attributes = event.getChildWorkflowExecutionTerminatedEventAttributes();
        WorkflowExecution execution = attributes.getWorkflowExecution();
        if (this.decisions.handleChildWorkflowExecutionTerminated(attributes) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            ChildWorkflowTerminatedException failure = new ChildWorkflowTerminatedException(event.getEventId(), execution, attributes.getWorkflowType());
            BiConsumer<Object, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, failure);
        }
    }

    void handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        StartChildWorkflowExecutionFailedEventAttributes attributes = event.getStartChildWorkflowExecutionFailedEventAttributes();
        if (this.decisions.handleStartChildWorkflowExecutionFailed(event) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            WorkflowExecution workflowExecution = new WorkflowExecution();
            workflowExecution.setWorkflowId(attributes.getWorkflowId());
            WorkflowType workflowType = attributes.getWorkflowType();
            ChildWorkflowExecutionFailedCause cause = attributes.getCause();
            StartChildWorkflowFailedException failure = new StartChildWorkflowFailedException(event.getEventId(), workflowExecution, workflowType, cause);
            BiConsumer<Object, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, failure);
        }
    }

    void handleChildWorkflowExecutionFailed(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        ChildWorkflowExecutionFailedEventAttributes attributes = event.getChildWorkflowExecutionFailedEventAttributes();
        if (this.decisions.handleChildWorkflowExecutionFailed(attributes) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            String reason = attributes.getReason();
            byte[] details = attributes.getDetails();
            ChildWorkflowTaskFailedException failure = new ChildWorkflowTaskFailedException(event.getEventId(), attributes.getWorkflowExecution(), attributes.getWorkflowType(), reason, details);
            BiConsumer<Object, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, failure);
        }
    }

    void handleChildWorkflowExecutionCompleted(HistoryEvent event) {
        OpenChildWorkflowRequestInfo scheduled;
        ChildWorkflowExecutionCompletedEventAttributes attributes = event.getChildWorkflowExecutionCompletedEventAttributes();
        if (this.decisions.handleChildWorkflowExecutionCompleted(attributes) && (scheduled = this.scheduledExternalWorkflows.remove(attributes.getInitiatedEventId())) != null) {
            BiConsumer<byte[], Exception> completionCallback = scheduled.getCompletionCallback();
            byte[] result = attributes.getResult();
            completionCallback.accept(result, null);
        }
    }

    void handleSignalExternalWorkflowExecutionFailed(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalContextAndResult;
        SignalExternalWorkflowExecutionFailedEventAttributes attributes = event.getSignalExternalWorkflowExecutionFailedEventAttributes();
        long initiatedEventId = attributes.getInitiatedEventId();
        if (this.decisions.handleSignalExternalWorkflowExecutionFailed(initiatedEventId) && (signalContextAndResult = this.scheduledSignals.remove(initiatedEventId)) != null) {
            WorkflowExecution signaledExecution = new WorkflowExecution();
            signaledExecution.setWorkflowId(attributes.getWorkflowExecution().getWorkflowId());
            signaledExecution.setRunId(attributes.getWorkflowExecution().getRunId());
            SignalExternalWorkflowException failure = new SignalExternalWorkflowException(event.getEventId(), signaledExecution, attributes.getCause());
            signalContextAndResult.getCompletionCallback().accept(null, failure);
        }
    }

    void handleExternalWorkflowExecutionSignaled(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalCtxAndResult;
        ExternalWorkflowExecutionSignaledEventAttributes attributes = event.getExternalWorkflowExecutionSignaledEventAttributes();
        long initiatedEventId = attributes.getInitiatedEventId();
        if (this.decisions.handleExternalWorkflowExecutionSignaled(initiatedEventId) && (signalCtxAndResult = this.scheduledSignals.remove(initiatedEventId)) != null) {
            signalCtxAndResult.getCompletionCallback().accept(null, null);
        }
    }

    private final class ChildWorkflowCancellationHandler
    implements Consumer<Exception> {
        private final long initiatedEventId;
        private final String workflowId;

        private ChildWorkflowCancellationHandler(long initiatedEventId, String workflowId) {
            this.initiatedEventId = initiatedEventId;
            this.workflowId = Objects.requireNonNull(workflowId);
        }

        @Override
        public void accept(Exception cause) {
            if (!WorkflowDecisionContext.this.scheduledExternalWorkflows.containsKey(this.initiatedEventId)) {
                return;
            }
            RequestCancelExternalWorkflowExecutionDecisionAttributes cancelAttributes = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
            cancelAttributes.setWorkflowId(this.workflowId);
            cancelAttributes.setChildWorkflowOnly(true);
            WorkflowDecisionContext.this.decisions.requestCancelExternalWorkflowExecution(cancelAttributes);
        }
    }
}

