/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.ExternalWorkflowStubImpl;
import com.uber.cadence.internal.sync.WorkflowInvocationHandler;
import com.uber.cadence.workflow.ExternalWorkflowStub;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.SignalMethod;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ExternalWorkflowInvocationHandler
implements InvocationHandler {
    private final ExternalWorkflowStub stub;

    public ExternalWorkflowInvocationHandler(WorkflowExecution execution, WorkflowInterceptor decisionContext) {
        this.stub = new ExternalWorkflowStubImpl(execution, decisionContext);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("__getWorkflowExecution")) {
            return this.stub.getExecution();
        }
        WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
        QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
        SignalMethod signalMethod = method.getAnnotation(SignalMethod.class);
        WorkflowInvocationHandler.checkAnnotations(method, workflowMethod, queryMethod, signalMethod);
        if (workflowMethod != null) {
            throw new IllegalStateException("Cannot start a workflow with an external workflow stub created through Workflow.newExternalWorkflowStub");
        }
        if (queryMethod != null) {
            return InternalUtils.getValueOrDefault(this.queryWorkflow(method, queryMethod, args), method.getReturnType());
        }
        if (signalMethod != null) {
            this.signalWorkflow(method, signalMethod, args);
            return null;
        }
        throw new IllegalArgumentException(method + " is not annotated with @SignalMethod or @QueryMethod");
    }

    private void signalWorkflow(Method method, SignalMethod signalMethod, Object[] args) {
        String signalName = signalMethod.name();
        if (signalName.isEmpty()) {
            signalName = InternalUtils.getSimpleName(method);
        }
        this.stub.signal(signalName, args);
    }

    private Object queryWorkflow(Method method, QueryMethod queryMethod, Object[] args) {
        throw new UnsupportedOperationException("Query is not supported from workflow to workflow. Use activity that perform the query instead.");
    }
}

