/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.reflect.TypeToken;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.DataConverterException;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.ReplayWorkflow;
import com.uber.cadence.internal.replay.ReplayWorkflowFactory;
import com.uber.cadence.internal.sync.SimulatedTimeoutExceptionInternal;
import com.uber.cadence.internal.sync.SyncWorkflow;
import com.uber.cadence.internal.sync.SyncWorkflowDefinition;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.internal.worker.WorkflowExecutionException;
import com.uber.cadence.testing.SimulatedTimeoutException;
import com.uber.cadence.worker.NonDeterministicWorkflowPolicy;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.SignalMethod;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInfo;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class POJOWorkflowImplementationFactory
implements ReplayWorkflowFactory {
    private static final Logger log = LoggerFactory.getLogger(POJOWorkflowImplementationFactory.class);
    private static final byte[] EMPTY_BLOB = new byte[0];
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;
    private DataConverter dataConverter;
    private List<ContextPropagator> contextPropagators;
    private final Map<String, Functions.Func<SyncWorkflowDefinition>> workflowDefinitions = Collections.synchronizedMap(new HashMap());
    private Map<String, WorkflowImplementationOptions> implementationOptions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Functions.Func<?>> workflowImplementationFactories = Collections.synchronizedMap(new HashMap());
    private final ExecutorService threadPool;
    private DeciderCache cache;

    POJOWorkflowImplementationFactory(DataConverter dataConverter, ExecutorService threadPool, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, DeciderCache cache, List<ContextPropagator> contextPropagators) {
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
        this.cache = cache;
        this.contextPropagators = contextPropagators;
    }

    void setWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        this.workflowDefinitions.clear();
        for (Class<?> type : workflowImplementationTypes) {
            this.addWorkflowImplementationType(options, type);
        }
    }

    <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        WorkflowImplementationOptions unitTestingOptions = new WorkflowImplementationOptions.Builder().setNonDeterministicWorkflowPolicy(NonDeterministicWorkflowPolicy.FailWorkflow).build();
        this.addWorkflowImplementationFactory(unitTestingOptions, clazz, factory);
    }

    <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.workflowImplementationFactories.put(clazz, factory);
        this.addWorkflowImplementationType(options, clazz);
    }

    private void addWorkflowImplementationType(WorkflowImplementationOptions options, Class<?> workflowImplementationClass) {
        TypeToken.TypeSet interfaces = TypeToken.of(workflowImplementationClass).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("Workflow must implement at least one interface");
        }
        boolean hasWorkflowMethod = false;
        for (TypeToken i : interfaces) {
            HashMap<String, Method> signalHandlers = new HashMap<String, Method>();
            for (Method method : i.getRawType().getMethods()) {
                SignalMethod signalMethod;
                QueryMethod queryMethod;
                WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
                int count = (workflowMethod == null ? 0 : 1) + ((queryMethod = method.getAnnotation(QueryMethod.class)) == null ? 0 : 1) + ((signalMethod = method.getAnnotation(SignalMethod.class)) == null ? 0 : 1);
                if (count > 1) {
                    throw new IllegalArgumentException(method + " must contain at most one annotation from @WorkflowMethod, @QueryMethod or @SignalMethod");
                }
                if (workflowMethod != null) {
                    Functions.Func<SyncWorkflowDefinition> factory = () -> new POJOWorkflowImplementation(method, workflowImplementationClass, signalHandlers);
                    String workflowName = workflowMethod.name();
                    if (workflowName.isEmpty()) {
                        workflowName = InternalUtils.getSimpleName(method);
                    }
                    if (this.workflowDefinitions.containsKey(workflowName)) {
                        throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
                    }
                    this.workflowDefinitions.put(workflowName, factory);
                    this.implementationOptions.put(workflowName, options);
                    hasWorkflowMethod = true;
                }
                if (signalMethod != null) {
                    if (method.getReturnType() != Void.TYPE) {
                        throw new IllegalArgumentException("Method annotated with @SignalMethod must have void return type: " + method);
                    }
                    String signalName = signalMethod.name();
                    if (signalName.isEmpty()) {
                        signalName = InternalUtils.getSimpleName(method);
                    }
                    signalHandlers.put(signalName, method);
                }
                if (queryMethod == null || method.getReturnType() != Void.TYPE) continue;
                throw new IllegalArgumentException("Method annotated with @QueryMethod cannot have void return type: " + method);
            }
        }
        if (!hasWorkflowMethod) {
            throw new IllegalArgumentException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + workflowImplementationClass);
        }
    }

    private SyncWorkflowDefinition getWorkflowDefinition(WorkflowType workflowType) {
        Functions.Func<SyncWorkflowDefinition> factory = this.workflowDefinitions.get(workflowType.getName());
        if (factory == null) {
            throw new Error("Unknown workflow type \"" + workflowType.getName() + "\". Known types are " + this.workflowDefinitions.keySet());
        }
        try {
            return factory.apply();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public ReplayWorkflow getWorkflow(WorkflowType workflowType) {
        SyncWorkflowDefinition workflow = this.getWorkflowDefinition(workflowType);
        WorkflowImplementationOptions options = this.implementationOptions.get(workflowType.getName());
        return new SyncWorkflow(workflow, options, this.dataConverter, this.threadPool, this.interceptorFactory, this.cache, this.contextPropagators);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.workflowDefinitions.isEmpty();
    }

    void logSerializationException(String signalName, Long eventId, DataConverterException exception) {
        log.error("Failure deserializing signal input for \"" + signalName + "\" at eventID " + eventId + ". Dropping it.", (Throwable)exception);
        Workflow.getMetricsScope().counter("cadence-corrupted-signals").inc(1L);
    }

    static WorkflowExecutionException mapToWorkflowExecutionException(Exception failure, DataConverter dataConverter) {
        if ((failure = CheckedExceptionWrapper.unwrap(failure)) instanceof SimulatedTimeoutException) {
            SimulatedTimeoutException timeoutException = (SimulatedTimeoutException)failure;
            failure = new SimulatedTimeoutExceptionInternal(timeoutException.getTimeoutType(), dataConverter.toData(timeoutException.getDetails()));
        }
        return new WorkflowExecutionException(failure.getClass().getName(), dataConverter.toData(failure));
    }

    static WorkflowExecutionException mapError(Error failure, DataConverter dataConverter) {
        return new WorkflowExecutionException(failure.getClass().getName(), dataConverter.toData(failure));
    }

    public String toString() {
        return "POJOWorkflowImplementationFactory{registeredWorkflowTypes=" + this.workflowDefinitions.keySet() + '}';
    }

    private class POJOWorkflowImplementation
    implements SyncWorkflowDefinition {
        private final Method workflowMethod;
        private final Class<?> workflowImplementationClass;
        private final Map<String, Method> signalHandlers;
        private Object workflow;

        POJOWorkflowImplementation(Method method, Class<?> workflowImplementationClass, Map<String, Method> signalHandlers) {
            this.workflowMethod = method;
            this.workflowImplementationClass = workflowImplementationClass;
            this.signalHandlers = signalHandlers;
        }

        @Override
        public byte[] execute(byte[] input) throws CancellationException, WorkflowExecutionException {
            Object[] args = POJOWorkflowImplementationFactory.this.dataConverter.fromDataArray(input, this.workflowMethod.getGenericParameterTypes());
            try {
                this.newInstance();
                Object result = this.workflowMethod.invoke(this.workflow, args);
                if (this.workflowMethod.getReturnType() == Void.TYPE) {
                    return EMPTY_BLOB;
                }
                return POJOWorkflowImplementationFactory.this.dataConverter.toData(result);
            }
            catch (IllegalAccessException e) {
                throw new Error(POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(e, POJOWorkflowImplementationFactory.this.dataConverter));
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                if (targetException instanceof CancellationException) {
                    throw (CancellationException)targetException;
                }
                if (log.isErrorEnabled()) {
                    WorkflowInfo context = Workflow.getWorkflowInfo();
                    log.error("Workflow execution failure WorkflowID=" + context.getWorkflowId() + ", RunID=" + context.getRunId() + ", WorkflowType=" + context.getWorkflowType(), targetException);
                }
                throw POJOWorkflowImplementationFactory.mapToWorkflowExecutionException((Exception)targetException, POJOWorkflowImplementationFactory.this.dataConverter);
            }
        }

        private void newInstance() {
            if (this.workflow == null) {
                Functions.Func factory = (Functions.Func)POJOWorkflowImplementationFactory.this.workflowImplementationFactories.get(this.workflowImplementationClass);
                if (factory != null) {
                    this.workflow = factory.apply();
                } else {
                    try {
                        this.workflow = this.workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new Error("Failure instantiating workflow implementation class " + this.workflowImplementationClass.getName(), e);
                    }
                }
                WorkflowInternal.registerQuery(this.workflow);
            }
        }

        @Override
        public void processSignal(String signalName, byte[] input, long eventId) {
            Method signalMethod = this.signalHandlers.get(signalName);
            if (signalMethod == null) {
                log.error("Unknown signal: " + signalName + " at eventID " + eventId + ", knownSignals=" + this.signalHandlers.keySet());
                return;
            }
            try {
                Object[] args = POJOWorkflowImplementationFactory.this.dataConverter.fromDataArray(input, signalMethod.getGenericParameterTypes());
                this.newInstance();
                signalMethod.invoke(this.workflow, args);
            }
            catch (IllegalAccessException e) {
                String errorMessage = "Failed to process signal \"" + signalName + "\" at eventID " + eventId + ".";
                log.error(errorMessage + "\n" + e);
                throw new Error(errorMessage + " Check cause for details.", e);
            }
            catch (DataConverterException e) {
                POJOWorkflowImplementationFactory.this.logSerializationException(signalName, eventId, e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof DataConverterException) {
                    POJOWorkflowImplementationFactory.this.logSerializationException(signalName, eventId, (DataConverterException)targetException);
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                String errorMessage = "Failed to process signal \"" + signalName + "\" at eventID " + eventId + ".";
                log.error(errorMessage + "\n" + targetException);
                throw new Error(errorMessage + " Check cause for details.", targetException);
            }
        }
    }
}

