/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.QueryRejectCondition;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.client.DuplicateWorkflowException;
import com.uber.cadence.client.WorkflowClientOptions;
import com.uber.cadence.client.WorkflowException;
import com.uber.cadence.client.WorkflowFailureException;
import com.uber.cadence.client.WorkflowNotFoundException;
import com.uber.cadence.client.WorkflowOptions;
import com.uber.cadence.client.WorkflowQueryException;
import com.uber.cadence.client.WorkflowQueryRejectedException;
import com.uber.cadence.client.WorkflowServiceException;
import com.uber.cadence.client.WorkflowStub;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.DataConverterException;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.SignalWithStartWorkflowExecutionParameters;
import com.uber.cadence.internal.common.StartWorkflowExecutionParameters;
import com.uber.cadence.internal.common.WorkflowExecutionFailedException;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.external.GenericWorkflowClientExternal;
import com.uber.cadence.internal.replay.QueryWorkflowParameters;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

class WorkflowStubImpl
implements WorkflowStub {
    private final GenericWorkflowClientExternal genericClient;
    private final DataConverter dataConverter;
    private final Optional<String> workflowType;
    private AtomicReference<WorkflowExecution> execution = new AtomicReference();
    private final Optional<WorkflowOptions> options;
    private final WorkflowClientOptions clientOptions;

    WorkflowStubImpl(WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, Optional<String> workflowType, WorkflowExecution execution) {
        this.clientOptions = clientOptions;
        this.genericClient = genericClient;
        this.dataConverter = clientOptions.getDataConverter();
        this.workflowType = workflowType;
        if (execution == null || execution.getWorkflowId() == null || execution.getWorkflowId().isEmpty()) {
            throw new IllegalArgumentException("null or empty workflowId");
        }
        this.execution.set(execution);
        this.options = Optional.empty();
    }

    WorkflowStubImpl(WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, String workflowType, WorkflowOptions options) {
        this.clientOptions = clientOptions;
        this.genericClient = genericClient;
        this.dataConverter = clientOptions.getDataConverter();
        this.workflowType = Optional.of(workflowType);
        this.options = Optional.of(options);
    }

    @Override
    public void signal(String signalName, Object ... input) {
        SignalExternalWorkflowParameters p = this.getSignalExternalWorkflowParameters(signalName, input);
        try {
            this.genericClient.signalWorkflowExecution(p);
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType, e);
        }
    }

    @Override
    public CompletableFuture<Void> signalAsync(String signalName, Object ... input) {
        return this.signalAsyncWithTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS, signalName, input);
    }

    @Override
    public CompletableFuture<Void> signalAsyncWithTimeout(long timeout, TimeUnit unit, String signalName, Object ... input) {
        SignalExternalWorkflowParameters p = this.getSignalExternalWorkflowParameters(signalName, input);
        return this.genericClient.signalWorkflowExecutionAsync(p, unit.toMillis(timeout));
    }

    private SignalExternalWorkflowParameters getSignalExternalWorkflowParameters(String signalName, Object ... input) {
        this.checkStarted();
        SignalExternalWorkflowParameters p = new SignalExternalWorkflowParameters();
        p.setInput(this.dataConverter.toData(input));
        p.setSignalName(signalName);
        p.setWorkflowId(this.execution.get().getWorkflowId());
        return p;
    }

    private WorkflowExecution startWithOptions(WorkflowOptions o, Object ... args) {
        StartWorkflowExecutionParameters p = this.getStartWorkflowExecutionParameters(o, args);
        try {
            this.execution.set(this.genericClient.startWorkflow(p));
        }
        catch (WorkflowExecutionAlreadyStartedError e) {
            this.execution.set(new WorkflowExecution().setWorkflowId(p.getWorkflowId()).setRunId(e.getRunId()));
            WorkflowExecution execution = new WorkflowExecution().setWorkflowId(p.getWorkflowId()).setRunId(e.getRunId());
            throw new DuplicateWorkflowException(execution, this.workflowType.get(), e.getMessage());
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType, e);
        }
        return this.execution.get();
    }

    private CompletableFuture<WorkflowExecution> startAsyncWithOptions(long timeout, TimeUnit unit, WorkflowOptions o, Object ... args) {
        StartWorkflowExecutionParameters p = this.getStartWorkflowExecutionParameters(o, args);
        return this.genericClient.startWorkflowAsync(p, unit.toMillis(timeout));
    }

    private StartWorkflowExecutionParameters getStartWorkflowExecutionParameters(WorkflowOptions o, Object[] args) {
        if (this.execution.get() != null) {
            throw new DuplicateWorkflowException(this.execution.get(), this.workflowType.get(), "Cannot reuse a stub instance to start more than one workflow execution. The stub points to already started execution.");
        }
        StartWorkflowExecutionParameters p = StartWorkflowExecutionParameters.fromWorkflowOptions(o);
        if (o.getWorkflowId() == null) {
            p.setWorkflowId(UUID.randomUUID().toString());
        } else {
            p.setWorkflowId(o.getWorkflowId());
        }
        p.setInput(this.dataConverter.toData(args));
        p.setWorkflowType(new WorkflowType().setName(this.workflowType.get()));
        p.setMemo(this.convertMemoFromObjectToBytes(o.getMemo()));
        p.setSearchAttributes(this.convertSearchAttributesFromObjectToBytes(o.getSearchAttributes()));
        p.setContext(this.extractContextsAndConvertToBytes(o.getContextPropagators()));
        return p;
    }

    private Map<String, byte[]> convertMapFromObjectToBytes(Map<String, Object> map, DataConverter dataConverter) {
        if (map == null) {
            return null;
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            try {
                result.put(item.getKey(), dataConverter.toData(item.getValue()));
            }
            catch (DataConverterException e) {
                throw new DataConverterException("Cannot serialize key " + item.getKey(), e.getCause());
            }
        }
        return result;
    }

    private Map<String, byte[]> convertMemoFromObjectToBytes(Map<String, Object> map) {
        return this.convertMapFromObjectToBytes(map, this.dataConverter);
    }

    private Map<String, byte[]> convertSearchAttributesFromObjectToBytes(Map<String, Object> map) {
        return this.convertMapFromObjectToBytes(map, JsonDataConverter.getInstance());
    }

    private Map<String, byte[]> extractContextsAndConvertToBytes(List<ContextPropagator> contextPropagators) {
        if (contextPropagators == null || contextPropagators.isEmpty()) {
            return null;
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (ContextPropagator propagator : contextPropagators) {
            result.putAll(propagator.serializeContext(propagator.getCurrentContext()));
        }
        return result;
    }

    @Override
    public WorkflowExecution start(Object ... args) {
        if (!this.options.isPresent()) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.startWithOptions(WorkflowOptions.merge(null, null, null, this.options.get()), args);
    }

    @Override
    public CompletableFuture<WorkflowExecution> startAsync(Object ... args) {
        return this.startAsyncWithTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS, args);
    }

    @Override
    public CompletableFuture<WorkflowExecution> startAsyncWithTimeout(long timeout, TimeUnit unit, Object ... args) {
        if (!this.options.isPresent()) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        CompletableFuture<WorkflowExecution> result = this.startAsyncWithOptions(timeout, unit, WorkflowOptions.merge(null, null, null, this.options.get()), args);
        return result.whenComplete((input, exception) -> {
            if (input != null) {
                this.execution.set(new WorkflowExecution().setWorkflowId(input.getWorkflowId()).setRunId(input.getRunId()));
            }
        });
    }

    private WorkflowExecution signalWithStartWithOptions(WorkflowOptions options, String signalName, Object[] signalArgs, Object[] startArgs) {
        StartWorkflowExecutionParameters sp = this.getStartWorkflowExecutionParameters(options, startArgs);
        byte[] signalInput = this.dataConverter.toData(signalArgs);
        SignalWithStartWorkflowExecutionParameters p = new SignalWithStartWorkflowExecutionParameters(sp, signalName, signalInput);
        try {
            this.execution.set(this.genericClient.signalWithStartWorkflowExecution(p));
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType, e);
        }
        return this.execution.get();
    }

    @Override
    public WorkflowExecution signalWithStart(String signalName, Object[] signalArgs, Object[] startArgs) {
        if (!this.options.isPresent()) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.signalWithStartWithOptions(WorkflowOptions.merge(null, null, null, this.options.get()), signalName, signalArgs, startArgs);
    }

    @Override
    public Optional<String> getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution.get();
    }

    @Override
    public <R> R getResult(Class<R> resultClass) {
        return this.getResult(resultClass, resultClass);
    }

    @Override
    public <R> R getResult(Class<R> resultClass, Type resultType) {
        try {
            return this.getResult(Long.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
        }
        catch (TimeoutException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass) throws TimeoutException {
        return this.getResult(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) throws TimeoutException {
        this.checkStarted();
        try {
            byte[] resultValue = WorkflowExecutionUtils.getWorkflowExecutionResult(this.genericClient.getService(), this.genericClient.getDomain(), this.execution.get(), this.workflowType, timeout, unit);
            if (resultValue == null) {
                return null;
            }
            return this.dataConverter.fromData(resultValue, resultClass, resultType);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            return this.mapToWorkflowFailureException(e, resultClass);
        }
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass) {
        return this.getResultAsync(resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass, Type resultType) {
        return this.getResultAsync(Long.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass) {
        return this.getResultAsync(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) {
        this.checkStarted();
        return WorkflowExecutionUtils.getWorkflowExecutionResultAsync(this.genericClient.getService(), this.genericClient.getDomain(), this.execution.get(), this.workflowType, timeout, unit).handle((r, e) -> {
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof WorkflowExecutionFailedException) {
                return this.mapToWorkflowFailureException((WorkflowExecutionFailedException)e, resultClass);
            }
            if (e != null) {
                throw CheckedExceptionWrapper.wrap(e);
            }
            if (r == null) {
                return null;
            }
            return this.dataConverter.fromData((byte[])r, resultClass, resultType);
        });
    }

    private <R> R mapToWorkflowFailureException(Exception failure, Class<R> returnType) {
        if ((failure = CheckedExceptionWrapper.unwrap(failure)) instanceof WorkflowExecutionFailedException) {
            Class<?> detailsClass;
            WorkflowExecutionFailedException executionFailed = (WorkflowExecutionFailedException)failure;
            try {
                Class<?> dc;
                detailsClass = dc = Class.forName(executionFailed.getReason());
            }
            catch (Exception e) {
                RuntimeException ee = new RuntimeException("Couldn't deserialize failure cause as the reason field is expected to contain an exception class name", executionFailed);
                throw new WorkflowFailureException(this.execution.get(), this.workflowType, executionFailed.getDecisionTaskCompletedEventId(), (Throwable)ee);
            }
            Throwable cause = (Throwable)this.dataConverter.fromData(executionFailed.getDetails(), detailsClass, detailsClass);
            throw new WorkflowFailureException(this.execution.get(), this.workflowType, executionFailed.getDecisionTaskCompletedEventId(), cause);
        }
        if (failure instanceof EntityNotExistsError) {
            throw new WorkflowNotFoundException(this.execution.get(), this.workflowType, failure.getMessage());
        }
        if (failure instanceof CancellationException) {
            throw (CancellationException)failure;
        }
        if (failure instanceof WorkflowException) {
            throw (WorkflowException)failure;
        }
        throw new WorkflowServiceException(this.execution.get(), this.workflowType, failure);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Object ... args) {
        return this.query(queryType, resultClass, resultClass, args);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Type resultType, Object ... args) {
        return this.query(queryType, resultClass, resultType, this.clientOptions.getQueryRejectCondition(), args);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, QueryRejectCondition queryRejectCondition, Object ... args) {
        return this.query(queryType, resultClass, resultClass, queryRejectCondition, args);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Type resultType, QueryRejectCondition queryRejectCondition, Object ... args) {
        QueryWorkflowResponse result;
        this.checkStarted();
        QueryWorkflowParameters p = new QueryWorkflowParameters();
        p.setInput(this.dataConverter.toData(args));
        p.setQueryType(queryType);
        p.setWorkflowId(this.execution.get().getWorkflowId());
        p.setQueryRejectCondition(queryRejectCondition);
        try {
            result = this.genericClient.queryWorkflow(p);
        }
        catch (RuntimeException e) {
            Exception unwrapped = CheckedExceptionWrapper.unwrap(e);
            if (unwrapped instanceof EntityNotExistsError) {
                throw new WorkflowNotFoundException(this.execution.get(), this.workflowType, e.getMessage());
            }
            if (unwrapped instanceof QueryFailedError) {
                throw new WorkflowQueryException(this.execution.get(), unwrapped.getMessage());
            }
            if (unwrapped instanceof InternalServiceError) {
                throw new WorkflowServiceException(this.execution.get(), this.workflowType, unwrapped);
            }
            throw e;
        }
        if (result.queryRejected == null) {
            return this.dataConverter.fromData(result.getQueryResult(), resultClass, resultType);
        }
        throw new WorkflowQueryRejectedException(this.execution.get(), queryRejectCondition, result.getQueryRejected().getCloseStatus());
    }

    @Override
    public void cancel() {
        if (this.execution.get() == null || this.execution.get().getWorkflowId() == null) {
            return;
        }
        this.genericClient.requestCancelWorkflowExecution(new WorkflowExecution().setWorkflowId(this.execution.get().getWorkflowId()));
    }

    @Override
    public Optional<WorkflowOptions> getOptions() {
        return this.options;
    }

    private void checkStarted() {
        if (this.execution.get() == null || this.execution.get().getWorkflowId() == null) {
            throw new IllegalStateException("Null workflowId. Was workflow started?");
        }
    }
}

